/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.internal.Locks;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionFactory;
import com.mongodb.internal.connection.InternalOperationContextFactory;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.RoundTripTimeSampler;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.inject.Provider;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.types.ObjectId;

@ThreadSafe
class DefaultServerMonitor
implements com.mongodb.internal.connection.ServerMonitor {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private static final StructuredLogger STRUCTURED_LOGGER = new StructuredLogger("cluster");
    private final ServerId serverId;
    private final ServerMonitorListener serverMonitorListener;
    private final Provider<SdamServerDescriptionManager> sdamProvider;
    private final InternalOperationContextFactory operationContextFactory;
    private final InternalConnectionFactory internalConnectionFactory;
    private final ClusterConnectionMode clusterConnectionMode;
    @Nullable
    private final ServerApi serverApi;
    private final boolean isFunctionAsAServiceEnvironment;
    private final ServerSettings serverSettings;
    private final ServerMonitor monitor;
    @Nullable
    private RoundTripTimeMonitor roundTripTimeMonitor;
    private final RoundTripTimeSampler roundTripTimeSampler = new RoundTripTimeSampler();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean isClosed;

    DefaultServerMonitor(ServerId serverId, ServerSettings serverSettings, InternalConnectionFactory internalConnectionFactory, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, boolean isFunctionAsAServiceEnvironment, Provider<SdamServerDescriptionManager> sdamProvider, InternalOperationContextFactory operationContextFactory) {
        this.serverSettings = Assertions.notNull("serverSettings", serverSettings);
        this.serverId = Assertions.notNull("serverId", serverId);
        this.serverMonitorListener = EventListenerHelper.singleServerMonitorListener(serverSettings);
        this.internalConnectionFactory = Assertions.notNull("internalConnectionFactory", internalConnectionFactory);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.operationContextFactory = Assertions.assertNotNull(operationContextFactory);
        this.serverApi = serverApi;
        this.isFunctionAsAServiceEnvironment = isFunctionAsAServiceEnvironment;
        this.sdamProvider = sdamProvider;
        this.monitor = new ServerMonitor();
        this.roundTripTimeMonitor = null;
        this.isClosed = false;
    }

    @Override
    public void start() {
        DefaultServerMonitor.logStartedServerMonitoring(this.serverId);
        this.monitor.start();
    }

    private void ensureRoundTripTimeMonitorStarted() {
        Locks.withLock(this.lock, () -> {
            if (!this.isClosed && this.roundTripTimeMonitor == null) {
                this.roundTripTimeMonitor = new RoundTripTimeMonitor();
                this.roundTripTimeMonitor.start();
            }
        });
    }

    @Override
    public void connect() {
        Locks.withLock(this.lock, this.condition::signal);
    }

    @Override
    public void close() {
        Locks.withLock(this.lock, () -> {
            if (!this.isClosed) {
                DefaultServerMonitor.logStoppedServerMonitoring(this.serverId);
            }
            this.isClosed = true;
            try (ServerMonitor ignoredAutoClosed = this.monitor;){
                RoundTripTimeMonitor ignoredAutoClose2 = this.roundTripTimeMonitor;
                if (ignoredAutoClose2 != null) {
                    ignoredAutoClose2.close();
                }
            }
        });
    }

    @Override
    public void cancelCurrentCheck() {
        this.monitor.cancelCurrentCheck();
    }

    ServerMonitor getServerMonitor() {
        return this.monitor;
    }

    static boolean shouldLogStageChange(ServerDescription previous, ServerDescription current) {
        String thatExceptionMessage;
        Class<?> thatExceptionClass;
        if (previous.isOk() != current.isOk()) {
            return true;
        }
        if (!previous.getAddress().equals(current.getAddress())) {
            return true;
        }
        String previousCanonicalAddress = previous.getCanonicalAddress();
        if (previousCanonicalAddress != null ? !previousCanonicalAddress.equals(current.getCanonicalAddress()) : current.getCanonicalAddress() != null) {
            return true;
        }
        if (!previous.getHosts().equals(current.getHosts())) {
            return true;
        }
        if (!previous.getArbiters().equals(current.getArbiters())) {
            return true;
        }
        if (!previous.getPassives().equals(current.getPassives())) {
            return true;
        }
        String previousPrimary = previous.getPrimary();
        if (previousPrimary != null ? !previousPrimary.equals(current.getPrimary()) : current.getPrimary() != null) {
            return true;
        }
        String previousSetName = previous.getSetName();
        if (previousSetName != null ? !previousSetName.equals(current.getSetName()) : current.getSetName() != null) {
            return true;
        }
        if (previous.getState() != current.getState()) {
            return true;
        }
        if (!previous.getTagSet().equals(current.getTagSet())) {
            return true;
        }
        if (previous.getType() != current.getType()) {
            return true;
        }
        if (previous.getMaxWireVersion() != current.getMaxWireVersion()) {
            return true;
        }
        ObjectId previousElectionId = previous.getElectionId();
        if (previousElectionId != null ? !previousElectionId.equals((Object)current.getElectionId()) : current.getElectionId() != null) {
            return true;
        }
        Integer setVersion = previous.getSetVersion();
        if (setVersion != null ? !setVersion.equals(current.getSetVersion()) : current.getSetVersion() != null) {
            return true;
        }
        Throwable previousException = previous.getException();
        Throwable currentException = current.getException();
        Class<?> thisExceptionClass = previousException != null ? previousException.getClass() : null;
        Class<?> clazz = thatExceptionClass = currentException != null ? currentException.getClass() : null;
        if (!Objects.equals(thisExceptionClass, thatExceptionClass)) {
            return true;
        }
        String thisExceptionMessage = previousException != null ? previousException.getMessage() : null;
        String string = thatExceptionMessage = currentException != null ? currentException.getMessage() : null;
        return !Objects.equals(thisExceptionMessage, thatExceptionMessage);
    }

    private void waitForNext() throws InterruptedException {
        Thread.sleep(this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS));
    }

    private String getHandshakeCommandName(ServerDescription serverDescription) {
        return serverDescription.isHelloOk() ? "hello" : "isMaster";
    }

    private static void logHeartbeatStarted(ServerId serverId, ConnectionDescription connectionDescription, boolean awaited) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, serverId.getClusterId())) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.TOPOLOGY, LogMessage.Level.DEBUG, "Server heartbeat started", serverId.getClusterId(), Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, serverId.getAddress().getHost()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, serverId.getAddress().getPort()), new LogMessage.Entry(LogMessage.Entry.Name.DRIVER_CONNECTION_ID, connectionDescription.getConnectionId().getLocalValue()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_CONNECTION_ID, connectionDescription.getConnectionId().getServerValue()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_ID, serverId.getClusterId()), new LogMessage.Entry(LogMessage.Entry.Name.AWAITED, awaited)), "Heartbeat started for {}:{} on connection with driver-generated ID {} and server-generated ID {} in topology with ID {}. Awaited: {}"));
        }
    }

    private static void logHeartbeatSucceeded(ServerId serverId, ConnectionDescription connectionDescription, boolean awaited, long elapsedTimeNanos, BsonDocument reply) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, serverId.getClusterId())) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.TOPOLOGY, LogMessage.Level.DEBUG, "Server heartbeat succeeded", serverId.getClusterId(), Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, TimeUnit.MILLISECONDS.convert(elapsedTimeNanos, TimeUnit.NANOSECONDS)), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, serverId.getAddress().getHost()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, serverId.getAddress().getPort()), new LogMessage.Entry(LogMessage.Entry.Name.DRIVER_CONNECTION_ID, connectionDescription.getConnectionId().getLocalValue()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_CONNECTION_ID, connectionDescription.getConnectionId().getServerValue()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_ID, serverId.getClusterId()), new LogMessage.Entry(LogMessage.Entry.Name.AWAITED, awaited), new LogMessage.Entry(LogMessage.Entry.Name.REPLY, reply.toJson())), "Heartbeat succeeded in {} ms for {}:{} on connection with driver-generated ID {} and server-generated ID {} in topology with ID {}. Awaited: {}. Reply: {}"));
        }
    }

    private static void logHeartbeatFailed(ServerId serverId, ConnectionDescription connectionDescription, boolean awaited, long elapsedTimeNanos, Exception failure) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, serverId.getClusterId())) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.TOPOLOGY, LogMessage.Level.DEBUG, "Server heartbeat failed", serverId.getClusterId(), Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, TimeUnit.MILLISECONDS.convert(elapsedTimeNanos, TimeUnit.NANOSECONDS)), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, serverId.getAddress().getHost()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, serverId.getAddress().getPort()), new LogMessage.Entry(LogMessage.Entry.Name.DRIVER_CONNECTION_ID, connectionDescription.getConnectionId().getLocalValue()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_CONNECTION_ID, connectionDescription.getConnectionId().getServerValue()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_ID, serverId.getClusterId()), new LogMessage.Entry(LogMessage.Entry.Name.AWAITED, awaited), new LogMessage.Entry(LogMessage.Entry.Name.FAILURE, failure.getMessage())), "Heartbeat failed in {} ms for {}:{} on connection with driver-generated ID {} and server-generated ID {} in topology with ID {}. Awaited: {}. Failure: {}"));
        }
    }

    private static void logStartedServerMonitoring(ServerId serverId) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, serverId.getClusterId())) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.TOPOLOGY, LogMessage.Level.DEBUG, "Starting server monitoring", serverId.getClusterId(), Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, serverId.getAddress().getHost()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, serverId.getAddress().getPort()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_ID, serverId.getClusterId())), "Starting monitoring for server {}:{} in topology with ID {}"));
        }
    }

    private static void logStoppedServerMonitoring(ServerId serverId) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, serverId.getClusterId())) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.TOPOLOGY, LogMessage.Level.DEBUG, "Stopped server monitoring", serverId.getClusterId(), Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, serverId.getAddress().getHost()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, serverId.getAddress().getPort()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_ID, serverId.getClusterId())), "Stopped monitoring for server {}:{} in topology with ID {}"));
        }
    }

    class ServerMonitor
    extends Thread
    implements AutoCloseable {
        private volatile InternalConnection connection;
        private volatile boolean alreadyLoggedHeartBeatStarted;
        private volatile boolean currentCheckCancelled;
        private volatile long lookupStartTimeNanos;

        ServerMonitor() {
            super("cluster-" + DefaultServerMonitor.this.serverId.getClusterId() + "-" + DefaultServerMonitor.this.serverId.getAddress());
            this.connection = null;
            this.alreadyLoggedHeartBeatStarted = false;
            this.setDaemon(true);
        }

        @Override
        public void close() {
            this.interrupt();
            InternalConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }

        @Override
        public void run() {
            ServerDescription currentServerDescription = ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, null);
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    ServerDescription previousServerDescription = currentServerDescription;
                    boolean shouldStreamResponses = this.shouldStreamResponses(currentServerDescription = this.lookupServerDescription(currentServerDescription));
                    if (shouldStreamResponses) {
                        DefaultServerMonitor.this.ensureRoundTripTimeMonitorStarted();
                    }
                    if (DefaultServerMonitor.this.isClosed) continue;
                    if (this.currentCheckCancelled) {
                        this.waitForNext();
                        this.currentCheckCancelled = false;
                        continue;
                    }
                    this.logStateChange(previousServerDescription, currentServerDescription);
                    ((SdamServerDescriptionManager)DefaultServerMonitor.this.sdamProvider.get()).monitorUpdate(currentServerDescription);
                    if (shouldStreamResponses && currentServerDescription.getType() != ServerType.UNKNOWN || this.connection != null && this.connection.hasMoreToCome() || currentServerDescription.getException() instanceof MongoSocketException && previousServerDescription.getType() != ServerType.UNKNOWN) continue;
                    this.waitForNext();
                }
            }
            catch (MongoInterruptedException | InterruptedException previousServerDescription) {
            }
            catch (Throwable t) {
                LOGGER.error(String.format("%s for %s stopped working. You may want to recreate the MongoClient", this, DefaultServerMonitor.this.serverId), t);
                throw t;
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private ServerDescription lookupServerDescription(ServerDescription currentServerDescription) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Checking status of %s", DefaultServerMonitor.this.serverId.getAddress()));
                }
                boolean shouldStreamResponses = this.shouldStreamResponses(currentServerDescription);
                this.lookupStartTimeNanos = System.nanoTime();
                if (this.connection == null || this.connection.isClosed()) {
                    return this.setupNewConnectionAndGetInitialDescription(shouldStreamResponses);
                }
                if (!this.alreadyLoggedHeartBeatStarted) {
                    this.logAndNotifyHeartbeatStarted(shouldStreamResponses);
                }
                return this.doHeartbeat(currentServerDescription, shouldStreamResponses);
            }
            catch (Exception t) {
                DefaultServerMonitor.this.roundTripTimeSampler.reset();
                InternalConnection localConnection = Locks.withLock(DefaultServerMonitor.this.lock, () -> {
                    InternalConnection result = this.connection;
                    this.connection = null;
                    return result;
                });
                if (localConnection != null) {
                    localConnection.close();
                }
                return ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, t);
            }
        }

        private ServerDescription setupNewConnectionAndGetInitialDescription(boolean shouldStreamResponses) {
            this.connection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
            this.logAndNotifyHeartbeatStarted(shouldStreamResponses);
            try {
                this.connection.open(DefaultServerMonitor.this.operationContextFactory.create());
                DefaultServerMonitor.this.roundTripTimeSampler.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
                return this.connection.getInitialServerDescription();
            }
            catch (Exception e) {
                this.logAndNotifyHeartbeatFailed(shouldStreamResponses, e);
                throw e;
            }
        }

        private ServerDescription doHeartbeat(ServerDescription currentServerDescription, boolean shouldStreamResponses) {
            try {
                OperationContext operationContext = DefaultServerMonitor.this.operationContextFactory.create();
                if (!this.connection.hasMoreToCome()) {
                    BsonDocument helloDocument = new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(currentServerDescription), (BsonValue)new BsonInt32(1)).append("helloOk", (BsonValue)BsonBoolean.TRUE);
                    if (shouldStreamResponses) {
                        helloDocument.append("topologyVersion", (BsonValue)Assertions.assertNotNull(currentServerDescription.getTopologyVersion()).asDocument());
                        helloDocument.append("maxAwaitTimeMS", (BsonValue)new BsonInt64(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)));
                    }
                    this.connection.send(this.createCommandMessage(helloDocument, this.connection, currentServerDescription), new BsonDocumentCodec(), operationContext);
                }
                BsonDocument helloResult = shouldStreamResponses ? (BsonDocument)this.connection.receive(new BsonDocumentCodec(), this.operationContextWithAdditionalTimeout(operationContext)) : (BsonDocument)this.connection.receive(new BsonDocumentCodec(), operationContext);
                this.logAndNotifyHeartbeatSucceeded(shouldStreamResponses, helloResult);
                return DescriptionHelper.createServerDescription(DefaultServerMonitor.this.serverId.getAddress(), helloResult, DefaultServerMonitor.this.roundTripTimeSampler.getAverage(), DefaultServerMonitor.this.roundTripTimeSampler.getMin());
            }
            catch (Exception e) {
                this.logAndNotifyHeartbeatFailed(shouldStreamResponses, e);
                throw e;
            }
        }

        private void logAndNotifyHeartbeatStarted(boolean shouldStreamResponses) {
            this.alreadyLoggedHeartBeatStarted = true;
            DefaultServerMonitor.logHeartbeatStarted(DefaultServerMonitor.this.serverId, this.connection.getDescription(), shouldStreamResponses);
            DefaultServerMonitor.this.serverMonitorListener.serverHearbeatStarted(new ServerHeartbeatStartedEvent(this.connection.getDescription().getConnectionId(), shouldStreamResponses));
        }

        private void logAndNotifyHeartbeatSucceeded(boolean shouldStreamResponses, BsonDocument helloResult) {
            this.alreadyLoggedHeartBeatStarted = false;
            long elapsedTimeNanos = this.getElapsedTimeNanos();
            if (!shouldStreamResponses) {
                DefaultServerMonitor.this.roundTripTimeSampler.addSample(elapsedTimeNanos);
            }
            DefaultServerMonitor.logHeartbeatSucceeded(DefaultServerMonitor.this.serverId, this.connection.getDescription(), shouldStreamResponses, elapsedTimeNanos, helloResult);
            DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatSucceeded(new ServerHeartbeatSucceededEvent(this.connection.getDescription().getConnectionId(), helloResult, elapsedTimeNanos, shouldStreamResponses));
        }

        private void logAndNotifyHeartbeatFailed(boolean shouldStreamResponses, Exception e) {
            this.alreadyLoggedHeartBeatStarted = false;
            long elapsedTimeNanos = this.getElapsedTimeNanos();
            DefaultServerMonitor.logHeartbeatFailed(DefaultServerMonitor.this.serverId, this.connection.getDescription(), shouldStreamResponses, elapsedTimeNanos, e);
            DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatFailed(new ServerHeartbeatFailedEvent(this.connection.getDescription().getConnectionId(), elapsedTimeNanos, shouldStreamResponses, e));
        }

        private long getElapsedTimeNanos() {
            return System.nanoTime() - this.lookupStartTimeNanos;
        }

        private OperationContext operationContextWithAdditionalTimeout(OperationContext originalOperationContext) {
            TimeoutContext newTimeoutContext = originalOperationContext.getTimeoutContext().withAdditionalReadTimeout(Math.toIntExact(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)));
            return originalOperationContext.withTimeoutContext(newTimeoutContext);
        }

        private boolean shouldStreamResponses(ServerDescription currentServerDescription) {
            boolean serverSupportsStreaming = currentServerDescription.getTopologyVersion() != null;
            switch (DefaultServerMonitor.this.serverSettings.getServerMonitoringMode()) {
                case STREAM: {
                    return serverSupportsStreaming;
                }
                case POLL: {
                    return false;
                }
                case AUTO: {
                    return !DefaultServerMonitor.this.isFunctionAsAServiceEnvironment && serverSupportsStreaming;
                }
            }
            throw Assertions.fail();
        }

        private CommandMessage createCommandMessage(BsonDocument command, InternalConnection connection, ServerDescription currentServerDescription) {
            return new CommandMessage("admin", command, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), MessageSettings.builder().maxWireVersion(connection.getDescription().getMaxWireVersion()).build(), this.shouldStreamResponses(currentServerDescription), DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi);
        }

        private void logStateChange(ServerDescription previousServerDescription, ServerDescription currentServerDescription) {
            if (DefaultServerMonitor.shouldLogStageChange(previousServerDescription, currentServerDescription)) {
                if (currentServerDescription.getException() != null) {
                    LOGGER.info(String.format("Exception in monitor thread while connecting to server %s", DefaultServerMonitor.this.serverId.getAddress()), Assertions.assertNotNull(currentServerDescription.getException()));
                } else {
                    LOGGER.info(String.format("Monitor thread successfully connected to server with description %s", currentServerDescription));
                }
            }
        }

        private void waitForNext() throws InterruptedException {
            long millisToSleep;
            long minimumNanosToWait;
            long timeWaiting;
            long timeRemaining = this.waitForSignalOrTimeout();
            if (timeRemaining > 0L && (timeWaiting = DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS) - timeRemaining) < (minimumNanosToWait = DefaultServerMonitor.this.serverSettings.getMinHeartbeatFrequency(TimeUnit.NANOSECONDS)) && (millisToSleep = TimeUnit.MILLISECONDS.convert(minimumNanosToWait - timeWaiting, TimeUnit.NANOSECONDS)) > 0L) {
                Thread.sleep(millisToSleep);
            }
        }

        private long waitForSignalOrTimeout() throws InterruptedException {
            return Locks.checkedWithLock(DefaultServerMonitor.this.lock, () -> DefaultServerMonitor.this.condition.awaitNanos(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS)));
        }

        public void cancelCurrentCheck() {
            InternalConnection localConnection = Locks.withLock(DefaultServerMonitor.this.lock, () -> {
                if (this.connection != null && !this.currentCheckCancelled) {
                    InternalConnection result = this.connection;
                    this.currentCheckCancelled = true;
                    return result;
                }
                return null;
            });
            if (localConnection != null) {
                localConnection.close();
            }
        }
    }

    private class RoundTripTimeMonitor
    extends Thread
    implements AutoCloseable {
        private volatile InternalConnection connection;

        RoundTripTimeMonitor() {
            super("cluster-rtt-" + DefaultServerMonitor.this.serverId.getClusterId() + "-" + DefaultServerMonitor.this.serverId.getAddress());
            this.connection = null;
            this.setDaemon(true);
        }

        @Override
        public void close() {
            this.interrupt();
            InternalConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }

        @Override
        public void run() {
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    block12: {
                        try {
                            if (this.connection == null) {
                                this.initialize();
                            } else {
                                this.pingServer(this.connection);
                            }
                        }
                        catch (Exception t) {
                            if (this.connection == null) break block12;
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    DefaultServerMonitor.this.waitForNext();
                }
            }
            catch (InterruptedException t) {
            }
            catch (Throwable t) {
                LOGGER.error(String.format("%s for %s stopped working. You may want to recreate the MongoClient", this, DefaultServerMonitor.this.serverId), t);
                throw t;
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private void initialize() {
            this.connection = null;
            this.connection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
            this.connection.open(DefaultServerMonitor.this.operationContextFactory.create());
            DefaultServerMonitor.this.roundTripTimeSampler.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
        }

        private void pingServer(InternalConnection connection) {
            long start = System.nanoTime();
            OperationContext operationContext = DefaultServerMonitor.this.operationContextFactory.create();
            CommandHelper.executeCommand("admin", new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(connection.getInitialServerDescription()), (BsonValue)new BsonInt32(1)), DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi, connection, operationContext);
            long elapsedTimeNanos = System.nanoTime() - start;
            DefaultServerMonitor.this.roundTripTimeSampler.addSample(elapsedTimeNanos);
        }
    }
}

