/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.CommandResult;
import com.mongodb.ConnectionStatus;
import com.mongodb.Mongo;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOptions;
import com.mongodb.MongosStatus;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicConnectionStatus
extends ConnectionStatus {
    private static final Logger logger = Logger.getLogger("com.mongodb.DynamicConnectionStatus");
    private volatile ConnectionStatus connectionStatus;
    private ExecutorService executorService;

    DynamicConnectionStatus(Mongo mongo, List<ServerAddress> mongosAddresses) {
        super(mongosAddresses, mongo);
    }

    @Override
    void start() {
        super.start();
        this.executorService = Executors.newFixedThreadPool(this._mongosAddresses.size());
        this.initExecutorService();
    }

    @Override
    void close() {
        if (this.connectionStatus != null) {
            this.connectionStatus.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        super.close();
    }

    ReplicaSetStatus asReplicaSetStatus() {
        ConnectionStatus connectionStatus = this.getConnectionStatus();
        if (connectionStatus instanceof ReplicaSetStatus) {
            return (ReplicaSetStatus)connectionStatus;
        }
        return null;
    }

    MongosStatus asMongosStatus() {
        ConnectionStatus connectionStatus = this.getConnectionStatus();
        if (connectionStatus instanceof MongosStatus) {
            return (MongosStatus)connectionStatus;
        }
        return null;
    }

    @Override
    List<ServerAddress> getServerAddressList() {
        if (this.connectionStatus != null) {
            return this.connectionStatus.getServerAddressList();
        }
        return new ArrayList<ServerAddress>(this._mongosAddresses);
    }

    @Override
    boolean hasServerUp() {
        ConnectionStatus connectionStatus = this.getConnectionStatus();
        if (connectionStatus != null) {
            return connectionStatus.hasServerUp();
        }
        return false;
    }

    @Override
    ConnectionStatus.Node ensureMaster() {
        ConnectionStatus connectionStatus = this.getConnectionStatus();
        if (connectionStatus != null) {
            return connectionStatus.ensureMaster();
        }
        return null;
    }

    void initExecutorService() {
        try {
            for (final ServerAddress cur : this._mongosAddresses) {
                this.executorService.submit(new Runnable(){

                    public void run() {
                        DynamicNode node = new DynamicNode(cur, DynamicConnectionStatus.this._mongo, DynamicConnectionStatus.this._mongoOptions);
                        try {
                            while (!Thread.interrupted()) {
                                try {
                                    node.update();
                                    if (node._ok) {
                                        DynamicConnectionStatus.this.notifyOfOkNode(node);
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.WARNING, "couldn't reach " + node._addr, e);
                                }
                                int sleepTime = ConnectionStatus.updaterIntervalNoMasterMS;
                                Thread.sleep(sleepTime);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOfOkNode(DynamicNode node) {
        DynamicConnectionStatus dynamicConnectionStatus = this;
        synchronized (dynamicConnectionStatus) {
            if (this.connectionStatus != null) {
                return;
            }
            this.connectionStatus = node.isMongos ? new MongosStatus(this._mongo, this._mongosAddresses) : new ReplicaSetStatus(this._mongo, this._mongosAddresses);
            this.notifyAll();
        }
        this.connectionStatus.start();
        this.executorService.shutdownNow();
    }

    private synchronized ConnectionStatus getConnectionStatus() {
        if (this.connectionStatus == null) {
            try {
                this.wait(this._mongoOptions.connectTimeout);
            }
            catch (InterruptedException e) {
                throw new MongoInterruptedException("Interrupted while waiting for next update to dynamic status", e);
            }
        }
        return this.connectionStatus;
    }

    static class DynamicNode
    extends ConnectionStatus.UpdatableNode {
        private boolean isMongos;

        DynamicNode(ServerAddress addr, Mongo mongo, MongoOptions mongoOptions) {
            super(addr, mongo, mongoOptions);
        }

        protected Logger getLogger() {
            return logger;
        }

        public CommandResult update() {
            String msg;
            CommandResult res = super.update();
            if (res != null && (msg = res.getString("msg")) != null && msg.equals("isdbgrid")) {
                this.isMongos = true;
            }
            return res;
        }
    }
}

