/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZSTDCompressionParameters;
import org.lwjgl.util.zstd.ZSTDFrameParameters;

@NativeType(value="struct ZSTD_parameters")
public class ZSTDParameters
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPARAMS;
    public static final int FPARAMS;

    public ZSTDParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDParameters.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ZSTD_compressionParameters")
    public ZSTDCompressionParameters cParams() {
        return ZSTDParameters.ncParams(this.address());
    }

    @NativeType(value="ZSTD_frameParameters")
    public ZSTDFrameParameters fParams() {
        return ZSTDParameters.nfParams(this.address());
    }

    public ZSTDParameters cParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters value) {
        ZSTDParameters.ncParams(this.address(), value);
        return this;
    }

    public ZSTDParameters cParams(Consumer<ZSTDCompressionParameters> consumer) {
        consumer.accept(this.cParams());
        return this;
    }

    public ZSTDParameters fParams(@NativeType(value="ZSTD_frameParameters") ZSTDFrameParameters value) {
        ZSTDParameters.nfParams(this.address(), value);
        return this;
    }

    public ZSTDParameters fParams(Consumer<ZSTDFrameParameters> consumer) {
        consumer.accept(this.fParams());
        return this;
    }

    public ZSTDParameters set(ZSTDCompressionParameters cParams, ZSTDFrameParameters fParams) {
        this.cParams(cParams);
        this.fParams(fParams);
        return this;
    }

    public ZSTDParameters set(ZSTDParameters src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDParameters malloc() {
        return (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDParameters calloc() {
        return (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDParameters create(long address) {
        return (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)address);
    }

    @Nullable
    public static ZSTDParameters createSafe(long address) {
        return address == 0L ? null : (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDParameters.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDParameters.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDParameters.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDParameters.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDParameters.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDParameters.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDParameters.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ZSTDParameters mallocStack() {
        return ZSTDParameters.mallocStack(MemoryStack.stackGet());
    }

    public static ZSTDParameters callocStack() {
        return ZSTDParameters.callocStack(MemoryStack.stackGet());
    }

    public static ZSTDParameters mallocStack(MemoryStack stack) {
        return (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDParameters callocStack(MemoryStack stack) {
        return (ZSTDParameters)ZSTDParameters.wrap(ZSTDParameters.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZSTDParameters.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZSTDParameters.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDParameters.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDParameters.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ZSTDCompressionParameters ncParams(long struct) {
        return ZSTDCompressionParameters.create(struct + (long)CPARAMS);
    }

    public static ZSTDFrameParameters nfParams(long struct) {
        return ZSTDFrameParameters.create(struct + (long)FPARAMS);
    }

    public static void ncParams(long struct, ZSTDCompressionParameters value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CPARAMS), (long)ZSTDCompressionParameters.SIZEOF);
    }

    public static void nfParams(long struct, ZSTDFrameParameters value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FPARAMS), (long)ZSTDFrameParameters.SIZEOF);
    }

    static {
        Struct.Layout layout = ZSTDParameters.__struct((Struct.Member[])new Struct.Member[]{ZSTDParameters.__member((int)ZSTDCompressionParameters.SIZEOF, (int)ZSTDCompressionParameters.ALIGNOF), ZSTDParameters.__member((int)ZSTDFrameParameters.SIZEOF, (int)ZSTDFrameParameters.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPARAMS = layout.offsetof(0);
        FPARAMS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<ZSTDParameters, Buffer>
    implements NativeResource {
        private static final ZSTDParameters ELEMENT_FACTORY = ZSTDParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ZSTD_compressionParameters")
        public ZSTDCompressionParameters cParams() {
            return ZSTDParameters.ncParams(this.address());
        }

        @NativeType(value="ZSTD_frameParameters")
        public ZSTDFrameParameters fParams() {
            return ZSTDParameters.nfParams(this.address());
        }

        public Buffer cParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters value) {
            ZSTDParameters.ncParams(this.address(), value);
            return this;
        }

        public Buffer cParams(Consumer<ZSTDCompressionParameters> consumer) {
            consumer.accept(this.cParams());
            return this;
        }

        public Buffer fParams(@NativeType(value="ZSTD_frameParameters") ZSTDFrameParameters value) {
            ZSTDParameters.nfParams(this.address(), value);
            return this;
        }

        public Buffer fParams(Consumer<ZSTDFrameParameters> consumer) {
            consumer.accept(this.fParams());
            return this;
        }
    }
}

