/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_outBuffer")
public class ZSTDOutBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DST;
    public static final int SIZE;
    public static final int POS;

    public ZSTDOutBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDOutBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer dst() {
        return ZSTDOutBuffer.ndst(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return ZSTDOutBuffer.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long pos() {
        return ZSTDOutBuffer.npos(this.address());
    }

    public ZSTDOutBuffer dst(@NativeType(value="void *") ByteBuffer value) {
        ZSTDOutBuffer.ndst(this.address(), value);
        return this;
    }

    public ZSTDOutBuffer pos(@NativeType(value="size_t") long value) {
        ZSTDOutBuffer.npos(this.address(), value);
        return this;
    }

    public ZSTDOutBuffer set(ByteBuffer dst, long pos) {
        this.dst(dst);
        this.pos(pos);
        return this;
    }

    public ZSTDOutBuffer set(ZSTDOutBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ZSTDOutBuffer malloc() {
        return (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDOutBuffer calloc() {
        return (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDOutBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDOutBuffer create(long address) {
        return (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)address);
    }

    @Nullable
    public static ZSTDOutBuffer createSafe(long address) {
        return address == 0L ? null : (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDOutBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDOutBuffer.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ZSTDOutBuffer mallocStack() {
        return ZSTDOutBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static ZSTDOutBuffer callocStack() {
        return ZSTDOutBuffer.callocStack(MemoryStack.stackGet());
    }

    public static ZSTDOutBuffer mallocStack(MemoryStack stack) {
        return (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDOutBuffer callocStack(MemoryStack stack) {
        return (ZSTDOutBuffer)ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZSTDOutBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZSTDOutBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDOutBuffer.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndst(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DST)), (int)((int)ZSTDOutBuffer.nsize(struct)));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long npos(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)POS));
    }

    public static void ndst(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DST), (long)MemoryUtil.memAddress((ByteBuffer)value));
        ZSTDOutBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void npos(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POS), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DST)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            ZSTDOutBuffer.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = ZSTDOutBuffer.__struct((Struct.Member[])new Struct.Member[]{ZSTDOutBuffer.__member((int)POINTER_SIZE), ZSTDOutBuffer.__member((int)POINTER_SIZE), ZSTDOutBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DST = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        POS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDOutBuffer, Buffer>
    implements NativeResource {
        private static final ZSTDOutBuffer ELEMENT_FACTORY = ZSTDOutBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDOutBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer dst() {
            return ZSTDOutBuffer.ndst(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return ZSTDOutBuffer.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long pos() {
            return ZSTDOutBuffer.npos(this.address());
        }

        public Buffer dst(@NativeType(value="void *") ByteBuffer value) {
            ZSTDOutBuffer.ndst(this.address(), value);
            return this;
        }

        public Buffer pos(@NativeType(value="size_t") long value) {
            ZSTDOutBuffer.npos(this.address(), value);
            return this;
        }
    }
}

