/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameHeader")
public class ZSTDFrameHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMECONTENTSIZE;
    public static final int WINDOWSIZE;
    public static final int BLOCKSIZEMAX;
    public static final int FRAMETYPE;
    public static final int HEADERSIZE;
    public static final int DICTID;
    public static final int CHECKSUMFLAG;

    public ZSTDFrameHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDFrameHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long frameContentSize() {
        return ZSTDFrameHeader.nframeContentSize(this.address());
    }

    @NativeType(value="unsigned long long")
    public long windowSize() {
        return ZSTDFrameHeader.nwindowSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockSizeMax() {
        return ZSTDFrameHeader.nblockSizeMax(this.address());
    }

    @NativeType(value="ZSTD_frameType_e")
    public int frameType() {
        return ZSTDFrameHeader.nframeType(this.address());
    }

    @NativeType(value="unsigned int")
    public int headerSize() {
        return ZSTDFrameHeader.nheaderSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int dictID() {
        return ZSTDFrameHeader.ndictID(this.address());
    }

    @NativeType(value="unsigned int")
    public int checksumFlag() {
        return ZSTDFrameHeader.nchecksumFlag(this.address());
    }

    public static ZSTDFrameHeader malloc() {
        return (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDFrameHeader calloc() {
        return (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDFrameHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDFrameHeader create(long address) {
        return (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)address);
    }

    @Nullable
    public static ZSTDFrameHeader createSafe(long address) {
        return address == 0L ? null : (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDFrameHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ZSTDFrameHeader mallocStack() {
        return ZSTDFrameHeader.mallocStack(MemoryStack.stackGet());
    }

    public static ZSTDFrameHeader callocStack() {
        return ZSTDFrameHeader.callocStack(MemoryStack.stackGet());
    }

    public static ZSTDFrameHeader mallocStack(MemoryStack stack) {
        return (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDFrameHeader callocStack(MemoryStack stack) {
        return (ZSTDFrameHeader)ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameHeader.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZSTDFrameHeader.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDFrameHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nframeContentSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)FRAMECONTENTSIZE);
    }

    public static long nwindowSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)WINDOWSIZE);
    }

    public static int nblockSizeMax(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKSIZEMAX);
    }

    public static int nframeType(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMETYPE);
    }

    public static int nheaderSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEADERSIZE);
    }

    public static int ndictID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DICTID);
    }

    public static int nchecksumFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHECKSUMFLAG);
    }

    static {
        Struct.Layout layout = ZSTDFrameHeader.__struct((Struct.Member[])new Struct.Member[]{ZSTDFrameHeader.__member((int)8), ZSTDFrameHeader.__member((int)8), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4), ZSTDFrameHeader.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMECONTENTSIZE = layout.offsetof(0);
        WINDOWSIZE = layout.offsetof(1);
        BLOCKSIZEMAX = layout.offsetof(2);
        FRAMETYPE = layout.offsetof(3);
        HEADERSIZE = layout.offsetof(4);
        DICTID = layout.offsetof(5);
        CHECKSUMFLAG = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameHeader, Buffer>
    implements NativeResource {
        private static final ZSTDFrameHeader ELEMENT_FACTORY = ZSTDFrameHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDFrameHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long frameContentSize() {
            return ZSTDFrameHeader.nframeContentSize(this.address());
        }

        @NativeType(value="unsigned long long")
        public long windowSize() {
            return ZSTDFrameHeader.nwindowSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockSizeMax() {
            return ZSTDFrameHeader.nblockSizeMax(this.address());
        }

        @NativeType(value="ZSTD_frameType_e")
        public int frameType() {
            return ZSTDFrameHeader.nframeType(this.address());
        }

        @NativeType(value="unsigned int")
        public int headerSize() {
            return ZSTDFrameHeader.nheaderSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int dictID() {
            return ZSTDFrameHeader.ndictID(this.address());
        }

        @NativeType(value="unsigned int")
        public int checksumFlag() {
            return ZSTDFrameHeader.nchecksumFlag(this.address());
        }
    }
}

