/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_bounds")
public class ZSTDBounds
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ERROR;
    public static final int LOWERBOUND;
    public static final int UPPERBOUND;

    public ZSTDBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDBounds.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long error() {
        return ZSTDBounds.nerror(this.address());
    }

    public int lowerBound() {
        return ZSTDBounds.nlowerBound(this.address());
    }

    public int upperBound() {
        return ZSTDBounds.nupperBound(this.address());
    }

    public static ZSTDBounds malloc() {
        return (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ZSTDBounds calloc() {
        return (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ZSTDBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ZSTDBounds create(long address) {
        return (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)address);
    }

    @Nullable
    public static ZSTDBounds createSafe(long address) {
        return address == 0L ? null : (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ZSTDBounds.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ZSTDBounds.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ZSTDBounds.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDBounds.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ZSTDBounds.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ZSTDBounds.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ZSTDBounds.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ZSTDBounds mallocStack() {
        return ZSTDBounds.mallocStack(MemoryStack.stackGet());
    }

    public static ZSTDBounds callocStack() {
        return ZSTDBounds.callocStack(MemoryStack.stackGet());
    }

    public static ZSTDBounds mallocStack(MemoryStack stack) {
        return (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDBounds callocStack(MemoryStack stack) {
        return (ZSTDBounds)ZSTDBounds.wrap(ZSTDBounds.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZSTDBounds.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZSTDBounds.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDBounds.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ZSTDBounds.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nerror(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ERROR));
    }

    public static int nlowerBound(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOWERBOUND);
    }

    public static int nupperBound(long struct) {
        return UNSAFE.getInt(null, struct + (long)UPPERBOUND);
    }

    static {
        Struct.Layout layout = ZSTDBounds.__struct((Struct.Member[])new Struct.Member[]{ZSTDBounds.__member((int)POINTER_SIZE), ZSTDBounds.__member((int)4), ZSTDBounds.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ERROR = layout.offsetof(0);
        LOWERBOUND = layout.offsetof(1);
        UPPERBOUND = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDBounds, Buffer>
    implements NativeResource {
        private static final ZSTDBounds ELEMENT_FACTORY = ZSTDBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long error() {
            return ZSTDBounds.nerror(this.address());
        }

        public int lowerBound() {
            return ZSTDBounds.nlowerBound(this.address());
        }

        public int upperBound() {
            return ZSTDBounds.nupperBound(this.address());
        }
    }
}

