/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_state_t")
public class XXH64State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN;
    public static final int V1;
    public static final int V2;
    public static final int V3;
    public static final int V4;
    public static final int MEM64;
    public static final int MEMSIZE;
    public static final int RESERVED;

    public XXH64State(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH64State.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH32_hash_t")
    public long total_len() {
        return XXH64State.ntotal_len(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public long v1() {
        return XXH64State.nv1(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public long v2() {
        return XXH64State.nv2(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public long v3() {
        return XXH64State.nv3(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public long v4() {
        return XXH64State.nv4(this.address());
    }

    @NativeType(value="XXH32_hash_t[4]")
    public LongBuffer mem64() {
        return XXH64State.nmem64(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public long mem64(int index) {
        return XXH64State.nmem64(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int memsize() {
        return XXH64State.nmemsize(this.address());
    }

    @NativeType(value="XXH32_hash_t[2]")
    public IntBuffer reserved() {
        return XXH64State.nreserved(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved(int index) {
        return XXH64State.nreserved(this.address(), index);
    }

    public static XXH64State malloc() {
        return (XXH64State)XXH64State.wrap(XXH64State.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH64State calloc() {
        return (XXH64State)XXH64State.wrap(XXH64State.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH64State create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH64State)XXH64State.wrap(XXH64State.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH64State create(long address) {
        return (XXH64State)XXH64State.wrap(XXH64State.class, (long)address);
    }

    @Nullable
    public static XXH64State createSafe(long address) {
        return address == 0L ? null : (XXH64State)XXH64State.wrap(XXH64State.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH64State.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH64State.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH64State.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64State.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH64State.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH64State.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH64State.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XXH64State mallocStack() {
        return XXH64State.mallocStack(MemoryStack.stackGet());
    }

    public static XXH64State callocStack() {
        return XXH64State.callocStack(MemoryStack.stackGet());
    }

    public static XXH64State mallocStack(MemoryStack stack) {
        return (XXH64State)XXH64State.wrap(XXH64State.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64State callocStack(MemoryStack stack) {
        return (XXH64State)XXH64State.wrap(XXH64State.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH64State.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH64State.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH64State.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH64State.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ntotal_len(long struct) {
        return UNSAFE.getLong(null, struct + (long)TOTAL_LEN);
    }

    public static long nv1(long struct) {
        return UNSAFE.getLong(null, struct + (long)V1);
    }

    public static long nv2(long struct) {
        return UNSAFE.getLong(null, struct + (long)V2);
    }

    public static long nv3(long struct) {
        return UNSAFE.getLong(null, struct + (long)V3);
    }

    public static long nv4(long struct) {
        return UNSAFE.getLong(null, struct + (long)V4);
    }

    public static LongBuffer nmem64(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)MEM64), (int)4);
    }

    public static long nmem64(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)MEM64 + Checks.check((int)index, (int)4) * 8L);
    }

    public static int nmemsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMSIZE);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)2);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)2) * 4L);
    }

    static {
        Struct.Layout layout = XXH64State.__struct((Struct.Member[])new Struct.Member[]{XXH64State.__member((int)8), XXH64State.__member((int)8), XXH64State.__member((int)8), XXH64State.__member((int)8), XXH64State.__member((int)8), XXH64State.__array((int)8, (int)4), XXH64State.__member((int)4), XXH64State.__array((int)4, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN = layout.offsetof(0);
        V1 = layout.offsetof(1);
        V2 = layout.offsetof(2);
        V3 = layout.offsetof(3);
        V4 = layout.offsetof(4);
        MEM64 = layout.offsetof(5);
        MEMSIZE = layout.offsetof(6);
        RESERVED = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XXH64State, Buffer>
    implements NativeResource {
        private static final XXH64State ELEMENT_FACTORY = XXH64State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH64State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH32_hash_t")
        public long total_len() {
            return XXH64State.ntotal_len(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public long v1() {
            return XXH64State.nv1(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public long v2() {
            return XXH64State.nv2(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public long v3() {
            return XXH64State.nv3(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public long v4() {
            return XXH64State.nv4(this.address());
        }

        @NativeType(value="XXH32_hash_t[4]")
        public LongBuffer mem64() {
            return XXH64State.nmem64(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public long mem64(int index) {
            return XXH64State.nmem64(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int memsize() {
            return XXH64State.nmemsize(this.address());
        }

        @NativeType(value="XXH32_hash_t[2]")
        public IntBuffer reserved() {
            return XXH64State.nreserved(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved(int index) {
            return XXH64State.nreserved(this.address(), index);
        }
    }
}

