/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReference2KHR;

public class VkSubpassDescription2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int VIEWMASK;
    public static final int INPUTATTACHMENTCOUNT;
    public static final int PINPUTATTACHMENTS;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PRESOLVEATTACHMENTS;
    public static final int PDEPTHSTENCILATTACHMENT;
    public static final int PRESERVEATTACHMENTCOUNT;
    public static final int PPRESERVEATTACHMENTS;

    public VkSubpassDescription2KHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassDescription2KHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassDescription2KHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassDescription2KHR.npNext(this.address());
    }

    @NativeType(value="VkSubpassDescriptionFlags")
    public int flags() {
        return VkSubpassDescription2KHR.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkSubpassDescription2KHR.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkSubpassDescription2KHR.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentCount() {
        return VkSubpassDescription2KHR.ninputAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR.Buffer pInputAttachments() {
        return VkSubpassDescription2KHR.npInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkSubpassDescription2KHR.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR.Buffer pColorAttachments() {
        return VkSubpassDescription2KHR.npColorAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR.Buffer pResolveAttachments() {
        return VkSubpassDescription2KHR.npResolveAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR pDepthStencilAttachment() {
        return VkSubpassDescription2KHR.npDepthStencilAttachment(this.address());
    }

    @NativeType(value="uint32_t")
    public int preserveAttachmentCount() {
        return VkSubpassDescription2KHR.npreserveAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pPreserveAttachments() {
        return VkSubpassDescription2KHR.npPreserveAttachments(this.address());
    }

    public VkSubpassDescription2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassDescription2KHR.nsType(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassDescription2KHR.npNext(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
        VkSubpassDescription2KHR.nflags(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkSubpassDescription2KHR.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR viewMask(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription2KHR.nviewMask(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
        VkSubpassDescription2KHR.npInputAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription2KHR.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
        VkSubpassDescription2KHR.npColorAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
        VkSubpassDescription2KHR.npResolveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR value) {
        VkSubpassDescription2KHR.npDepthStencilAttachment(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkSubpassDescription2KHR.npPreserveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR set(int sType, long pNext, int flags, int pipelineBindPoint, int viewMask, @Nullable VkAttachmentReference2KHR.Buffer pInputAttachments, int colorAttachmentCount, @Nullable VkAttachmentReference2KHR.Buffer pColorAttachments, @Nullable VkAttachmentReference2KHR.Buffer pResolveAttachments, @Nullable VkAttachmentReference2KHR pDepthStencilAttachment, @Nullable IntBuffer pPreserveAttachments) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.viewMask(viewMask);
        this.pInputAttachments(pInputAttachments);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachments(pColorAttachments);
        this.pResolveAttachments(pResolveAttachments);
        this.pDepthStencilAttachment(pDepthStencilAttachment);
        this.pPreserveAttachments(pPreserveAttachments);
        return this;
    }

    public VkSubpassDescription2KHR set(VkSubpassDescription2KHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassDescription2KHR malloc() {
        return (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassDescription2KHR calloc() {
        return (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassDescription2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassDescription2KHR create(long address) {
        return (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)address);
    }

    @Nullable
    public static VkSubpassDescription2KHR createSafe(long address) {
        return address == 0L ? null : (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassDescription2KHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassDescription2KHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubpassDescription2KHR mallocStack() {
        return VkSubpassDescription2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription2KHR callocStack() {
        return VkSubpassDescription2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription2KHR mallocStack(MemoryStack stack) {
        return (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassDescription2KHR callocStack(MemoryStack stack) {
        return (VkSubpassDescription2KHR)VkSubpassDescription2KHR.wrap(VkSubpassDescription2KHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassDescription2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassDescription2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassDescription2KHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINEBINDPOINT);
    }

    public static int nviewMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWMASK);
    }

    public static int ninputAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUTATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference2KHR.Buffer npInputAttachments(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTS)), VkSubpassDescription2KHR.ninputAttachmentCount(struct));
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference2KHR.Buffer npColorAttachments(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTS)), VkSubpassDescription2KHR.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference2KHR.Buffer npResolveAttachments(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRESOLVEATTACHMENTS)), VkSubpassDescription2KHR.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference2KHR npDepthStencilAttachment(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEPTHSTENCILATTACHMENT)));
    }

    public static int npreserveAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRESERVEATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npPreserveAttachments(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPRESERVEATTACHMENTS)), (int)VkSubpassDescription2KHR.npreserveAttachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void nviewMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWMASK, value);
    }

    public static void ninputAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INPUTATTACHMENTCOUNT, value);
    }

    public static void npInputAttachments(long struct, @Nullable VkAttachmentReference2KHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PINPUTATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkSubpassDescription2KHR.ninputAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, @Nullable VkAttachmentReference2KHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOLORATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npResolveAttachments(long struct, @Nullable VkAttachmentReference2KHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRESOLVEATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npDepthStencilAttachment(long struct, @Nullable VkAttachmentReference2KHR value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEPTHSTENCILATTACHMENT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npreserveAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRESERVEATTACHMENTCOUNT, value);
    }

    public static void npPreserveAttachments(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPRESERVEATTACHMENTS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkSubpassDescription2KHR.npreserveAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubpassDescription2KHR.ninputAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTS)));
        }
        if (VkSubpassDescription2KHR.ncolorAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTS)));
        }
        if (VkSubpassDescription2KHR.npreserveAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPRESERVEATTACHMENTS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubpassDescription2KHR.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSubpassDescription2KHR.__struct((Struct.Member[])new Struct.Member[]{VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)POINTER_SIZE), VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)POINTER_SIZE), VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)POINTER_SIZE), VkSubpassDescription2KHR.__member((int)POINTER_SIZE), VkSubpassDescription2KHR.__member((int)POINTER_SIZE), VkSubpassDescription2KHR.__member((int)4), VkSubpassDescription2KHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PIPELINEBINDPOINT = layout.offsetof(3);
        VIEWMASK = layout.offsetof(4);
        INPUTATTACHMENTCOUNT = layout.offsetof(5);
        PINPUTATTACHMENTS = layout.offsetof(6);
        COLORATTACHMENTCOUNT = layout.offsetof(7);
        PCOLORATTACHMENTS = layout.offsetof(8);
        PRESOLVEATTACHMENTS = layout.offsetof(9);
        PDEPTHSTENCILATTACHMENT = layout.offsetof(10);
        PRESERVEATTACHMENTCOUNT = layout.offsetof(11);
        PPRESERVEATTACHMENTS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDescription2KHR, Buffer>
    implements NativeResource {
        private static final VkSubpassDescription2KHR ELEMENT_FACTORY = VkSubpassDescription2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassDescription2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassDescription2KHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassDescription2KHR.npNext(this.address());
        }

        @NativeType(value="VkSubpassDescriptionFlags")
        public int flags() {
            return VkSubpassDescription2KHR.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkSubpassDescription2KHR.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkSubpassDescription2KHR.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentCount() {
            return VkSubpassDescription2KHR.ninputAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR.Buffer pInputAttachments() {
            return VkSubpassDescription2KHR.npInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkSubpassDescription2KHR.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR.Buffer pColorAttachments() {
            return VkSubpassDescription2KHR.npColorAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR.Buffer pResolveAttachments() {
            return VkSubpassDescription2KHR.npResolveAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR pDepthStencilAttachment() {
            return VkSubpassDescription2KHR.npDepthStencilAttachment(this.address());
        }

        @NativeType(value="uint32_t")
        public int preserveAttachmentCount() {
            return VkSubpassDescription2KHR.npreserveAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pPreserveAttachments() {
            return VkSubpassDescription2KHR.npPreserveAttachments(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassDescription2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassDescription2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
            VkSubpassDescription2KHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkSubpassDescription2KHR.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription2KHR.nviewMask(this.address(), value);
            return this;
        }

        public Buffer pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
            VkSubpassDescription2KHR.npInputAttachments(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription2KHR.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
            VkSubpassDescription2KHR.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
            VkSubpassDescription2KHR.npResolveAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR value) {
            VkSubpassDescription2KHR.npDepthStencilAttachment(this.address(), value);
            return this;
        }

        public Buffer pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkSubpassDescription2KHR.npPreserveAttachments(this.address(), value);
            return this;
        }
    }
}

