/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderPassAttachmentBeginInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;

    public VkRenderPassAttachmentBeginInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassAttachmentBeginInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassAttachmentBeginInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassAttachmentBeginInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassAttachmentBeginInfoKHR.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageView const *")
    public LongBuffer pAttachments() {
        return VkRenderPassAttachmentBeginInfoKHR.npAttachments(this.address());
    }

    public VkRenderPassAttachmentBeginInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassAttachmentBeginInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderPassAttachmentBeginInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfoKHR pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
        VkRenderPassAttachmentBeginInfoKHR.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfoKHR set(int sType, long pNext, @Nullable LongBuffer pAttachments) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttachments(pAttachments);
        return this;
    }

    public VkRenderPassAttachmentBeginInfoKHR set(VkRenderPassAttachmentBeginInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassAttachmentBeginInfoKHR malloc() {
        return (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRenderPassAttachmentBeginInfoKHR calloc() {
        return (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRenderPassAttachmentBeginInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRenderPassAttachmentBeginInfoKHR create(long address) {
        return (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkRenderPassAttachmentBeginInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRenderPassAttachmentBeginInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassAttachmentBeginInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkRenderPassAttachmentBeginInfoKHR mallocStack() {
        return VkRenderPassAttachmentBeginInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassAttachmentBeginInfoKHR callocStack() {
        return VkRenderPassAttachmentBeginInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassAttachmentBeginInfoKHR mallocStack(MemoryStack stack) {
        return (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassAttachmentBeginInfoKHR callocStack(MemoryStack stack) {
        return (VkRenderPassAttachmentBeginInfoKHR)VkRenderPassAttachmentBeginInfoKHR.wrap(VkRenderPassAttachmentBeginInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassAttachmentBeginInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassAttachmentBeginInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassAttachmentBeginInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static LongBuffer npAttachments(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), (int)VkRenderPassAttachmentBeginInfoKHR.nattachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkRenderPassAttachmentBeginInfoKHR.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassAttachmentBeginInfoKHR.nattachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassAttachmentBeginInfoKHR.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkRenderPassAttachmentBeginInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassAttachmentBeginInfoKHR.__member((int)4), VkRenderPassAttachmentBeginInfoKHR.__member((int)POINTER_SIZE), VkRenderPassAttachmentBeginInfoKHR.__member((int)4), VkRenderPassAttachmentBeginInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENTCOUNT = layout.offsetof(2);
        PATTACHMENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassAttachmentBeginInfoKHR, Buffer>
    implements NativeResource {
        private static final VkRenderPassAttachmentBeginInfoKHR ELEMENT_FACTORY = VkRenderPassAttachmentBeginInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkRenderPassAttachmentBeginInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassAttachmentBeginInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassAttachmentBeginInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassAttachmentBeginInfoKHR.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageView const *")
        public LongBuffer pAttachments() {
            return VkRenderPassAttachmentBeginInfoKHR.npAttachments(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassAttachmentBeginInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassAttachmentBeginInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
            VkRenderPassAttachmentBeginInfoKHR.npAttachments(this.address(), value);
            return this;
        }
    }
}

