/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateFlagsInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEVICEMASK;

    public VkMemoryAllocateFlagsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryAllocateFlagsInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryAllocateFlagsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryAllocateFlagsInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryAllocateFlags")
    public int flags() {
        return VkMemoryAllocateFlagsInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
    }

    public VkMemoryAllocateFlagsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(VkMemoryAllocateFlagsInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfo malloc() {
        return (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo calloc() {
        return (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryAllocateFlagsInfo create(long address) {
        return (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)address);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfo createSafe(long address) {
        return address == 0L ? null : (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryAllocateFlagsInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateFlagsInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMemoryAllocateFlagsInfo mallocStack() {
        return VkMemoryAllocateFlagsInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfo callocStack() {
        return VkMemoryAllocateFlagsInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateFlagsInfo mallocStack(MemoryStack stack) {
        return (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo callocStack(MemoryStack stack) {
        return (VkMemoryAllocateFlagsInfo)VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryAllocateFlagsInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndeviceMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndeviceMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateFlagsInfo.__struct((Struct.Member[])new Struct.Member[]{VkMemoryAllocateFlagsInfo.__member((int)4), VkMemoryAllocateFlagsInfo.__member((int)POINTER_SIZE), VkMemoryAllocateFlagsInfo.__member((int)4), VkMemoryAllocateFlagsInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEVICEMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateFlagsInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryAllocateFlagsInfo ELEMENT_FACTORY = VkMemoryAllocateFlagsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryAllocateFlagsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryAllocateFlagsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryAllocateFlagsInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryAllocateFlags")
        public int flags() {
            return VkMemoryAllocateFlagsInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

