/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentReference2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENT;
    public static final int LAYOUT;
    public static final int ASPECTMASK;

    public VkAttachmentReference2KHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAttachmentReference2KHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAttachmentReference2KHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAttachmentReference2KHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachment() {
        return VkAttachmentReference2KHR.nattachment(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int layout() {
        return VkAttachmentReference2KHR.nlayout(this.address());
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkAttachmentReference2KHR.naspectMask(this.address());
    }

    public VkAttachmentReference2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkAttachmentReference2KHR.nsType(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR pNext(@NativeType(value="void const *") long value) {
        VkAttachmentReference2KHR.npNext(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference2KHR.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference2KHR.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkAttachmentReference2KHR.naspectMask(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR set(int sType, long pNext, int attachment, int layout, int aspectMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.attachment(attachment);
        this.layout(layout);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkAttachmentReference2KHR set(VkAttachmentReference2KHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAttachmentReference2KHR malloc() {
        return (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAttachmentReference2KHR calloc() {
        return (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAttachmentReference2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAttachmentReference2KHR create(long address) {
        return (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)address);
    }

    @Nullable
    public static VkAttachmentReference2KHR createSafe(long address) {
        return address == 0L ? null : (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAttachmentReference2KHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentReference2KHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAttachmentReference2KHR mallocStack() {
        return VkAttachmentReference2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference2KHR callocStack() {
        return VkAttachmentReference2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference2KHR mallocStack(MemoryStack stack) {
        return (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentReference2KHR callocStack(MemoryStack stack) {
        return (VkAttachmentReference2KHR)VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAttachmentReference2KHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nattachment(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENT);
    }

    public static int nlayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYOUT);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nattachment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENT, value);
    }

    public static void nlayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYOUT, value);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference2KHR.__struct((Struct.Member[])new Struct.Member[]{VkAttachmentReference2KHR.__member((int)4), VkAttachmentReference2KHR.__member((int)POINTER_SIZE), VkAttachmentReference2KHR.__member((int)4), VkAttachmentReference2KHR.__member((int)4), VkAttachmentReference2KHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENT = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        ASPECTMASK = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentReference2KHR, Buffer>
    implements NativeResource {
        private static final VkAttachmentReference2KHR ELEMENT_FACTORY = VkAttachmentReference2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAttachmentReference2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAttachmentReference2KHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAttachmentReference2KHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachment() {
            return VkAttachmentReference2KHR.nattachment(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int layout() {
            return VkAttachmentReference2KHR.nlayout(this.address());
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkAttachmentReference2KHR.naspectMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAttachmentReference2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAttachmentReference2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference2KHR.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference2KHR.nlayout(this.address(), value);
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkAttachmentReference2KHR.naspectMask(this.address(), value);
            return this;
        }
    }
}

