/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.rpmalloc.LibRPmalloc;
import org.lwjgl.system.rpmalloc.RPMallocConfig;
import org.lwjgl.system.rpmalloc.RPmallocGlobalStatistics;
import org.lwjgl.system.rpmalloc.RPmallocThreadStatistics;

public class RPmalloc {
    public static final int RPMALLOC_NO_PRESERVE = 1;

    protected RPmalloc() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="void *")
    static native long rpmalloc_address();

    @NativeType(value="void *")
    static native long rpcalloc_address();

    @NativeType(value="void *")
    static native long rprealloc_address();

    @NativeType(value="void *")
    static native long rpfree_address();

    @NativeType(value="void *")
    static native long rpaligned_alloc_address();

    public static native int nrpmalloc_initialize();

    @NativeType(value="int")
    public static boolean rpmalloc_initialize() {
        return RPmalloc.nrpmalloc_initialize() != 0;
    }

    public static native int nrpmalloc_initialize_config(long var0);

    @NativeType(value="int")
    public static boolean rpmalloc_initialize_config(@Nullable @NativeType(value="rpmalloc_config_t const *") RPMallocConfig config) {
        return RPmalloc.nrpmalloc_initialize_config(MemoryUtil.memAddressSafe((Pointer)config)) != 0;
    }

    public static native long nrpmalloc_config();

    @NativeType(value="rpmalloc_config_t const *")
    public static RPMallocConfig rpmalloc_config() {
        long __result = RPmalloc.nrpmalloc_config();
        return RPMallocConfig.create(__result);
    }

    public static native void rpmalloc_finalize();

    public static native void rpmalloc_thread_initialize();

    public static native void rpmalloc_thread_finalize();

    public static native void rpmalloc_thread_collect();

    public static native int nrpmalloc_is_thread_initialized();

    @NativeType(value="int")
    public static boolean rpmalloc_is_thread_initialized() {
        return RPmalloc.nrpmalloc_is_thread_initialized() != 0;
    }

    public static native void nrpmalloc_thread_statistics(long var0);

    public static void rpmalloc_thread_statistics(@NativeType(value="rpmalloc_thread_statistics_t *") RPmallocThreadStatistics stats) {
        RPmalloc.nrpmalloc_thread_statistics(stats.address());
    }

    public static native void nrpmalloc_global_statistics(long var0);

    public static void rpmalloc_global_statistics(@NativeType(value="rpmalloc_global_statistics_t *") RPmallocGlobalStatistics stats) {
        RPmalloc.nrpmalloc_global_statistics(stats.address());
    }

    public static native long nrpmalloc(long var0);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer rpmalloc(@NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpmalloc(size);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static native void nrpfree(long var0);

    public static void rpfree(@Nullable @NativeType(value="void *") ByteBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((ByteBuffer)ptr));
    }

    public static void rpfree(@Nullable @NativeType(value="void *") ShortBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((ShortBuffer)ptr));
    }

    public static void rpfree(@Nullable @NativeType(value="void *") IntBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((IntBuffer)ptr));
    }

    public static void rpfree(@Nullable @NativeType(value="void *") LongBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((LongBuffer)ptr));
    }

    public static void rpfree(@Nullable @NativeType(value="void *") FloatBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((FloatBuffer)ptr));
    }

    public static void rpfree(@Nullable @NativeType(value="void *") DoubleBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((DoubleBuffer)ptr));
    }

    public static void rpfree(@Nullable @NativeType(value="void *") PointerBuffer ptr) {
        RPmalloc.nrpfree(MemoryUtil.memAddressSafe((Pointer)ptr));
    }

    public static native long nrpcalloc(long var0, long var2);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer rpcalloc(@NativeType(value="size_t") long num, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpcalloc(num, size);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)num * (int)size));
    }

    public static native long nrprealloc(long var0, long var2);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer rprealloc(@Nullable @NativeType(value="void *") ByteBuffer ptr, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrprealloc(MemoryUtil.memAddressSafe((ByteBuffer)ptr), size);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static native long nrpaligned_realloc(long var0, long var2, long var4, long var6, int var8);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer rpaligned_realloc(@Nullable @NativeType(value="void *") ByteBuffer ptr, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size, @NativeType(value="unsigned int") int flags) {
        long __result = RPmalloc.nrpaligned_realloc(MemoryUtil.memAddressSafe((ByteBuffer)ptr), alignment, size, Checks.remainingSafe((Buffer)ptr), flags);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static native long nrpaligned_alloc(long var0, long var2);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer rpaligned_alloc(@NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpaligned_alloc(alignment, size);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static native long nrpmemalign(long var0, long var2);

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer rpmemalign(@NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        long __result = RPmalloc.nrpmemalign(alignment, size);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static native int nrpposix_memalign(long var0, long var2, long var4);

    public static int rpposix_memalign(@NativeType(value="void **") PointerBuffer memptr, @NativeType(value="size_t") long alignment, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)memptr, (int)1);
        }
        return RPmalloc.nrpposix_memalign(MemoryUtil.memAddress((CustomBuffer)memptr), alignment, size);
    }

    public static native long nrpmalloc_usable_size(long var0);

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") ByteBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((ByteBuffer)ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") ShortBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((ShortBuffer)ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") IntBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((IntBuffer)ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") LongBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((LongBuffer)ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") FloatBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((FloatBuffer)ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") DoubleBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((DoubleBuffer)ptr));
    }

    @NativeType(value="size_t")
    public static long rpmalloc_usable_size(@NativeType(value="void *") PointerBuffer ptr) {
        return RPmalloc.nrpmalloc_usable_size(MemoryUtil.memAddress((CustomBuffer)ptr));
    }

    static {
        LibRPmalloc.initialize();
    }
}

