/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Compositor_OverlaySettings")
public class CompositorOverlaySettings
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int CURVED;
    public static final int ANTIALIAS;
    public static final int SCALE;
    public static final int DISTANCE;
    public static final int ALPHA;
    public static final int UOFFSET;
    public static final int VOFFSET;
    public static final int USCALE;
    public static final int VSCALE;
    public static final int GRIDDIVS;
    public static final int GRIDWIDTH;
    public static final int GRIDSCALE;
    public static final int TRANSFORM;

    public CompositorOverlaySettings(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CompositorOverlaySettings.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int size() {
        return CompositorOverlaySettings.nsize(this.address());
    }

    @NativeType(value="bool")
    public boolean curved() {
        return CompositorOverlaySettings.ncurved(this.address());
    }

    @NativeType(value="bool")
    public boolean antialias() {
        return CompositorOverlaySettings.nantialias(this.address());
    }

    public float scale() {
        return CompositorOverlaySettings.nscale(this.address());
    }

    public float distance() {
        return CompositorOverlaySettings.ndistance(this.address());
    }

    public float alpha() {
        return CompositorOverlaySettings.nalpha(this.address());
    }

    public float uOffset() {
        return CompositorOverlaySettings.nuOffset(this.address());
    }

    public float vOffset() {
        return CompositorOverlaySettings.nvOffset(this.address());
    }

    public float uScale() {
        return CompositorOverlaySettings.nuScale(this.address());
    }

    public float vScale() {
        return CompositorOverlaySettings.nvScale(this.address());
    }

    public float gridDivs() {
        return CompositorOverlaySettings.ngridDivs(this.address());
    }

    public float gridWidth() {
        return CompositorOverlaySettings.ngridWidth(this.address());
    }

    public float gridScale() {
        return CompositorOverlaySettings.ngridScale(this.address());
    }

    @NativeType(value="HmdMatrix44_t")
    public HmdMatrix44 transform() {
        return CompositorOverlaySettings.ntransform(this.address());
    }

    public CompositorOverlaySettings size(@NativeType(value="uint32_t") int value) {
        CompositorOverlaySettings.nsize(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings curved(@NativeType(value="bool") boolean value) {
        CompositorOverlaySettings.ncurved(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings antialias(@NativeType(value="bool") boolean value) {
        CompositorOverlaySettings.nantialias(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings scale(float value) {
        CompositorOverlaySettings.nscale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings distance(float value) {
        CompositorOverlaySettings.ndistance(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings alpha(float value) {
        CompositorOverlaySettings.nalpha(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings uOffset(float value) {
        CompositorOverlaySettings.nuOffset(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings vOffset(float value) {
        CompositorOverlaySettings.nvOffset(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings uScale(float value) {
        CompositorOverlaySettings.nuScale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings vScale(float value) {
        CompositorOverlaySettings.nvScale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings gridDivs(float value) {
        CompositorOverlaySettings.ngridDivs(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings gridWidth(float value) {
        CompositorOverlaySettings.ngridWidth(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings gridScale(float value) {
        CompositorOverlaySettings.ngridScale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings transform(@NativeType(value="HmdMatrix44_t") HmdMatrix44 value) {
        CompositorOverlaySettings.ntransform(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings transform(Consumer<HmdMatrix44> consumer) {
        consumer.accept(this.transform());
        return this;
    }

    public CompositorOverlaySettings set(int size, boolean curved, boolean antialias, float scale, float distance, float alpha, float uOffset, float vOffset, float uScale, float vScale, float gridDivs, float gridWidth, float gridScale, HmdMatrix44 transform) {
        this.size(size);
        this.curved(curved);
        this.antialias(antialias);
        this.scale(scale);
        this.distance(distance);
        this.alpha(alpha);
        this.uOffset(uOffset);
        this.vOffset(vOffset);
        this.uScale(uScale);
        this.vScale(vScale);
        this.gridDivs(gridDivs);
        this.gridWidth(gridWidth);
        this.gridScale(gridScale);
        this.transform(transform);
        return this;
    }

    public CompositorOverlaySettings set(CompositorOverlaySettings src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CompositorOverlaySettings malloc() {
        return (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CompositorOverlaySettings calloc() {
        return (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CompositorOverlaySettings create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CompositorOverlaySettings create(long address) {
        return (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)address);
    }

    @Nullable
    public static CompositorOverlaySettings createSafe(long address) {
        return address == 0L ? null : (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CompositorOverlaySettings.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CompositorOverlaySettings.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CompositorOverlaySettings mallocStack() {
        return CompositorOverlaySettings.mallocStack(MemoryStack.stackGet());
    }

    public static CompositorOverlaySettings callocStack() {
        return CompositorOverlaySettings.callocStack(MemoryStack.stackGet());
    }

    public static CompositorOverlaySettings mallocStack(MemoryStack stack) {
        return (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CompositorOverlaySettings callocStack(MemoryStack stack) {
        return (CompositorOverlaySettings)CompositorOverlaySettings.wrap(CompositorOverlaySettings.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CompositorOverlaySettings.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CompositorOverlaySettings.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CompositorOverlaySettings.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static boolean ncurved(long struct) {
        return UNSAFE.getByte(null, struct + (long)CURVED) != 0;
    }

    public static boolean nantialias(long struct) {
        return UNSAFE.getByte(null, struct + (long)ANTIALIAS) != 0;
    }

    public static float nscale(long struct) {
        return UNSAFE.getFloat(null, struct + (long)SCALE);
    }

    public static float ndistance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DISTANCE);
    }

    public static float nalpha(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ALPHA);
    }

    public static float nuOffset(long struct) {
        return UNSAFE.getFloat(null, struct + (long)UOFFSET);
    }

    public static float nvOffset(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VOFFSET);
    }

    public static float nuScale(long struct) {
        return UNSAFE.getFloat(null, struct + (long)USCALE);
    }

    public static float nvScale(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VSCALE);
    }

    public static float ngridDivs(long struct) {
        return UNSAFE.getFloat(null, struct + (long)GRIDDIVS);
    }

    public static float ngridWidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)GRIDWIDTH);
    }

    public static float ngridScale(long struct) {
        return UNSAFE.getFloat(null, struct + (long)GRIDSCALE);
    }

    public static HmdMatrix44 ntransform(long struct) {
        return HmdMatrix44.create(struct + (long)TRANSFORM);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void ncurved(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)CURVED, value ? (byte)1 : 0);
    }

    public static void nantialias(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)ANTIALIAS, value ? (byte)1 : 0);
    }

    public static void nscale(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)SCALE, value);
    }

    public static void ndistance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DISTANCE, value);
    }

    public static void nalpha(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ALPHA, value);
    }

    public static void nuOffset(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)UOFFSET, value);
    }

    public static void nvOffset(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VOFFSET, value);
    }

    public static void nuScale(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)USCALE, value);
    }

    public static void nvScale(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VSCALE, value);
    }

    public static void ngridDivs(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)GRIDDIVS, value);
    }

    public static void ngridWidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)GRIDWIDTH, value);
    }

    public static void ngridScale(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)GRIDSCALE, value);
    }

    public static void ntransform(long struct, HmdMatrix44 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TRANSFORM), (long)HmdMatrix44.SIZEOF);
    }

    static {
        Struct.Layout layout = CompositorOverlaySettings.__struct((Struct.Member[])new Struct.Member[]{CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)1), CompositorOverlaySettings.__member((int)1), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)4), CompositorOverlaySettings.__member((int)HmdMatrix44.SIZEOF, (int)HmdMatrix44.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        CURVED = layout.offsetof(1);
        ANTIALIAS = layout.offsetof(2);
        SCALE = layout.offsetof(3);
        DISTANCE = layout.offsetof(4);
        ALPHA = layout.offsetof(5);
        UOFFSET = layout.offsetof(6);
        VOFFSET = layout.offsetof(7);
        USCALE = layout.offsetof(8);
        VSCALE = layout.offsetof(9);
        GRIDDIVS = layout.offsetof(10);
        GRIDWIDTH = layout.offsetof(11);
        GRIDSCALE = layout.offsetof(12);
        TRANSFORM = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<CompositorOverlaySettings, Buffer>
    implements NativeResource {
        private static final CompositorOverlaySettings ELEMENT_FACTORY = CompositorOverlaySettings.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CompositorOverlaySettings getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int size() {
            return CompositorOverlaySettings.nsize(this.address());
        }

        @NativeType(value="bool")
        public boolean curved() {
            return CompositorOverlaySettings.ncurved(this.address());
        }

        @NativeType(value="bool")
        public boolean antialias() {
            return CompositorOverlaySettings.nantialias(this.address());
        }

        public float scale() {
            return CompositorOverlaySettings.nscale(this.address());
        }

        public float distance() {
            return CompositorOverlaySettings.ndistance(this.address());
        }

        public float alpha() {
            return CompositorOverlaySettings.nalpha(this.address());
        }

        public float uOffset() {
            return CompositorOverlaySettings.nuOffset(this.address());
        }

        public float vOffset() {
            return CompositorOverlaySettings.nvOffset(this.address());
        }

        public float uScale() {
            return CompositorOverlaySettings.nuScale(this.address());
        }

        public float vScale() {
            return CompositorOverlaySettings.nvScale(this.address());
        }

        public float gridDivs() {
            return CompositorOverlaySettings.ngridDivs(this.address());
        }

        public float gridWidth() {
            return CompositorOverlaySettings.ngridWidth(this.address());
        }

        public float gridScale() {
            return CompositorOverlaySettings.ngridScale(this.address());
        }

        @NativeType(value="HmdMatrix44_t")
        public HmdMatrix44 transform() {
            return CompositorOverlaySettings.ntransform(this.address());
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            CompositorOverlaySettings.nsize(this.address(), value);
            return this;
        }

        public Buffer curved(@NativeType(value="bool") boolean value) {
            CompositorOverlaySettings.ncurved(this.address(), value);
            return this;
        }

        public Buffer antialias(@NativeType(value="bool") boolean value) {
            CompositorOverlaySettings.nantialias(this.address(), value);
            return this;
        }

        public Buffer scale(float value) {
            CompositorOverlaySettings.nscale(this.address(), value);
            return this;
        }

        public Buffer distance(float value) {
            CompositorOverlaySettings.ndistance(this.address(), value);
            return this;
        }

        public Buffer alpha(float value) {
            CompositorOverlaySettings.nalpha(this.address(), value);
            return this;
        }

        public Buffer uOffset(float value) {
            CompositorOverlaySettings.nuOffset(this.address(), value);
            return this;
        }

        public Buffer vOffset(float value) {
            CompositorOverlaySettings.nvOffset(this.address(), value);
            return this;
        }

        public Buffer uScale(float value) {
            CompositorOverlaySettings.nuScale(this.address(), value);
            return this;
        }

        public Buffer vScale(float value) {
            CompositorOverlaySettings.nvScale(this.address(), value);
            return this;
        }

        public Buffer gridDivs(float value) {
            CompositorOverlaySettings.ngridDivs(this.address(), value);
            return this;
        }

        public Buffer gridWidth(float value) {
            CompositorOverlaySettings.ngridWidth(this.address(), value);
            return this;
        }

        public Buffer gridScale(float value) {
            CompositorOverlaySettings.ngridScale(this.address(), value);
            return this;
        }

        public Buffer transform(@NativeType(value="HmdMatrix44_t") HmdMatrix44 value) {
            CompositorOverlaySettings.ntransform(this.address(), value);
            return this;
        }

        public Buffer transform(Consumer<HmdMatrix44> consumer) {
            consumer.accept(this.transform());
            return this;
        }
    }
}

