/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_view_stats_t")
public class BGFXViewStats
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int VIEW;
    public static final int CPUTIMEELAPSED;
    public static final int GPUTIMEELAPSED;

    public BGFXViewStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXViewStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return BGFXViewStats.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return BGFXViewStats.nnameString(this.address());
    }

    @NativeType(value="bgfx_view_id_t")
    public short view() {
        return BGFXViewStats.nview(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeElapsed() {
        return BGFXViewStats.ncpuTimeElapsed(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuTimeElapsed() {
        return BGFXViewStats.ngpuTimeElapsed(this.address());
    }

    public static BGFXViewStats create(long address) {
        return (BGFXViewStats)BGFXViewStats.wrap(BGFXViewStats.class, (long)address);
    }

    @Nullable
    public static BGFXViewStats createSafe(long address) {
        return address == 0L ? null : (BGFXViewStats)BGFXViewStats.wrap(BGFXViewStats.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXViewStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXViewStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static short nview(long struct) {
        return UNSAFE.getShort(null, struct + (long)VIEW);
    }

    public static long ncpuTimeElapsed(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEELAPSED);
    }

    public static long ngpuTimeElapsed(long struct) {
        return UNSAFE.getLong(null, struct + (long)GPUTIMEELAPSED);
    }

    static {
        Struct.Layout layout = BGFXViewStats.__struct((Struct.Member[])new Struct.Member[]{BGFXViewStats.__array((int)1, (int)256), BGFXViewStats.__member((int)2), BGFXViewStats.__member((int)8), BGFXViewStats.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        VIEW = layout.offsetof(1);
        CPUTIMEELAPSED = layout.offsetof(2);
        GPUTIMEELAPSED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXViewStats, Buffer> {
        private static final BGFXViewStats ELEMENT_FACTORY = BGFXViewStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXViewStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return BGFXViewStats.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return BGFXViewStats.nnameString(this.address());
        }

        @NativeType(value="bgfx_view_id_t")
        public short view() {
            return BGFXViewStats.nview(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeElapsed() {
            return BGFXViewStats.ncpuTimeElapsed(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuTimeElapsed() {
            return BGFXViewStats.ngpuTimeElapsed(this.address());
        }
    }
}

