/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandScope;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.StringUtil;

public class EnvironmentValueProvider
extends AbstractMapConfigurationValueProvider {
    private Map<String, String> environment = System.getenv();

    @Override
    public int getPrecedence() {
        return 150;
    }

    @Override
    protected Map<?, ?> getMap() {
        return this.environment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(CommandScope object) {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return;
        }
        object = new ArrayList<String>();
        LiquibaseConfiguration liquibaseConfiguration = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        for (Map.Entry<?, ?> entry : this.getMap().entrySet()) {
            String string = (String)entry.getKey();
            String string2 = ((String)entry.getKey()).toLowerCase();
            if (!string2.startsWith("liquibase_") || string2.equals("liquibase_home")) continue;
            String string3 = StringUtil.toCamelCase(string2);
            ConfigurationDefinition<?> configurationDefinition = liquibaseConfiguration.getRegisteredDefinition(string3);
            if (configurationDefinition == null) {
                boolean bl2 = false;
                for (CommandDefinition commandDefinition : Scope.getCurrentScope().getSingleton(CommandFactory.class).getCommands(false)) {
                    SortedMap<String, CommandArgumentDefinition<?>> sortedMap = commandDefinition.getArguments();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string4 : commandDefinition.getName()) {
                        stringBuilder.append(StringUtil.upperCaseFirst(string4));
                    }
                    String string5 = StringUtil.lowerCaseFirst(string3.replaceAll("liquibaseCommand", "").replaceAll(stringBuilder.toString(), ""));
                    if ((CommandArgumentDefinition)sortedMap.get(string5) == null) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                object.add("- ".concat(String.valueOf(string)));
                continue;
            }
            if (configurationDefinition.getCurrentValue() != null && !configurationDefinition.getCurrentConfiguredValue().wasDefaultValueUsed()) continue;
            object.add("- ".concat(String.valueOf(string)));
        }
        Boolean bl3 = GlobalConfiguration.STRICT.getCurrentValue();
        if (!object.isEmpty()) {
            void var4_10;
            String string = System.lineSeparator() + System.lineSeparator() + "Liquibase Pro detected the following invalid LIQUIBASE_* environment variables:" + System.lineSeparator() + System.lineSeparator() + StringUtil.join(object, System.lineSeparator(), true) + System.lineSeparator() + System.lineSeparator();
            if (bl3.booleanValue()) {
                String string6 = string + "Please rename them and run your command again, or set liquibase.strict=FALSE or LIQUIBASE_STRICT=FALSE." + System.lineSeparator();
            }
            String string7 = (String)var4_10 + "Find the list of valid environment variables at https://docs.liquibase.com/environment-variables" + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(string7)));
            Scope.getCurrentScope().getLog(EnvironmentValueProvider.class).warning(string7);
            if (bl3.booleanValue()) {
                throw new IllegalArgumentException(string7);
            }
        }
    }

    @Override
    protected ProvidedValue lookupProvidedValue(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        boolean bl2 = false;
        ConfigurationDefinition<?> configurationDefinition = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getRegisteredDefinition(stringArray[0]);
        if (configurationDefinition != null) {
            bl2 = this.getUnlicensedVariables().contains(configurationDefinition);
        }
        if (!bl2) {
            Object object = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
            if (object == null) {
                return null;
            }
            if ((object = ((LicenseServiceFactory)object).getLicenseService()) == null) {
                return null;
            }
            if (!object.licenseIsValid("Liquibase Pro")) {
                return null;
            }
        }
        return super.lookupProvidedValue(stringArray);
    }

    @Override
    protected String getSourceDescription() {
        return "Environment variable";
    }

    public Set<ConfigurationDefinition<?>> getUnlicensedVariables() {
        HashSet hashSet = new HashSet();
        hashSet.add(GlobalConfiguration.FILTER_LOG_MESSAGES);
        hashSet.add(LiquibaseProConfiguration.LICENSE_PRO_LICENSE_KEY);
        return hashSet;
    }

    @Override
    protected boolean keyMatches(String string, String string2) {
        if (super.keyMatches(string, string2 = StringUtil.trimToNull(string2))) {
            return true;
        }
        if ((string = StringUtil.toKabobCase(string.replace(".", "-"))).equalsIgnoreCase(string2)) {
            return true;
        }
        return string.replace("-", "_").equalsIgnoreCase(string2);
    }
}

