/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.languagetool.tools.StringTools;

public class ManualSynthesizer {
    private final Map<String, List<String>> mapping;
    private Set<String> possibleTags = new HashSet<String>();

    public ManualSynthesizer(InputStream inputStream) throws IOException {
        this.mapping = this.loadMapping(inputStream, "utf8");
        this.possibleTags = Collections.unmodifiableSet(this.possibleTags);
    }

    public Set<String> getPossibleTags() {
        return this.possibleTags;
    }

    public List<String> lookup(String lemma, String posTag) {
        return this.mapping.get(lemma + "|" + posTag);
    }

    private Map<String, List<String>> loadMapping(InputStream inputStream, String encoding) throws IOException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try (Scanner scanner = new Scanner(inputStream, encoding);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = line.split("\t");
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual synthesizer dictionary: " + line);
                }
                String key = parts[1] + "|" + parts[2];
                if (!map.containsKey(key)) {
                    map.put(key, new ArrayList());
                }
                ((List)map.get(key)).add(parts[0]);
                this.possibleTags.add(parts[2]);
            }
        }
        return map;
    }
}

