/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.XMLRuleHandler;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PatternRuleHandler
extends XMLRuleHandler {
    public static final String TYPE = "type";
    static final String MARKER_TAG = "<marker>";
    static final String PLEASE_SPELL_ME = "<pleasespellme/>";
    protected Category category;
    protected String categoryIssueType;
    protected String ruleGroupIssueType;
    protected String ruleIssueType;
    protected String name;
    private int subId;
    private boolean defaultOff;
    private boolean defaultOn;
    private String ruleGroupDescription;
    private int startPos = -1;
    private int endPos = -1;
    private int tokenCountForMarker = 0;
    private int antiPatternCounter = 0;
    private boolean inRule;
    private List<DisambiguationPatternRule> rulegroupAntiPatterns;
    private List<DisambiguationPatternRule> ruleAntiPatterns;
    private boolean relaxedMode = false;
    private boolean inAntiPattern;

    void setRelaxedMode(boolean relaxedMode) {
        this.relaxedMode = relaxedMode;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        switch (qName) {
            case "category": {
                String catName = attrs.getValue("name");
                String priorityStr = attrs.getValue("priority");
                this.category = priorityStr == null ? new Category(catName) : new Category(catName, Integer.parseInt(priorityStr));
                if ("off".equals(attrs.getValue("default"))) {
                    this.category.setDefaultOff();
                }
                if (attrs.getValue(TYPE) == null) break;
                this.categoryIssueType = attrs.getValue(TYPE);
                break;
            }
            case "rules": {
                String languageStr = attrs.getValue("lang");
                this.language = Language.getLanguageForShortName(languageStr);
                break;
            }
            case "rule": {
                this.inRule = true;
                this.shortMessage = new StringBuilder();
                this.message = new StringBuilder();
                this.suggestionsOutMsg = new StringBuilder();
                this.url = new StringBuilder();
                this.id = attrs.getValue("id");
                if (this.inRuleGroup) {
                    ++this.subId;
                }
                if (!this.inRuleGroup || !this.defaultOff) {
                    this.defaultOff = "off".equals(attrs.getValue("default"));
                }
                if (!this.inRuleGroup || !this.defaultOn) {
                    this.defaultOn = "on".equals(attrs.getValue("default"));
                }
                if (this.inRuleGroup && this.id == null) {
                    this.id = this.ruleGroupId;
                }
                this.name = attrs.getValue("name");
                if (this.inRuleGroup && this.name == null) {
                    this.name = this.ruleGroupDescription;
                }
                this.correctExamples = new ArrayList();
                this.incorrectExamples = new ArrayList();
                if (this.suggestionMatches != null) {
                    this.suggestionMatches.clear();
                }
                if (this.suggestionMatchesOutMsg != null) {
                    this.suggestionMatchesOutMsg.clear();
                }
                if (attrs.getValue(TYPE) == null) break;
                this.ruleIssueType = attrs.getValue(TYPE);
                break;
            }
            case "pattern": {
                this.startPattern(attrs);
                this.tokenCountForMarker = 0;
                break;
            }
            case "antipattern": {
                this.inAntiPattern = true;
                ++this.antiPatternCounter;
                this.caseSensitive = "yes".equals(attrs.getValue("case_sensitive"));
                this.tokenCounter = 0;
                this.tokenCountForMarker = 0;
                break;
            }
            case "and": {
                this.inAndGroup = true;
                ++this.tokenCountForMarker;
                break;
            }
            case "or": {
                this.inOrGroup = true;
                ++this.tokenCountForMarker;
                break;
            }
            case "unify": {
                this.inUnification = true;
                this.uniNegation = "yes".equals(attrs.getValue("negate"));
                break;
            }
            case "unify-ignore": {
                this.inUnificationNeutral = true;
                break;
            }
            case "feature": {
                this.uFeature = attrs.getValue("id");
                break;
            }
            case "type": {
                this.uType = attrs.getValue("id");
                this.uTypeList.add(this.uType);
                break;
            }
            case "token": {
                this.setToken(attrs);
                if (this.inAndGroup || this.inOrGroup) break;
                ++this.tokenCountForMarker;
                break;
            }
            case "exception": {
                this.setExceptions(attrs);
                break;
            }
            case "example": {
                if (attrs.getValue(TYPE).equals("correct")) {
                    this.inCorrectExample = true;
                    this.correctExample = new StringBuilder();
                    break;
                }
                if (!attrs.getValue(TYPE).equals("incorrect")) break;
                this.inIncorrectExample = true;
                this.incorrectExample = new StringBuilder();
                this.exampleCorrection = new StringBuilder();
                if (attrs.getValue("correction") == null) break;
                this.exampleCorrection.append(attrs.getValue("correction"));
                break;
            }
            case "message": {
                this.inMessage = true;
                this.inSuggestion = false;
                this.message = new StringBuilder();
                break;
            }
            case "suggestion": {
                if ("yes".equals(attrs.getValue("suppress_misspelled"))) {
                    this.message.append(PLEASE_SPELL_ME);
                }
                if (this.inMessage) {
                    this.message.append("<suggestion>");
                } else {
                    this.suggestionsOutMsg.append("<suggestion>");
                }
                this.inSuggestion = true;
                break;
            }
            case "short": {
                this.inShortMessage = true;
                this.shortMessage = new StringBuilder();
                break;
            }
            case "url": {
                this.inUrl = true;
                this.url = new StringBuilder();
                break;
            }
            case "rulegroup": {
                this.ruleGroupId = attrs.getValue("id");
                this.ruleGroupDescription = attrs.getValue("name");
                this.defaultOff = "off".equals(attrs.getValue("default"));
                this.defaultOn = "on".equals(attrs.getValue("default"));
                this.inRuleGroup = true;
                this.subId = 0;
                if (attrs.getValue(TYPE) == null) break;
                this.ruleGroupIssueType = attrs.getValue(TYPE);
                break;
            }
            case "match": {
                this.setMatchElement(attrs);
                break;
            }
            case "marker": {
                if (this.inIncorrectExample) {
                    this.incorrectExample.append(MARKER_TAG);
                    break;
                }
                if (this.inCorrectExample) {
                    this.correctExample.append(MARKER_TAG);
                    break;
                }
                if (!this.inPattern && !this.inAntiPattern) break;
                this.startPos = this.tokenCounter;
                this.inMarker = true;
                break;
            }
            case "unification": {
                this.uFeature = attrs.getValue("feature");
                this.inUnificationDef = true;
                break;
            }
            case "equivalence": {
                this.uType = attrs.getValue(TYPE);
                break;
            }
            case "phrases": {
                this.inPhrases = true;
                break;
            }
            case "includephrases": {
                this.phraseElementInit();
                break;
            }
            case "phrase": {
                if (!this.inPhrases) break;
                this.phraseId = attrs.getValue("id");
                break;
            }
            case "phraseref": {
                if (attrs.getValue("idref") == null) break;
                this.preparePhrase(attrs);
                ++this.tokenCountForMarker;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        switch (qName) {
            case "category": {
                this.categoryIssueType = null;
                break;
            }
            case "rule": {
                this.suggestionMatchesOutMsg = this.addLegacyMatches(this.suggestionMatchesOutMsg, this.suggestionsOutMsg.toString(), false);
                this.phraseElementInit();
                if (this.relaxedMode && this.id == null) {
                    this.id = "";
                }
                if (this.relaxedMode && this.name == null) {
                    this.name = "";
                }
                if (this.phraseElementList.isEmpty()) {
                    ArrayList<Element> tmpElements = new ArrayList<Element>();
                    this.createRules(new ArrayList<Element>(this.elementList), tmpElements, 0);
                } else {
                    if (!this.elementList.isEmpty()) {
                        for (List ph : this.phraseElementList) {
                            ph.addAll(new ArrayList(this.elementList));
                        }
                    }
                    for (List phraseElement : this.phraseElementList) {
                        this.processElement(phraseElement);
                        ArrayList<Element> tmpElements = new ArrayList<Element>();
                        this.createRules(phraseElement, tmpElements, 0);
                    }
                }
                this.elementList.clear();
                if (this.phraseElementList != null) {
                    this.phraseElementList.clear();
                }
                this.ruleIssueType = null;
                this.inRule = false;
                break;
            }
            case "exception": {
                this.finalizeExceptions();
                break;
            }
            case "and": {
                this.inAndGroup = false;
                this.andGroupCounter = 0;
                ++this.tokenCounter;
                break;
            }
            case "or": {
                this.inOrGroup = false;
                this.orGroupCounter = 0;
                ++this.tokenCounter;
                break;
            }
            case "token": {
                this.finalizeTokens();
                break;
            }
            case "pattern": {
                this.inPattern = false;
                if (this.lastPhrase) {
                    this.elementList.clear();
                }
                this.tokenCounter = 0;
                break;
            }
            case "antipattern": {
                DisambiguationPatternRule rule = new DisambiguationPatternRule(this.id + "_antipattern:" + this.antiPatternCounter, "antipattern", this.language, this.elementList, null, null, DisambiguationPatternRule.DisambiguatorAction.IMMUNIZE);
                if (this.startPos != -1 && this.endPos != -1) {
                    rule.setStartPositionCorrection(this.startPos);
                    rule.setEndPositionCorrection(this.endPos - this.tokenCountForMarker);
                }
                this.elementList.clear();
                if (this.inRule) {
                    if (this.ruleAntiPatterns == null) {
                        this.ruleAntiPatterns = new ArrayList<DisambiguationPatternRule>();
                    }
                    this.ruleAntiPatterns.add(rule);
                } else {
                    if (this.rulegroupAntiPatterns == null) {
                        this.rulegroupAntiPatterns = new ArrayList<DisambiguationPatternRule>();
                    }
                    this.rulegroupAntiPatterns.add(rule);
                }
                this.tokenCounter = 0;
                this.inAntiPattern = false;
                break;
            }
            case "example": {
                if (this.inCorrectExample) {
                    this.correctExamples.add(this.correctExample.toString());
                } else if (this.inIncorrectExample) {
                    String[] corrections = this.exampleCorrection.toString().split("\\|");
                    IncorrectExample example = corrections.length > 0 && corrections[0].length() > 0 ? new IncorrectExample(this.incorrectExample.toString(), corrections) : new IncorrectExample(this.incorrectExample.toString());
                    this.incorrectExamples.add(example);
                }
                this.inCorrectExample = false;
                this.inIncorrectExample = false;
                this.correctExample = new StringBuilder();
                this.incorrectExample = new StringBuilder();
                this.exampleCorrection = new StringBuilder();
                break;
            }
            case "message": {
                this.suggestionMatches = this.addLegacyMatches(this.suggestionMatches, this.message.toString(), true);
                this.inMessage = false;
                break;
            }
            case "suggestion": {
                if (this.inMessage) {
                    this.message.append("</suggestion>");
                } else {
                    this.suggestionsOutMsg.append("</suggestion>");
                }
                this.inSuggestion = false;
                break;
            }
            case "short": {
                this.inShortMessage = false;
                break;
            }
            case "url": {
                this.inUrl = false;
                break;
            }
            case "match": {
                if (this.inMessage) {
                    ((Match)this.suggestionMatches.get(this.suggestionMatches.size() - 1)).setLemmaString(this.match.toString());
                } else if (this.inSuggestion) {
                    ((Match)this.suggestionMatchesOutMsg.get(this.suggestionMatchesOutMsg.size() - 1)).setLemmaString(this.match.toString());
                } else if (this.inToken) {
                    this.tokenReference.setLemmaString(this.match.toString());
                }
                this.inMatch = false;
                break;
            }
            case "rulegroup": {
                this.inRuleGroup = false;
                this.ruleGroupIssueType = null;
                if (this.rulegroupAntiPatterns != null) {
                    this.rulegroupAntiPatterns.clear();
                }
                this.antiPatternCounter = 0;
                break;
            }
            case "marker": {
                if (this.inCorrectExample) {
                    this.correctExample.append("</marker>");
                    break;
                }
                if (this.inIncorrectExample) {
                    this.incorrectExample.append("</marker>");
                    break;
                }
                if (!this.inPattern && !this.inAntiPattern) break;
                this.endPos = this.tokenCountForMarker;
                this.inMarker = false;
                break;
            }
            case "phrase": {
                if (!this.inPhrases) break;
                this.finalizePhrase();
                break;
            }
            case "includephrases": {
                this.elementList.clear();
                break;
            }
            case "phrases": {
                if (!this.inPhrases) break;
                this.inPhrases = false;
                break;
            }
            case "unification": {
                this.inUnificationDef = false;
                break;
            }
            case "feature": {
                this.equivalenceFeatures.put(this.uFeature, this.uTypeList);
                this.uTypeList = new ArrayList();
                break;
            }
            case "unify": {
                this.inUnification = false;
                this.equivalenceFeatures = new HashMap();
                int lastElement = this.elementList.size() - 1;
                ((Element)this.elementList.get(lastElement)).setLastInUnification();
                if (!this.uniNegation) break;
                ((Element)this.elementList.get(lastElement)).setUniNegation();
                break;
            }
            case "unify-ignore": {
                this.inUnificationNeutral = false;
            }
        }
    }

    private void createRules(List<Element> elemList, List<Element> tmpElements, int numElement) {
        if (numElement >= elemList.size()) {
            PatternRule rule = new PatternRule(this.id, this.language, tmpElements, this.name, this.message.toString(), this.shortMessage.toString(), this.suggestionsOutMsg.toString(), this.phraseElementList.size() > 1);
            this.prepareRule(rule);
            this.rules.add(rule);
        } else {
            Element element = elemList.get(numElement);
            if (element.hasOrGroup()) {
                for (Element elementOfOrGroup : element.getOrGroup()) {
                    ArrayList<Element> tmpElements2 = new ArrayList<Element>();
                    tmpElements2.addAll(tmpElements);
                    tmpElements2.add((Element)ObjectUtils.clone((Object)elementOfOrGroup));
                    this.createRules(elemList, tmpElements2, numElement + 1);
                }
            }
            tmpElements.add((Element)ObjectUtils.clone((Object)element));
            this.createRules(elemList, tmpElements, numElement + 1);
        }
    }

    protected void prepareRule(PatternRule rule) {
        if (this.startPos != -1 && this.endPos != -1) {
            rule.setStartPositionCorrection(this.startPos);
            rule.setEndPositionCorrection(this.endPos - this.tokenCountForMarker);
        }
        this.startPos = -1;
        this.endPos = -1;
        rule.setCorrectExamples(this.correctExamples);
        rule.setIncorrectExamples(this.incorrectExamples);
        rule.setCategory(this.category);
        if (this.rulegroupAntiPatterns != null && !this.rulegroupAntiPatterns.isEmpty()) {
            rule.setAntiPatterns(this.rulegroupAntiPatterns);
        }
        if (this.ruleAntiPatterns != null && !this.ruleAntiPatterns.isEmpty()) {
            rule.setAntiPatterns(this.ruleAntiPatterns);
            this.ruleAntiPatterns.clear();
        }
        if (this.inRuleGroup) {
            rule.setSubId(Integer.toString(this.subId));
        } else {
            rule.setSubId("1");
        }
        this.caseSensitive = false;
        if (this.suggestionMatches != null) {
            for (Match m : this.suggestionMatches) {
                rule.addSuggestionMatch(m);
            }
            if (this.phraseElementList.size() <= 1) {
                this.suggestionMatches.clear();
            }
        }
        if (this.suggestionMatchesOutMsg != null) {
            for (Match m : this.suggestionMatchesOutMsg) {
                rule.addSuggestionMatchOutMsg(m);
            }
            this.suggestionMatchesOutMsg.clear();
        }
        if (this.defaultOff) {
            rule.setDefaultOff();
        }
        if (this.category == null) {
            throw new RuntimeException("Cannot activate rule '" + this.id + "', it is outside of a <category>...</category>");
        }
        if (this.category.isDefaultOff() && !this.defaultOn) {
            rule.setDefaultOff();
        }
        if (this.url != null && this.url.length() > 0) {
            try {
                rule.setUrl(new URL(this.url.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not parse URL for rule: " + rule + ": '" + this.url + "'", e);
            }
        }
        if (this.ruleIssueType != null) {
            rule.setLocQualityIssueType(ITSIssueType.getIssueType(this.ruleIssueType));
        } else if (this.ruleGroupIssueType != null) {
            rule.setLocQualityIssueType(ITSIssueType.getIssueType(this.ruleGroupIssueType));
        } else if (this.categoryIssueType != null) {
            rule.setLocQualityIssueType(ITSIssueType.getIssueType(this.categoryIssueType));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inException) {
            this.exceptions.append(s);
        } else if (this.inToken) {
            this.elements.append(s);
        } else if (this.inCorrectExample) {
            this.correctExample.append(s);
        } else if (this.inIncorrectExample) {
            this.incorrectExample.append(s);
        } else if (this.inMatch) {
            this.match.append(s);
        } else if (this.inMessage) {
            this.message.append(s);
        } else if (this.inSuggestion) {
            this.suggestionsOutMsg.append(s);
        } else if (this.inShortMessage) {
            this.shortMessage.append(s);
        } else if (this.inUrl) {
            this.url.append(s);
        }
    }
}

