/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class PatternRule
extends AbstractPatternRule {
    private final String shortMessage;
    private final List<Integer> elementNo;
    private final Set<String> simpleRuleTokens;
    private final Set<String> inflectedRuleTokens;
    private final List<DisambiguationPatternRule> antiPatterns;
    private String message;
    private String suggestionsOutMsg;
    private List<Match> suggestionMatches;
    private List<Match> suggestionMatchesOutMsg;
    private Set<String> tokenSet;
    private Set<String> lemmaSet;
    private boolean useList;
    private boolean isMemberOfDisjunctiveSet;

    public PatternRule(String id, Language language, List<Element> elements, String description, String message, String shortMessage) {
        super(id, description, language, elements, false);
        this.message = message;
        this.shortMessage = shortMessage;
        this.elementNo = new ArrayList<Integer>();
        this.suggestionsOutMsg = "";
        String prevName = "";
        int cnt = 0;
        int loopCnt = 0;
        for (Element e : this.patternElements) {
            if (e.isPartOfPhrase()) {
                String curName = e.getPhraseName();
                if (prevName.equals(curName) || StringTools.isEmpty(prevName)) {
                    ++cnt;
                    this.useList = true;
                } else {
                    this.elementNo.add(cnt);
                    curName = "";
                    cnt = 0;
                }
                prevName = curName;
                if (++loopCnt != this.patternElements.size() || StringTools.isEmpty(prevName)) continue;
                this.elementNo.add(cnt);
                continue;
            }
            if (cnt > 0) {
                this.elementNo.add(cnt);
            }
            this.elementNo.add(1);
            ++loopCnt;
        }
        this.simpleRuleTokens = this.getSimpleTokens();
        this.inflectedRuleTokens = this.getInflectedTokens();
        this.antiPatterns = new ArrayList<DisambiguationPatternRule>();
    }

    public PatternRule(String id, Language language, List<Element> elements, String description, String message, String shortMessage, String suggestionsOutMsg) {
        this(id, language, elements, description, message, shortMessage);
        this.suggestionsOutMsg = suggestionsOutMsg;
    }

    public PatternRule(String id, Language language, List<Element> elements, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember) {
        this(id, language, elements, description, message, shortMessage, suggestionsOutMsg);
        this.isMemberOfDisjunctiveSet = isMember;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public final String getSuggestionsOutMsg() {
        return this.suggestionsOutMsg;
    }

    public final boolean isWithComplexPhrase() {
        return this.isMemberOfDisjunctiveSet;
    }

    public final void notComplexPhrase() {
        this.isMemberOfDisjunctiveSet = false;
    }

    public final String toPatternString() {
        ArrayList<String> strList = new ArrayList<String>();
        for (Element patternElement : this.patternElements) {
            strList.add(patternElement.toString());
        }
        return StringTools.listToString(strList, ", ");
    }

    public final String toXML() {
        PatternRuleXmlCreator xmlCreator = new PatternRuleXmlCreator();
        try {
            return xmlCreator.toXML(new PatternRuleId(this.getId(), this.getSubId()), this.getLanguage());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not return string representation of rule", e);
        }
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        try {
            PatternRuleMatcher matcher = new PatternRuleMatcher(this, this.useList);
            return matcher.match(this.getSentenceWithImmunization(sentence));
        }
        catch (IOException e) {
            throw new IOException("Error analyzing sentence: '" + sentence + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error analyzing sentence: '" + sentence + "'", e);
        }
    }

    public final void addSuggestionMatch(Match m) {
        if (this.suggestionMatches == null) {
            this.suggestionMatches = new ArrayList<Match>();
        }
        this.suggestionMatches.add(m);
    }

    public final void addSuggestionMatchOutMsg(Match m) {
        if (this.suggestionMatchesOutMsg == null) {
            this.suggestionMatchesOutMsg = new ArrayList<Match>();
        }
        this.suggestionMatchesOutMsg.add(m);
    }

    public final List<Element> getElements() {
        return this.patternElements;
    }

    public boolean canBeIgnoredFor(AnalyzedSentence sentence) {
        return !this.simpleRuleTokens.isEmpty() && !sentence.getTokenSet().containsAll(this.simpleRuleTokens) || !this.inflectedRuleTokens.isEmpty() && !sentence.getLemmaSet().containsAll(this.inflectedRuleTokens);
    }

    private synchronized Set<String> getSimpleTokens() {
        if (this.tokenSet == null) {
            this.tokenSet = new HashSet<String>();
            for (Element element : this.patternElements) {
                String str;
                if (element.getNegation() || element.isRegularExpression() || element.isReferenceElement() || element.isInflected() || element.getMinOccurrence() <= 0 || StringTools.isEmpty(str = element.getString())) continue;
                this.tokenSet.add(str.toLowerCase());
            }
        }
        return this.tokenSet;
    }

    private synchronized Set<String> getInflectedTokens() {
        if (this.lemmaSet == null) {
            this.lemmaSet = new HashSet<String>();
            for (Element element : this.patternElements) {
                String str;
                if (element.getNegation() || element.isRegularExpression() || element.isReferenceElement() || !element.isInflected() || element.getMinOccurrence() <= 0 || StringTools.isEmpty(str = element.getString())) continue;
                this.lemmaSet.add(str.toLowerCase());
            }
        }
        return this.lemmaSet;
    }

    List<Integer> getElementNo() {
        return this.elementNo;
    }

    String getShortMessage() {
        return this.shortMessage;
    }

    List<Match> getSuggestionMatches() {
        return this.suggestionMatches;
    }

    List<Match> getSuggestionMatchesOutMsg() {
        return this.suggestionMatchesOutMsg;
    }

    public void setAntiPatterns(List<DisambiguationPatternRule> antiPatterns) {
        this.antiPatterns.addAll(antiPatterns);
    }

    private AnalyzedSentence getSentenceWithImmunization(AnalyzedSentence sentence) throws IOException {
        if (this.antiPatterns != null && !this.antiPatterns.isEmpty()) {
            AnalyzedSentence immunizedSentence = sentence.copy(sentence);
            for (DisambiguationPatternRule patternRule : this.antiPatterns) {
                immunizedSentence = patternRule.replace(immunizedSentence);
            }
            return immunizedSentence;
        }
        return sentence;
    }
}

