/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.randname;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    private List<String> nouns = new ArrayList<String>();
    private List<String> adjectives = new ArrayList<String>();
    private final int prime;
    static final Dictionary INSTANCE = new Dictionary();

    public Dictionary() {
        int primeCombo;
        int nextPrime;
        try {
            this.load("a.txt", this.adjectives);
            this.load("n.txt", this.nouns);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        int combo = this.size();
        for (primeCombo = 2; primeCombo <= combo; primeCombo *= nextPrime) {
            nextPrime = primeCombo + 1;
        }
        this.prime = primeCombo + 1;
    }

    public int size() {
        return this.nouns.size() * this.adjectives.size();
    }

    public int getPrime() {
        return this.prime;
    }

    public String word(int i) {
        int a = i % this.adjectives.size();
        int n = i / this.adjectives.size();
        return this.adjectives.get(a) + "_" + this.nouns.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String name, List<String> col) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(name), "US-ASCII"));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                col.add(line);
            }
        }
        finally {
            r.close();
        }
    }
}

