/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.groovy.sandbox.impl;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ObjectRange;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.impl.ClosureSupport;
import org.kohsuke.groovy.sandbox.impl.GroovyCallSiteSelector;
import org.kohsuke.groovy.sandbox.impl.Ops;
import org.kohsuke.groovy.sandbox.impl.SingleArgInvokerChain;
import org.kohsuke.groovy.sandbox.impl.Super;
import org.kohsuke.groovy.sandbox.impl.TwoArgInvokerChain;
import org.kohsuke.groovy.sandbox.impl.VarArgInvokerChain;
import org.kohsuke.groovy.sandbox.impl.ZeroArgInvokerChain;

public class Checker {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final HashMap<Map.Entry<Class<?>, String>, Method> GROOVY_RUNTIME_REPLACEMENTS = new HashMap();
    private static final Map<Class<?>, Class<?>> BOX_TO_PRIMITIVE;

    private static CallSite fakeCallSite(String method) {
        CallSiteArray csa = new CallSiteArray(Checker.class, new String[]{method});
        return csa.array[0];
    }

    public static Object checkedCall(Object _receiver, boolean safe, boolean spread, String _method, Object[] _args) throws Throwable {
        if (safe && _receiver == null) {
            return null;
        }
        _args = Checker.fixNull(_args);
        if (spread) {
            ArrayList<Object> r = new ArrayList<Object>();
            Iterator itr = InvokerHelper.asIterator((Object)_receiver);
            while (itr.hasNext()) {
                Object it = itr.next();
                if (it == null) continue;
                r.add(Checker.checkedCall(it, true, false, _method, _args));
            }
            return r;
        }
        if (_receiver instanceof Class) {
            MetaClassImpl mci;
            MetaMethod m;
            Thunk maybeReplacement = Checker.findCheckedReplacement((Class)_receiver, _method, _args);
            if (maybeReplacement != null) {
                return maybeReplacement.call();
            }
            MetaClass mc = InvokerHelper.getMetaClass((Class)((Class)_receiver));
            if (mc instanceof MetaClassImpl && (m = (mci = (MetaClassImpl)mc).retrieveStaticMethod(_method, _args)) != null && m.isStatic()) {
                if (m.getDeclaringClass().getTheClass() == Class.class) {
                    return Checker.checkedStaticCall(Class.class, _method, _args);
                }
                return Checker.checkedStaticCall((Class)_receiver, _method, _args);
            }
        }
        if (_receiver instanceof Closure) {
            MetaMethod m;
            if (_method.equals("invokeMethod") && Checker.isInvokingMethodOnClosure(_receiver, _method, _args)) {
                _method = _args[0].toString();
                _args = (Object[])_args[1];
            }
            if ((m = InvokerHelper.getMetaClass((Object)_receiver).pickMethod(_method, MetaClassHelper.convertToTypeArray((Object[])_args))) == null) {
                List<Object> targets = ClosureSupport.targetsOf((Closure)_receiver);
                Class[] argTypes = MetaClassHelper.convertToTypeArray((Object[])_args);
                for (Object candidate : targets) {
                    if (InvokerHelper.getMetaClass((Object)candidate).pickMethod(_method, argTypes) == null) continue;
                    return Checker.checkedCall(candidate, false, false, _method, _args);
                }
                for (Object candidate : targets) {
                    try {
                        return Checker.checkedCall(candidate, false, false, "invokeMethod", new Object[]{_method, _args});
                    }
                    catch (MissingMethodException missingMethodException) {
                    }
                }
            }
        }
        return new VarArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String method, Object ... args) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onMethodCall(this, receiver, method, args);
                }
                return Checker.fakeCallSite(method).call(receiver, args);
            }
        }.call(_receiver, _method, _args);
    }

    private static boolean isInvokingMethodOnClosure(Object receiver, String method, Object ... args) {
        MetaMethod m;
        return receiver instanceof Closure && (m = InvokerHelper.getMetaClass((Object)receiver).pickMethod(method, MetaClassHelper.convertToTypeArray((Object[])args))) != null && m.getDeclaringClass().isAssignableFrom(Closure.class);
    }

    public static Object checkedStaticCall(Class _receiver, String _method, Object[] _args) throws Throwable {
        Thunk maybeReplacement = Checker.findCheckedReplacement(_receiver, _method, _args = Checker.fixNull(_args));
        if (maybeReplacement != null) {
            return maybeReplacement.call();
        }
        return new VarArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String method, Object ... args) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onStaticCall(this, (Class)receiver, method, args);
                }
                return Checker.fakeCallSite(method).callStatic((Class)receiver, args);
            }
        }.call((Object)_receiver, _method, _args);
    }

    public static Object checkedConstructor(Class _type, Object[] _args) throws Throwable {
        GroovyCallSiteSelector.findConstructor(_type, _args, null);
        return new VarArgInvokerChain(_type){

            @Override
            public Object call(Object receiver, String method, Object ... args) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onNewInstance(this, (Class)receiver, args);
                }
                return Checker.fakeCallSite("<init>").callConstructor((Object)((Class)receiver), args);
            }
        }.call((Object)_type, (String)null, Checker.fixNull(_args));
    }

    public static Object checkedSuperCall(Class _senderType, Object _receiver, String _method, Object[] _args) throws Throwable {
        Super s = new Super(_senderType, _receiver);
        return new VarArgInvokerChain(s){

            @Override
            public Object call(Object _s, String method, Object ... args) throws Throwable {
                Super s = (Super)_s;
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onSuperCall(this, s.senderType, s.receiver, method, args);
                }
                try {
                    MetaClass mc = InvokerHelper.getMetaClass(s.receiver.getClass());
                    return mc.invokeMethod(s.senderType.getSuperclass(), s.receiver, method, args, true, true);
                }
                catch (GroovyRuntimeException gre) {
                    throw ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
                }
            }
        }.call((Object)s, _method, Checker.fixNull(_args));
    }

    public static SuperConstructorWrapper checkedSuperConstructor(Class<?> thisClass, final Class<?> superClass, Object[] superCallArgs, Object[] constructorArgs, Class<?>[] constructorParamTypes) throws Throwable {
        GroovyCallSiteSelector.findConstructor(superClass, superCallArgs, SuperConstructorWrapper.class);
        Checker.explicitConstructorCallSanity(thisClass, SuperConstructorWrapper.class, constructorArgs, constructorParamTypes);
        new VarArgInvokerChain(superClass){

            @Override
            public Object call(Object receiver, String method, Object ... args) throws Throwable {
                if (this.chain.hasNext()) {
                    ((GroovyInterceptor)this.chain.next()).onSuperConstructor(this, superClass, args);
                }
                return null;
            }
        }.call((Object)superClass, (String)null, Checker.fixNull(superCallArgs));
        return new SuperConstructorWrapper(superCallArgs);
    }

    public static ThisConstructorWrapper checkedThisConstructor(final Class<?> clazz, Object[] thisCallArgs, Object[] constructorArgs, Class<?>[] constructorParamTypes) throws Throwable {
        GroovyCallSiteSelector.findConstructor(clazz, thisCallArgs, ThisConstructorWrapper.class);
        Checker.explicitConstructorCallSanity(clazz, ThisConstructorWrapper.class, constructorArgs, constructorParamTypes);
        new VarArgInvokerChain(clazz){

            @Override
            public Object call(Object receiver, String method, Object ... args) throws Throwable {
                if (this.chain.hasNext()) {
                    ((GroovyInterceptor)this.chain.next()).onNewInstance(this, clazz, args);
                }
                return null;
            }
        }.call((Object)clazz, (String)null, Checker.fixNull(thisCallArgs));
        return new ThisConstructorWrapper(thisCallArgs);
    }

    private static void explicitConstructorCallSanity(Class<?> thisClass, Class<?> wrapperClass, Object[] argsExcludingWrapper, Class<?>[] paramsIncludingWrapper) {
        Class[] argTypes = new Class[argsExcludingWrapper.length + 1];
        argTypes[0] = wrapperClass;
        System.arraycopy(MetaClassHelper.convertToTypeArray((Object[])argsExcludingWrapper), 0, argTypes, 1, argsExcludingWrapper.length);
        Constructor<?> expectedConstructor = null;
        try {
            expectedConstructor = thisClass.getDeclaredConstructor(paramsIncludingWrapper);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("Unable to find original constructor", e);
        }
        ParameterTypes expectedParamTypes = new ParameterTypes((Class[])paramsIncludingWrapper);
        for (Constructor<?> c : thisClass.getDeclaredConstructors()) {
            ParameterTypes cParamTypes = new ParameterTypes((Class[])c.getParameterTypes());
            if (c.equals(expectedConstructor) || !cParamTypes.isValidMethod(argTypes) || !GroovyCallSiteSelector.isMoreSpecific(cParamTypes, expectedParamTypes, argTypes)) continue;
            throw new SecurityException("Rejecting unexpected invocation of constructor: " + c + ". Expected to invoke synthetic constructor: " + expectedConstructor);
        }
    }

    public static Object checkedGetProperty(Object _receiver, boolean safe, boolean spread, Object _property) throws Throwable {
        if (safe && _receiver == null) {
            return null;
        }
        if (spread || _receiver instanceof Collection && !ClosureSupport.BUILTIN_PROPERTIES.contains(_property)) {
            ArrayList<Object> r = new ArrayList<Object>();
            Iterator itr = InvokerHelper.asIterator((Object)_receiver);
            while (itr.hasNext()) {
                Object it = itr.next();
                if (it == null) continue;
                r.add(Checker.checkedGetProperty(it, true, false, _property));
            }
            return r;
        }
        if (Checker.isInvokingMethodOnClosure(_receiver, "getProperty", _property) && !ClosureSupport.BUILTIN_PROPERTIES.contains(_property)) {
            MissingPropertyException x = null;
            for (Object candidate : ClosureSupport.targetsOf((Closure)_receiver)) {
                try {
                    return Checker.checkedGetProperty(candidate, false, false, _property);
                }
                catch (MissingPropertyException e) {
                    x = e;
                }
            }
            if (x != null) {
                throw x;
            }
            throw new MissingPropertyException(_property.toString(), _receiver.getClass());
        }
        if (_receiver instanceof Map) {
            return Checker.checkedCall(_receiver, false, false, "get", new Object[]{_property});
        }
        return new ZeroArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String property) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onGetProperty(this, receiver, property);
                }
                return ScriptBytecodeAdapter.getProperty(null, (Object)receiver, (String)property);
            }
        }.call(_receiver, _property.toString());
    }

    public static Object checkedSetProperty(Object _receiver, Object _property, boolean safe, boolean spread, int op, Object _value) throws Throwable {
        if (op != 100) {
            Object v = Checker.checkedGetProperty(_receiver, safe, spread, _property);
            return Checker.checkedSetProperty(_receiver, _property, safe, spread, 100, Checker.checkedBinaryOp(v, Ops.compoundAssignmentToBinaryOperator(op), _value));
        }
        if (safe && _receiver == null) {
            return _value;
        }
        if (spread) {
            Iterator itr = InvokerHelper.asIterator((Object)_receiver);
            while (itr.hasNext()) {
                Object it = itr.next();
                if (it == null) continue;
                Checker.checkedSetProperty(it, _property, true, false, op, _value);
            }
            return _value;
        }
        if (Checker.isInvokingMethodOnClosure(_receiver, "setProperty", _property, _value) && !ClosureSupport.BUILTIN_PROPERTIES.contains(_property)) {
            GroovyRuntimeException x = null;
            for (Object candidate : ClosureSupport.targetsOf((Closure)_receiver)) {
                try {
                    return Checker.checkedSetProperty(candidate, _property, false, false, op, _value);
                }
                catch (GroovyRuntimeException e) {
                    x = e;
                }
            }
            if (x != null) {
                throw x;
            }
            throw new MissingPropertyException(_property.toString(), _receiver.getClass());
        }
        if (_receiver instanceof Map) {
            Checker.checkedCall(_receiver, false, false, "put", new Object[]{_property, _value});
            return _value;
        }
        return new SingleArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String property, Object value) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onSetProperty(this, receiver, property, value);
                }
                ScriptBytecodeAdapter.setProperty((Object)value, null, (Object)receiver, (String)property);
                return value;
            }
        }.call(_receiver, _property.toString(), _value);
    }

    public static Object checkedGetAttribute(Object _receiver, boolean safe, boolean spread, Object _property) throws Throwable {
        if (safe && _receiver == null) {
            return null;
        }
        if (spread) {
            ArrayList<Object> r = new ArrayList<Object>();
            Iterator itr = InvokerHelper.asIterator((Object)_receiver);
            while (itr.hasNext()) {
                Object it = itr.next();
                if (it == null) continue;
                r.add(Checker.checkedGetAttribute(it, true, false, _property));
            }
            return r;
        }
        return new ZeroArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String property) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onGetAttribute(this, receiver, property);
                }
                return ScriptBytecodeAdapter.getField(null, (Object)receiver, (String)property);
            }
        }.call(_receiver, _property.toString());
    }

    public static Object checkedSetAttribute(Object _receiver, Object _property, boolean safe, boolean spread, int op, Object _value) throws Throwable {
        if (op != 100) {
            Object v = Checker.checkedGetAttribute(_receiver, safe, spread, _property);
            return Checker.checkedSetAttribute(_receiver, _property, safe, spread, 100, Checker.checkedBinaryOp(v, Ops.compoundAssignmentToBinaryOperator(op), _value));
        }
        if (safe && _receiver == null) {
            return _value;
        }
        if (spread) {
            Iterator itr = InvokerHelper.asIterator((Object)_receiver);
            while (itr.hasNext()) {
                Object it = itr.next();
                if (it == null) continue;
                Checker.checkedSetAttribute(it, _property, true, false, op, _value);
            }
        } else {
            return new SingleArgInvokerChain(_receiver){

                @Override
                public Object call(Object receiver, String property, Object value) throws Throwable {
                    if (this.chain.hasNext()) {
                        return ((GroovyInterceptor)this.chain.next()).onSetAttribute(this, receiver, property, value);
                    }
                    ScriptBytecodeAdapter.setField((Object)value, null, (Object)receiver, (String)property);
                    return value;
                }
            }.call(_receiver, _property.toString(), _value);
        }
        return _value;
    }

    public static Object checkedGetArray(Object _receiver, Object _index) throws Throwable {
        return new SingleArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String method, Object index) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onGetArray(this, receiver, index);
                }
                return Checker.fakeCallSite("getAt").call(receiver, index);
            }
        }.call(_receiver, (String)null, _index);
    }

    public static Object checkedSetArray(Object _receiver, Object _index, int op, Object _value) throws Throwable {
        if (op != 100) {
            Object v = Checker.checkedGetArray(_receiver, _index);
            return Checker.checkedSetArray(_receiver, _index, 100, Checker.checkedBinaryOp(v, Ops.compoundAssignmentToBinaryOperator(op), _value));
        }
        return new TwoArgInvokerChain(_receiver){

            @Override
            public Object call(Object receiver, String method, Object index, Object value) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onSetArray(this, receiver, index, value);
                }
                Checker.fakeCallSite("putAt").call(receiver, index, value);
                return value;
            }
        }.call(_receiver, (String)null, _index, _value);
    }

    public static Object checkedPostfixArray(Object r, Object i, String op) throws Throwable {
        Object o = Checker.checkedGetArray(r, i);
        Object n = Checker.checkedCall(o, false, false, op, new Object[0]);
        Checker.checkedSetArray(r, i, 100, n);
        return o;
    }

    public static Object checkedPrefixArray(Object r, Object i, String op) throws Throwable {
        Object o = Checker.checkedGetArray(r, i);
        Object n = Checker.checkedCall(o, false, false, op, new Object[0]);
        Checker.checkedSetArray(r, i, 100, n);
        return n;
    }

    public static Object checkedPostfixProperty(Object receiver, Object property, boolean safe, boolean spread, String op) throws Throwable {
        Object o = Checker.checkedGetProperty(receiver, safe, spread, property);
        Object n = Checker.checkedCall(o, false, false, op, new Object[0]);
        Checker.checkedSetProperty(receiver, property, safe, spread, 100, n);
        return o;
    }

    public static Object checkedPrefixProperty(Object receiver, Object property, boolean safe, boolean spread, String op) throws Throwable {
        Object o = Checker.checkedGetProperty(receiver, safe, spread, property);
        Object n = Checker.checkedCall(o, false, false, op, new Object[0]);
        Checker.checkedSetProperty(receiver, property, safe, spread, 100, n);
        return n;
    }

    public static Object checkedPostfixAttribute(Object receiver, Object property, boolean safe, boolean spread, String op) throws Throwable {
        Object o = Checker.checkedGetAttribute(receiver, safe, spread, property);
        Object n = Checker.checkedCall(o, false, false, op, new Object[0]);
        Checker.checkedSetAttribute(receiver, property, safe, spread, 100, n);
        return o;
    }

    public static Object checkedPrefixAttribute(Object receiver, Object property, boolean safe, boolean spread, String op) throws Throwable {
        Object o = Checker.checkedGetAttribute(receiver, safe, spread, property);
        Object n = Checker.checkedCall(o, false, false, op, new Object[0]);
        Checker.checkedSetAttribute(receiver, property, safe, spread, 100, n);
        return n;
    }

    public static Object checkedBinaryOp(Object lhs, int op, Object rhs) throws Throwable {
        return Checker.checkedCall(lhs, false, false, Ops.binaryOperatorMethods(op), new Object[]{rhs});
    }

    public static Object checkedBitwiseNegate(Object value) throws Throwable {
        if (value instanceof Integer) {
            return ~((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (value instanceof BigInteger) {
            return Checker.checkedCall(value, false, false, "not", new Object[0]);
        }
        if (value instanceof String) {
            return Checker.checkedStaticCall(StringGroovyMethods.class, "bitwiseNegate", new Object[]{value.toString()});
        }
        if (value instanceof GString) {
            return Checker.checkedStaticCall(StringGroovyMethods.class, "bitwiseNegate", new Object[]{value.toString()});
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object element : (ArrayList)value) {
                newlist.add(Checker.checkedBitwiseNegate(element));
            }
            return newlist;
        }
        return Checker.checkedCall(value, false, false, "bitwiseNegate", EMPTY_ARRAY);
    }

    public static Object checkedCreateRange(Object from, Object to, boolean inclusive) throws Throwable {
        if (from instanceof Integer && to instanceof Integer && (inclusive || from != to)) {
            return Checker.checkedConstructor(IntRange.class, new Object[]{inclusive, from, to});
        }
        if (!inclusive) {
            if (Boolean.TRUE.equals(Checker.checkedComparison(from, 123, to))) {
                return Checker.checkedConstructor(EmptyRange.class, new Object[]{(Comparable)from});
            }
            to = Boolean.TRUE.equals(Checker.checkedComparison(from, 126, to)) ? Checker.checkedCall(to, false, false, "next", EMPTY_ARRAY) : Checker.checkedCall(to, false, false, "previous", EMPTY_ARRAY);
        }
        Checker.interceptRangeMethods((Comparable)from);
        Checker.interceptRangeMethods((Comparable)to);
        return new ObjectRange((Comparable)from, (Comparable)to);
    }

    private static void interceptRangeMethods(Comparable value) throws Throwable {
        if (value == null) {
            return;
        }
        for (String method : new String[]{"compareTo", "next", "previous"}) {
            Object[] args = new Object[]{};
            if (method.equals("compareTo")) {
                args = new Object[]{null};
            }
            new VarArgInvokerChain(value){

                @Override
                public Object call(Object receiver, String method, Object ... args) throws Throwable {
                    if (this.chain.hasNext()) {
                        return ((GroovyInterceptor)this.chain.next()).onMethodCall(this, receiver, method, args);
                    }
                    return null;
                }
            }.call((Object)value, method, args);
        }
    }

    public static Object checkedUnaryMinus(Object value) throws Throwable {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return -number.intValue();
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return -number.longValue();
        }
        if (value instanceof BigInteger) {
            return Checker.checkedCall(value, false, false, "negate", new Object[0]);
        }
        if (value instanceof BigDecimal) {
            return Checker.checkedCall(value, false, false, "negate", new Object[0]);
        }
        if (value instanceof Double) {
            Double number = (Double)value;
            return -number.doubleValue();
        }
        if (value instanceof Float) {
            Float number = (Float)value;
            return Float.valueOf(-number.floatValue());
        }
        if (value instanceof Short) {
            Short number = (Short)value;
            return -number.shortValue();
        }
        if (value instanceof Byte) {
            Byte number = (Byte)value;
            return -number.byteValue();
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object element : (ArrayList)value) {
                newlist.add(Checker.checkedUnaryMinus(element));
            }
            return newlist;
        }
        return Checker.checkedCall(value, false, false, "negative", EMPTY_ARRAY);
    }

    public static Object checkedUnaryPlus(Object value) throws Throwable {
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof BigDecimal || value instanceof Double || value instanceof Float || value instanceof Short || value instanceof Byte) {
            return value;
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object element : (ArrayList)value) {
                newlist.add(Checker.checkedUnaryPlus(element));
            }
            return newlist;
        }
        return Checker.checkedCall(value, false, false, "positive", EMPTY_ARRAY);
    }

    public static Object checkedComparison(Object lhs, final int op, Object rhs) throws Throwable {
        if (lhs == null) {
            return InvokerHelper.invokeStaticMethod(ScriptBytecodeAdapter.class, (String)Ops.binaryOperatorMethods(op), (Object)new Object[]{null, rhs});
        }
        return new SingleArgInvokerChain(lhs){

            @Override
            public Object call(Object lhs, String method, Object rhs) throws Throwable {
                if (this.chain.hasNext()) {
                    return ((GroovyInterceptor)this.chain.next()).onMethodCall(this, lhs, lhs instanceof Comparable ? "compareTo" : "equals", rhs);
                }
                return InvokerHelper.invokeStaticMethod(ScriptBytecodeAdapter.class, (String)Ops.binaryOperatorMethods(op), (Object)new Object[]{lhs, rhs});
            }
        }.call(lhs, (String)null, rhs);
    }

    public static Object checkedCast(Class<?> clazz, Object exp, boolean ignoreAutoboxing, boolean coerce, boolean strict) throws Throwable {
        return Checker.preCheckedCast(clazz, exp, ignoreAutoboxing, coerce, strict).call();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Thunk preCheckedCast(final Class<?> clazz, Object exp, boolean ignoreAutoboxing, boolean coerce, boolean strict) throws Throwable {
        if (exp == null || Collection.class.isAssignableFrom(clazz) && clazz.getPackage().getName().equals("java.util")) return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
        if (clazz.isAssignableFrom(exp.getClass())) {
            return () -> exp;
        }
        if (clazz.isInterface()) {
            for (Method m : clazz.getMethods()) {
                Object[] args = new Object[m.getParameterTypes().length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Checker.getDefaultValue(m.getParameterTypes()[i]);
                }
                new VarArgInvokerChain(exp){

                    @Override
                    public Object call(Object receiver, String method, Object ... args) throws Throwable {
                        if (this.chain.hasNext()) {
                            if (receiver instanceof Class) {
                                return ((GroovyInterceptor)this.chain.next()).onStaticCall(this, (Class)receiver, method, args);
                            }
                            return ((GroovyInterceptor)this.chain.next()).onMethodCall(this, receiver, method, args);
                        }
                        return null;
                    }
                }.call(exp, m.getName(), args);
            }
            return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
        } else if (Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isFinal(clazz.getModifiers()) && (exp instanceof Closure || exp instanceof Map)) {
            for (Constructor<?> c : clazz.getConstructors()) {
                Object[] args = new Object[c.getParameterTypes().length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Checker.getDefaultValue(c.getParameterTypes()[i]);
                }
                new VarArgInvokerChain(exp){

                    @Override
                    public Object call(Object receiver, String method, Object ... args) throws Throwable {
                        if (this.chain.hasNext()) {
                            return ((GroovyInterceptor)this.chain.next()).onNewInstance(this, clazz, args);
                        }
                        return null;
                    }
                }.call((Object)clazz, (String)null, args);
            }
            return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
        } else if ((clazz == Boolean.TYPE || clazz == Boolean.class) && exp.getClass() != Boolean.class) {
            new ZeroArgInvokerChain(exp){

                @Override
                public Object call(Object receiver, String method) throws Throwable {
                    if (this.chain.hasNext()) {
                        return ((GroovyInterceptor)this.chain.next()).onMethodCall(this, receiver, method, new Object[0]);
                    }
                    return null;
                }
            }.call(exp, "asBoolean");
            return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
        } else {
            if (Checker.unbox(clazz).isPrimitive() || clazz == String.class) return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
            if (!clazz.isArray() && clazz != Object.class && !Modifier.isAbstract(clazz.getModifiers()) && (exp instanceof Collection || exp.getClass().isArray() || exp instanceof Map)) {
                Object[] args = null;
                if (exp instanceof Collection) {
                    if (!Checker.isCollectionSafeToCast((Collection)exp)) throw new UnsupportedOperationException("Casting non-standard Collections to a type via constructor is not supported. Consider converting " + exp.getClass() + " to a Collection defined in the java.util package and then casting to " + clazz + ".");
                    args = ((Collection)exp).toArray();
                } else {
                    if (!(exp instanceof Map)) throw new UnsupportedOperationException("casting arrays to types via constructor is not yet supported");
                    args = new Object[]{exp};
                }
                if (args == null) throw new IllegalStateException(exp.getClass() + ".toArray() must not return null");
                new VarArgInvokerChain(clazz){

                    @Override
                    public Object call(Object receiver, String method, Object ... args) throws Throwable {
                        if (this.chain.hasNext()) {
                            return ((GroovyInterceptor)this.chain.next()).onNewInstance(this, (Class)receiver, args);
                        }
                        return null;
                    }
                }.call((Object)clazz, (String)null, args);
                return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
            } else if (clazz.isArray() && !clazz.getComponentType().isPrimitive() && (exp instanceof Collection || exp instanceof Object[])) {
                Object[] array;
                if (exp instanceof Collection) {
                    if (!Checker.isCollectionSafeToCast((Collection)exp)) throw new UnsupportedOperationException("Casting non-standard implementations of Collection to an array is not supported. Consider converting " + exp.getClass() + " to a Collection defined in the java.util package and then casting to " + clazz + ".");
                    array = ((Collection)exp).toArray();
                } else {
                    array = (Object[])exp;
                }
                for (Object element : array) {
                    Checker.preCheckedCast(clazz.getComponentType(), element, coerce, strict, ignoreAutoboxing);
                }
                return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
            } else if (clazz == File.class && exp instanceof CharSequence) {
                Object[] args = new Object[]{exp.toString()};
                new VarArgInvokerChain(clazz){

                    @Override
                    public Object call(Object receiver, String method, Object ... args) throws Throwable {
                        if (this.chain.hasNext()) {
                            return ((GroovyInterceptor)this.chain.next()).onNewInstance(this, (Class)receiver, args);
                        }
                        return null;
                    }
                }.call((Object)clazz, (String)null, args);
                return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
            } else if (exp instanceof File && (clazz.isArray() || Collection.class.isAssignableFrom(clazz))) {
                new VarArgInvokerChain(clazz){

                    @Override
                    public Object call(Object receiver, String method, Object ... args) throws Throwable {
                        if (this.chain.hasNext() && receiver instanceof Class) {
                            return ((GroovyInterceptor)this.chain.next()).onStaticCall(this, (Class)receiver, method, args);
                        }
                        return null;
                    }
                }.call((Object)ResourceGroovyMethods.class, "readLines", exp);
                return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
            } else {
                if (!(exp instanceof Class) || !((Class)exp).isEnum() || !clazz.isArray() && !Collection.class.isAssignableFrom(clazz)) return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
                for (Field f : ((Class)exp).getFields()) {
                    if (!f.isEnumConstant()) continue;
                    new ZeroArgInvokerChain(exp){

                        @Override
                        public Object call(Object receiver, String field) throws Throwable {
                            if (this.chain.hasNext() && receiver instanceof Class) {
                                return ((GroovyInterceptor)this.chain.next()).onGetProperty(this, receiver, field);
                            }
                            return null;
                        }
                    }.call(exp, f.getName());
                }
            }
        }
        return () -> strict ? clazz.cast(exp) : (coerce ? ScriptBytecodeAdapter.asType((Object)exp, (Class)clazz) : ScriptBytecodeAdapter.castToType((Object)exp, (Class)clazz));
    }

    private static <T> T getDefaultValue(Class<T> clazz) {
        return (T)Array.get(Array.newInstance(clazz, 1), 0);
    }

    private static Object[] fixNull(Object[] args) {
        return args == null ? new Object[1] : args;
    }

    private static boolean isCollectionSafeToCast(Collection c) {
        Package p = c.getClass().getPackage();
        String packageName = null;
        if (p != null) {
            packageName = p.getName();
        }
        return "java.util".equals(packageName);
    }

    private static Thunk findCheckedReplacement(Class<?> clazz, String method, Object[] args) {
        Method maybeReplacement = GROOVY_RUNTIME_REPLACEMENTS.get(new AbstractMap.SimpleImmutableEntry(clazz, method));
        if (maybeReplacement == null) {
            return null;
        }
        ParameterTypes parameterTypes = new ParameterTypes((Class[])maybeReplacement.getParameterTypes());
        if (!parameterTypes.isValidExactMethod(args)) {
            return null;
        }
        return () -> {
            try {
                return maybeReplacement.invoke(null, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        };
    }

    private static void addReplacement(Class<?> clazz, String name, String checkedName, Class<?> ... parameterTypes) {
        try {
            GROOVY_RUNTIME_REPLACEMENTS.put(new AbstractMap.SimpleImmutableEntry(clazz, name), Checker.class.getDeclaredMethod(checkedName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<?> unbox(Class<?> clazz) {
        return BOX_TO_PRIMITIVE.getOrDefault(clazz, clazz);
    }

    static {
        Checker.addReplacement(InvokerHelper.class, "bitwiseNegate", "checkedBitwiseNegate", Object.class);
        Checker.addReplacement(InvokerHelper.class, "unaryMinus", "checkedUnaryMinus", Object.class);
        Checker.addReplacement(InvokerHelper.class, "unaryPlus", "checkedUnaryPlus", Object.class);
        Checker.addReplacement(ScriptBytecodeAdapter.class, "bitwiseNegate", "checkedBitwiseNegate", Object.class);
        Checker.addReplacement(ScriptBytecodeAdapter.class, "unaryMinus", "checkedUnaryMinus", Object.class);
        Checker.addReplacement(ScriptBytecodeAdapter.class, "unaryPlus", "checkedUnaryPlus", Object.class);
        Checker.addReplacement(ScriptBytecodeAdapter.class, "createRange", "checkedCreateRange", Object.class, Object.class, Boolean.TYPE);
        BOX_TO_PRIMITIVE = new HashMap();
        BOX_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        BOX_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        BOX_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        BOX_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        BOX_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        BOX_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        BOX_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        BOX_TO_PRIMITIVE.put(Short.class, Short.TYPE);
    }

    @FunctionalInterface
    public static interface Thunk {
        public Object call() throws Throwable;
    }

    public static class ThisConstructorWrapper {
        private final Object[] args;

        ThisConstructorWrapper(Object[] args) {
            this.args = args;
        }

        public Object arg(int idx) {
            return this.args[idx];
        }
    }

    public static class SuperConstructorWrapper {
        private final Object[] args;

        SuperConstructorWrapper(Object[] args) {
            this.args = args;
        }

        public Object arg(int idx) {
            return this.args[idx];
        }
    }
}

