/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHArtifact;
import org.kohsuke.github.GHArtifactsIterable;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowJobQueryBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.function.InputStreamFunction;
import org.kohsuke.github.internal.EnumUtils;

public class GHWorkflowRun
extends GHObject {
    private GHUser actor;
    private String artifactsUrl;
    private String cancelUrl;
    private String checkSuiteUrl;
    private String conclusion;
    private String displayTitle;
    private String event;
    private String headBranch;
    private HeadCommit headCommit;
    private GHRepository headRepository;
    private String headSha;
    private String htmlUrl;
    private String jobsUrl;
    private String logsUrl;
    private String name;
    @JsonProperty(value="repository")
    private GHRepository owner;
    private GHPullRequest[] pullRequests;
    private String rerunUrl;
    private long runAttempt;
    private long runNumber;
    private String runStartedAt;
    private String status;
    private GHUser triggeringActor;
    private long workflowId;
    private String workflowUrl;

    public void approve() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiRoute(), "approve")).send();
    }

    public void cancel() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiRoute(), "cancel")).send();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public void deleteLogs() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), "logs")).send();
    }

    public <T> T downloadLogs(InputStreamFunction<T> streamFunction) throws IOException {
        Objects.requireNonNull(streamFunction, "Stream function must not be null");
        return ((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiRoute(), "logs")).fetchStream(streamFunction);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getActor() {
        return this.actor;
    }

    public URL getArtifactsUrl() {
        return GitHubClient.parseURL(this.artifactsUrl);
    }

    public URL getCancelUrl() {
        return GitHubClient.parseURL(this.cancelUrl);
    }

    public URL getCheckSuiteUrl() {
        return GitHubClient.parseURL(this.checkSuiteUrl);
    }

    public Conclusion getConclusion() {
        return Conclusion.from(this.conclusion);
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public GHEvent getEvent() {
        return EnumUtils.getNullableEnumOrDefault(GHEvent.class, this.event, GHEvent.UNKNOWN);
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public HeadCommit getHeadCommit() {
        return this.headCommit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getHeadRepository() {
        return this.headRepository;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public URL getJobsUrl() {
        return GitHubClient.parseURL(this.jobsUrl);
    }

    public URL getLogsUrl() {
        return GitHubClient.parseURL(this.logsUrl);
    }

    public String getName() {
        return this.name;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        if (this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest pullRequest : this.pullRequests) {
                pullRequest.refresh(pullRequest.getTitle());
            }
            return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
        }
        return Collections.emptyList();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getRepository() {
        return this.owner;
    }

    public URL getRerunUrl() {
        return GitHubClient.parseURL(this.rerunUrl);
    }

    public long getRunAttempt() {
        return this.runAttempt;
    }

    public long getRunNumber() {
        return this.runNumber;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getRunStartedAt() {
        return GitHubClient.parseInstant(this.runStartedAt);
    }

    public Status getStatus() {
        return Status.from(this.status);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getTriggeringActor() {
        return this.triggeringActor;
    }

    public long getWorkflowId() {
        return this.workflowId;
    }

    public URL getWorkflowUrl() {
        return GitHubClient.parseURL(this.workflowUrl);
    }

    public PagedIterable<GHWorkflowJob> listAllJobs() {
        return new GHWorkflowJobQueryBuilder(this).all().list();
    }

    public PagedIterable<GHArtifact> listArtifacts() {
        return new GHArtifactsIterable(this.owner, (GitHubRequest.Builder<?>)this.root().createRequest().withUrlPath(this.getApiRoute(), "artifacts"));
    }

    public PagedIterable<GHWorkflowJob> listJobs() {
        return new GHWorkflowJobQueryBuilder(this).latest().list();
    }

    public void rerun() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiRoute(), "rerun")).send();
    }

    private String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/actions/runs/" + this.getId();
    }

    GHWorkflowRun wrapUp(GHRepository owner) {
        this.owner = owner;
        return this.wrapUp(owner.root());
    }

    GHWorkflowRun wrapUp(GitHub root) {
        if (this.owner != null && this.pullRequests != null) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(this.owner);
            }
        }
        return this;
    }

    public static enum Conclusion {
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SKIPPED,
        STALE,
        STARTUP_FAILURE,
        SUCCESS,
        TIMED_OUT,
        UNKNOWN;


        public static Conclusion from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Conclusion.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class HeadCommit
    extends GitHubBridgeAdapterObject {
        private GitUser author;
        private GitUser committer;
        private String id;
        private String message;
        private String timestamp;
        private String treeId;

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getTimestamp() {
            return GitHubClient.parseInstant(this.timestamp);
        }

        public String getTreeId() {
            return this.treeId;
        }
    }

    public static enum Status {
        ACTION_REQUIRED,
        CANCELLED,
        COMPLETED,
        FAILURE,
        IN_PROGRESS,
        NEUTRAL,
        PENDING,
        QUEUED,
        REQUESTED,
        SKIPPED,
        STALE,
        SUCCESS,
        TIMED_OUT,
        UNKNOWN,
        WAITING;


        public static Status from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Status.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

