/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.kohsuke.github.GHDeploymentState;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHDeploymentStatusBuilder;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHDeployment
extends GHObject {
    private GHRepository owner;
    protected GHUser creator;
    protected String description;
    protected String environment;
    protected String originalEnvironment;
    protected Object payload;
    protected boolean productionEnvironment;
    protected String ref;
    protected String repositoryUrl;
    protected String sha;
    protected String statusesUrl;
    protected String task;
    protected boolean transientEnvironment;

    public GHDeploymentStatusBuilder createStatus(GHDeploymentState state) {
        return new GHDeploymentStatusBuilder(this.owner, this.getId(), state);
    }

    public GHUser getCreator() {
        return this.root().intern(this.creator);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getOriginalEnvironment() {
        return this.originalEnvironment;
    }

    public String getPayload() {
        return (String)this.payload;
    }

    public Map<String, Object> getPayloadMap() {
        return Collections.unmodifiableMap((Map)this.payload);
    }

    public Object getPayloadObject() {
        return this.payload;
    }

    public String getRef() {
        return this.ref;
    }

    public URL getRepositoryUrl() {
        return GitHubClient.parseURL(this.repositoryUrl);
    }

    public String getSha() {
        return this.sha;
    }

    public URL getStatusesUrl() {
        return GitHubClient.parseURL(this.statusesUrl);
    }

    public String getTask() {
        return this.task;
    }

    public boolean isProductionEnvironment() {
        return this.productionEnvironment;
    }

    public boolean isTransientEnvironment() {
        return this.transientEnvironment;
    }

    public PagedIterable<GHDeploymentStatus> listStatuses() {
        return ((Requester)this.root().createRequest().withUrlPath(this.statusesUrl, new String[0])).toIterable(GHDeploymentStatus[].class, item -> item.lateBind(this.owner));
    }

    GHRepository getOwner() {
        return this.owner;
    }

    GHDeployment wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }
}

