/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.accmod.impl;

import java.util.HashMap;
import java.util.Map;
import org.kohsuke.accmod.AccessRestriction;
import org.objectweb.asm.Type;

public class AccessRestrictionFactory {
    private final Map<String, AccessRestriction> instances = new HashMap<String, AccessRestriction>();
    private final ClassLoader cl;

    public AccessRestrictionFactory(ClassLoader cl) {
        this.cl = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessRestriction get(Type type) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String className = type.getClassName();
        AccessRestriction a = this.instances.get(className);
        if (a != null) {
            return a;
        }
        a = AccessRestriction.NONE;
        try {
            Class<?> c = this.cl.loadClass(className);
            AccessRestriction accessRestriction = a = (AccessRestriction)c.newInstance();
            return accessRestriction;
        }
        finally {
            this.instances.put(className, a);
        }
    }
}

