/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.xml.bind.model.concrete;

import com.sun.xml.bind.v2.model.core.ClassInfo;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.Validate;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.ClassInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.PropertyInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MClassInfoOrigin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMClassInfo<T, C extends T>
implements MClassInfo<T, C> {
    private final MClassInfoOrigin origin;
    private final C targetClass;
    private final MPackageInfo _package;
    private final String name;
    private final String localName;
    private final MClassInfo<T, C> baseTypeInfo;
    private final QName elementName;
    private List<MPropertyInfo<T, C>> properties = new ArrayList<MPropertyInfo<T, C>>();
    private List<MPropertyInfo<T, C>> unmodifiableProperties = Collections.unmodifiableList(this.properties);

    public CMClassInfo(MClassInfoOrigin origin, C targetClass, MPackageInfo _package, String localName, MClassInfo<T, C> baseTypeInfo, QName elementName) {
        Validate.notNull(origin);
        Validate.notNull(targetClass);
        Validate.notNull(_package);
        Validate.notNull(localName);
        this.origin = origin;
        this.targetClass = targetClass;
        this.name = _package.getPackagedName(localName);
        this.localName = localName;
        this._package = _package;
        this.baseTypeInfo = baseTypeInfo;
        this.elementName = elementName;
    }

    @Override
    public MClassInfoOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public C getTargetClass() {
        return this.targetClass;
    }

    @Override
    public T getTargetType() {
        return (T)this.targetClass;
    }

    @Override
    public MElementInfo<T, C> createElementInfo(MTypeInfo<T, C> scope, QName substitutionHead) {
        return new CMElementInfo<T, C>(this.getOrigin().createElementInfoOrigin(), this.getPackageInfo(), this.getElementName(), scope, this, substitutionHead);
    }

    @Override
    public MPackageInfo getPackageInfo() {
        return this._package;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public MClassInfo<T, C> getBaseTypeInfo() {
        return this.baseTypeInfo;
    }

    @Override
    public List<MPropertyInfo<T, C>> getProperties() {
        return this.unmodifiableProperties;
    }

    @Override
    public QName getElementName() {
        return this.elementName;
    }

    @Override
    public void addProperty(MPropertyInfo<T, C> propertyInfo) {
        Validate.notNull(propertyInfo);
        this.properties.add(propertyInfo);
    }

    @Override
    public void removeProperty(MPropertyInfo<T, C> propertyInfo) {
        Validate.notNull(propertyInfo);
        this.properties.remove(propertyInfo);
        if (this.getOrigin() instanceof ClassInfoOrigin && propertyInfo.getOrigin() instanceof PropertyInfoOrigin) {
            ClassInfo ci = (ClassInfo)((ClassInfoOrigin)((Object)this.getOrigin())).getSource();
            PropertyInfo pi = (PropertyInfo)((PropertyInfoOrigin)propertyInfo.getOrigin()).getSource();
            ci.getProperties().remove(pi);
        }
    }

    public String toString() {
        return "ClassInfo [" + this.getName() + "]";
    }

    @Override
    public <V> V acceptTypeInfoVisitor(MTypeInfoVisitor<T, C, V> visitor) {
        return visitor.visitClassInfo(this);
    }
}

