/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ModuleUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class PackageUtils {
    public static final String DEFAULT_PACKAGE_NAME = "";

    private PackageUtils() {
    }

    public static Optional<String> getAttribute(Class<?> type, Function<Package, String> function) {
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notNull(function, "function must not be null");
        return Optional.ofNullable(type.getPackage()).map(function);
    }

    public static Optional<String> getAttribute(Class<?> type, String name) {
        Optional<String> optional;
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notBlank(name, "name must not be blank");
        URL jarUrl = type.getProtectionDomain().getCodeSource().getLocation();
        JarFile jarFile = new JarFile(new File(jarUrl.toURI()));
        try {
            Attributes mainAttributes = jarFile.getManifest().getMainAttributes();
            optional = Optional.ofNullable(mainAttributes.getValue(name));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static Optional<String> getModuleOrImplementationVersion(Class<?> type) {
        Optional<String> moduleVersion = ModuleUtils.getModuleVersion(type);
        if (moduleVersion.isPresent()) {
            return moduleVersion;
        }
        return PackageUtils.getAttribute(type, Package::getImplementationVersion);
    }
}

