/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apiguardian.api.API;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="1.13.3")
public class KotlinReflectionUtils {
    private static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    private static final Class<? extends Annotation> kotlinMetadata;

    private static Try<Class<? extends Annotation>> tryToLoadKotlinMetadataClass() {
        return ReflectionUtils.tryToLoadClass("kotlin.Metadata").andThenTry(it -> it);
    }

    public static boolean isKotlinInterfaceDefaultImplsClass(Class<?> clazz) {
        if (!(KotlinReflectionUtils.isKotlinType(clazz) && DEFAULT_IMPLS_CLASS_NAME.equals(clazz.getSimpleName()) && ReflectionUtils.isStatic(clazz))) {
            return false;
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null && enclosingClass.isInterface()) {
            return Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> KotlinReflectionUtils.isCompilerGeneratedDefaultMethod(method, enclosingClass));
        }
        return false;
    }

    private static boolean isCompilerGeneratedDefaultMethod(Method method, Class<?> enclosingClass) {
        Class<?>[] parameterTypes;
        if (ReflectionUtils.isStatic(method) && method.getParameterCount() > 0 && (parameterTypes = method.getParameterTypes())[0] == enclosingClass) {
            Class<?>[] originalParameterTypes = KotlinReflectionUtils.copyWithoutFirst(parameterTypes);
            return ReflectionUtils.findMethod(enclosingClass, method.getName(), originalParameterTypes).isPresent();
        }
        return false;
    }

    private static Class<?>[] copyWithoutFirst(Class<?>[] values) {
        if (values.length == 1) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[values.length - 1];
        System.arraycopy(values, 1, result, 0, result.length);
        return result;
    }

    private static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    static {
        Try<Class<? extends Annotation>> metadata = KotlinReflectionUtils.tryToLoadKotlinMetadataClass();
        kotlinMetadata = metadata.toOptional().orElse(null);
    }
}

