/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.writer;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.writer.Writable;

class FastBufferedWriter
extends FilterWriter
implements Writable {
    private final char[] buf;
    private int pos;

    FastBufferedWriter(Writer writer, int bufferSize) {
        super(writer);
        this.buf = new char[bufferSize];
    }

    @Override
    public void write(int c) throws IOException {
        if (this.pos == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.pos++] = (char)c;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.pos + len >= this.buf.length) {
            this.flushBuffer();
            if (len >= this.buf.length) {
                this.out.write(cbuf, off, len);
                return;
            }
        }
        System.arraycopy(cbuf, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.pos + len >= this.buf.length) {
            this.flushBuffer();
            if (len >= this.buf.length) {
                this.out.write(str, off, len);
                return;
            }
        }
        str.getChars(off, off + len, this.buf, this.pos);
        this.pos += len;
    }

    @Override
    public void endRecord() throws IOException {
    }

    private void flushBuffer() throws IOException {
        this.out.write(this.buf, 0, this.pos);
        this.pos = 0;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        super.close();
    }
}

