/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsUtils;
import org.junit.jupiter.params.provider.FieldSource;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class FieldArgumentsProvider
extends AnnotationBasedArgumentsProvider<FieldSource> {
    FieldArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, FieldSource fieldSource) {
        Class testClass = context.getRequiredTestClass();
        Object testInstance = context.getTestInstance().orElse(null);
        String[] fieldNames = fieldSource.value();
        if (fieldNames.length == 0) {
            Optional testMethod = context.getTestMethod();
            Preconditions.condition((boolean)testMethod.isPresent(), (String)"You must specify a field name when using @FieldSource with @ParameterizedClass");
            fieldNames = new String[]{((Method)testMethod.get()).getName()};
        }
        return Arrays.stream(fieldNames).map(fieldName -> FieldArgumentsProvider.findField(testClass, fieldName)).map(field -> FieldArgumentsProvider.validateField(field, testInstance)).map(field -> FieldArgumentsProvider.readField(field, testInstance)).flatMap(fieldValue -> {
            if (fieldValue instanceof Supplier) {
                Supplier supplier = (Supplier)fieldValue;
                fieldValue = supplier.get();
            }
            return CollectionUtils.toStream((Object)fieldValue);
        }).map(ArgumentsUtils::toArguments);
    }

    static Field findField(Class<?> testClass, String fieldName) {
        Preconditions.notBlank((String)fieldName, (String)"Field name must not be blank");
        fieldName = fieldName.strip();
        Class clazz = testClass;
        if (fieldName.contains("#") || fieldName.contains(".")) {
            String[] fieldParts = ReflectionUtils.parseFullyQualifiedFieldName((String)fieldName);
            String className = fieldParts[0];
            fieldName = fieldParts[1];
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(testClass);
            clazz = ReflectionUtils.loadRequiredClass((String)className, (ClassLoader)classLoader);
        }
        Class resolvedClass = clazz;
        String resolvedFieldName = fieldName;
        Predicate<Field> nameMatches = field -> field.getName().equals(resolvedFieldName);
        Field field2 = ReflectionUtils.streamFields(resolvedClass, nameMatches, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP).findFirst().orElse(null);
        return (Field)Preconditions.notNull((Object)field2, () -> "Could not find field named [%s] in class [%s]".formatted(resolvedFieldName, resolvedClass.getName()));
    }

    private static Field validateField(Field field, @Nullable Object testInstance) {
        Preconditions.condition((field.getDeclaringClass().isInstance(testInstance) || ModifierSupport.isStatic((Member)field) ? 1 : 0) != 0, () -> "Field '%s' must be static: local @FieldSource fields must be static unless the PER_CLASS @TestInstance lifecycle mode is used; external @FieldSource fields must always be static.".formatted(field.toGenericString()));
        return field;
    }

    private static Object readField(Field field, @Nullable Object testInstance) {
        Object value = ReflectionSupport.tryToReadFieldValue((Field)field, (Object)testInstance).getOrThrow(cause -> new JUnitException("Could not read field [%s]".formatted(field.getName()), (Throwable)cause));
        String fieldName = field.getName();
        String declaringClass = field.getDeclaringClass().getName();
        Preconditions.notNull((Object)value, () -> "The value of field [%s] in class [%s] must not be null".formatted(fieldName, declaringClass));
        Preconditions.condition((!(value instanceof BaseStream) ? 1 : 0) != 0, () -> "The value of field [%s] in class [%s] must not be a stream".formatted(fieldName, declaringClass));
        Preconditions.condition((!(value instanceof Iterator) ? 1 : 0) != 0, () -> "The value of field [%s] in class [%s] must not be an Iterator".formatted(fieldName, declaringClass));
        Preconditions.condition((boolean)FieldArgumentsProvider.isConvertibleToStream(field, value), () -> "The value of field [%s] in class [%s] must be convertible to a Stream".formatted(fieldName, declaringClass));
        return value;
    }

    private static boolean isConvertibleToStream(Field field, Object value) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type genericType;
        if (CollectionUtils.isConvertibleToStream(value.getClass())) {
            return true;
        }
        if (Supplier.class.isAssignableFrom(field.getType()) && (genericType = field.getGenericType()) instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            ParameterizedType innerParameterizedType;
            Type rawType;
            Type type = typeArguments[0];
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return CollectionUtils.isConvertibleToStream((Class)clazz);
            }
            if (type instanceof ParameterizedType && (rawType = (innerParameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
                Class clazz = (Class)rawType;
                return CollectionUtils.isConvertibleToStream((Class)clazz);
            }
        }
        return false;
    }
}

