/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.annotation.Contract;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.TestAbortedException;

@API(status=API.Status.STABLE, since="5.0")
public class Assumptions {
    protected Assumptions() {
    }

    @Contract(value="false -> fail")
    public static void assumeTrue(boolean assumption) throws TestAbortedException {
        Assumptions.assumeTrue(assumption, "assumption is not true");
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier.getAsBoolean(), "assumption is not true");
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier, @Nullable String message) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier.getAsBoolean(), message);
    }

    @Contract(value="false, _ -> fail")
    public static void assumeTrue(boolean assumption, Supplier<@Nullable String> messageSupplier) throws TestAbortedException {
        if (!assumption) {
            Assumptions.throwAssumptionFailed(messageSupplier.get());
        }
    }

    @Contract(value="false, _ -> fail")
    public static void assumeTrue(boolean assumption, @Nullable String message) throws TestAbortedException {
        if (!assumption) {
            Assumptions.throwAssumptionFailed(message);
        }
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier, Supplier<@Nullable String> messageSupplier) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier.getAsBoolean(), messageSupplier);
    }

    @Contract(value="true -> fail")
    public static void assumeFalse(boolean assumption) throws TestAbortedException {
        Assumptions.assumeFalse(assumption, "assumption is not false");
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier.getAsBoolean(), "assumption is not false");
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier, @Nullable String message) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier.getAsBoolean(), message);
    }

    @Contract(value="true, _ -> fail")
    public static void assumeFalse(boolean assumption, Supplier<@Nullable String> messageSupplier) throws TestAbortedException {
        if (assumption) {
            Assumptions.throwAssumptionFailed(messageSupplier.get());
        }
    }

    @Contract(value="true, _ -> fail")
    public static void assumeFalse(boolean assumption, @Nullable String message) throws TestAbortedException {
        if (assumption) {
            Assumptions.throwAssumptionFailed(message);
        }
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier, Supplier<@Nullable String> messageSupplier) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier.getAsBoolean(), messageSupplier);
    }

    public static void assumingThat(BooleanSupplier assumptionSupplier, Executable executable) {
        Assumptions.assumingThat(assumptionSupplier.getAsBoolean(), executable);
    }

    public static void assumingThat(boolean assumption, Executable executable) {
        if (assumption) {
            try {
                executable.execute();
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        }
    }

    @API(status=API.Status.STABLE, since="5.9")
    @Contract(value=" -> fail")
    public static <V> V abort() {
        throw new TestAbortedException();
    }

    @API(status=API.Status.STABLE, since="5.9")
    @Contract(value="_ -> fail")
    public static <V> V abort(String message) {
        throw new TestAbortedException(message);
    }

    @API(status=API.Status.STABLE, since="5.9")
    @Contract(value="_ -> fail")
    public static <V> V abort(Supplier<String> messageSupplier) {
        throw new TestAbortedException(messageSupplier.get());
    }

    @Contract(value="_ -> fail")
    private static void throwAssumptionFailed(@Nullable String message) {
        throw new TestAbortedException((String)(StringUtils.isNotBlank((String)message) ? "Assumption failed: " + message : "Assumption failed"));
    }
}

