/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.management;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jsr107.ri.RICache;

public final class MBeanServerRegistrationUtility {
    private static MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MBeanServerRegistrationUtility() {
    }

    public static void registerCacheObject(RICache cache, ObjectNameType objectNameType) {
        ObjectName registeredObjectName = MBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        try {
            if (objectNameType.equals((Object)ObjectNameType.Configuration)) {
                if (!MBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                    mBeanServer.registerMBean(cache.getCacheMXBean(), registeredObjectName);
                }
            } else if (objectNameType.equals((Object)ObjectNameType.Statistics) && !MBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                mBeanServer.registerMBean(cache.getCacheStatisticsMXBean(), registeredObjectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Error registering cache MXBeans for CacheManager " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    static boolean isRegistered(RICache cache, ObjectNameType objectNameType) {
        Set<ObjectName> registeredObjectNames = null;
        ObjectName objectName = MBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        registeredObjectNames = mBeanServer.queryNames(objectName, null);
        return !registeredObjectNames.isEmpty();
    }

    public static void unregisterCacheObject(RICache cache, ObjectNameType objectNameType) {
        Set<ObjectName> registeredObjectNames = null;
        ObjectName objectName = MBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        registeredObjectNames = mBeanServer.queryNames(objectName, null);
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static ObjectName calculateObjectName(Cache cache, ObjectNameType objectNameType) {
        String cacheManagerName = MBeanServerRegistrationUtility.mbeanSafe(cache.getCacheManager().getURI().toString());
        String cacheName = MBeanServerRegistrationUtility.mbeanSafe(cache.getName());
        try {
            return new ObjectName("javax.cache:type=Cache" + (Object)((Object)objectNameType) + ",CacheManager=" + cacheManagerName + ",Cache=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerName + "], Cache=[" + cacheName + "]", (Throwable)e);
        }
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(",|:|=|\n", ".");
    }

    public static enum ObjectNameType {
        Statistics,
        Configuration;

    }
}

