/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import jodd.mail.MailException;
import jodd.mail.MailServer;
import jodd.mail.SendMailSession;

public class SmtpServer
extends MailServer<SendMailSession> {
    protected static final String PROTOCOL_SMTP = "smtp";
    protected static final int DEFAULT_SMTP_PORT = 25;

    public SmtpServer(MailServer.Builder builder) {
        super(builder, 25);
    }

    protected SmtpServer(MailServer.Builder builder, int defaultPort) {
        super(builder, defaultPort);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty("mail.transport.protocol", PROTOCOL_SMTP);
        props.setProperty("mail.host", this.host);
        props.setProperty("mail.smtp.host", this.host);
        props.setProperty("mail.smtp.port", String.valueOf(this.port));
        if (this.authenticator != null) {
            props.setProperty("mail.smtp.auth", "true");
        }
        if (this.timeout > 0) {
            String timeoutValue = String.valueOf(this.timeout);
            props.put("mail.smtp.connectiontimeout", timeoutValue);
            props.put("mail.smtp.timeout", timeoutValue);
            props.put("mail.smtp.writetimeout", timeoutValue);
        }
        return props;
    }

    @Override
    public SendMailSession createSession() {
        Transport mailTransport;
        Session session = Session.getInstance((Properties)this.createSessionProperties(), (Authenticator)this.authenticator);
        try {
            mailTransport = this.getTransport(session);
        }
        catch (NoSuchProviderException nspex) {
            throw new MailException(nspex);
        }
        return new SendMailSession(session, mailTransport);
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(PROTOCOL_SMTP);
    }
}

