/*
 * Decompiled with CFR 0.152.
 */
package jodd.crypt;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import jodd.util.StringUtil;

public class PBKDF2Hash {
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA512";
    private final int saltBytes;
    private final int hashBytes;
    private final int pbkdf2Iterations;
    public static final int ITERATION_INDEX = 0;
    public static final int SALT_INDEX = 1;
    public static final int PBKDF2_INDEX = 2;

    public PBKDF2Hash() {
        this(24, 24, 1000);
    }

    public PBKDF2Hash(int saltBytes, int hashBytes, int iterations) {
        this.saltBytes = saltBytes;
        this.hashBytes = hashBytes;
        this.pbkdf2Iterations = iterations;
    }

    public String createHash(String password) {
        return this.createHash(password.toCharArray());
    }

    public String createHash(char[] password) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[this.saltBytes];
        random.nextBytes(salt);
        byte[] hash = PBKDF2Hash.pbkdf2(password, salt, this.pbkdf2Iterations, this.hashBytes);
        return this.pbkdf2Iterations + ":" + StringUtil.toHexString(salt) + ":" + StringUtil.toHexString(hash);
    }

    public boolean validatePassword(String password, String goodHash) {
        return this.validatePassword(password.toCharArray(), goodHash);
    }

    public boolean validatePassword(char[] password, String goodHash) {
        String[] params = goodHash.split(":");
        int iterations = Integer.parseInt(params[0]);
        byte[] salt = PBKDF2Hash.fromHex(params[1]);
        byte[] hash = PBKDF2Hash.fromHex(params[2]);
        byte[] testHash = PBKDF2Hash.pbkdf2(password, salt, iterations, hash.length);
        return PBKDF2Hash.slowEquals(hash, testHash);
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    private static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int bytes) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, bytes * 8);
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException ignore) {
            return null;
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }
}

