/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class TypeCache<T> {
    private final Map<Class<?>, T> map;

    public static <A> TypeCache<A> create(Implementation implementation) {
        return new TypeCache(implementation);
    }

    public TypeCache(Implementation typeCacheImplementation) {
        this.map = typeCacheImplementation.createMap();
    }

    public T get(Class<?> key) {
        return this.map.get(key);
    }

    public T getOrDefault(Class<?> key, T defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    public T put(Class<?> key, T value) {
        return this.map.put(key, value);
    }

    public T remove(Class<?> type) {
        return this.map.remove(type);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public boolean containsKey(Class type) {
        return this.map.containsKey(type);
    }

    public static enum Implementation {
        MAP(false, false),
        SYNC_MAP(false, true),
        WEAK(true, false),
        SYNC_WEAK(true, true);

        private final boolean sync;
        private final boolean weak;

        private Implementation(boolean weak, boolean sync) {
            this.weak = weak;
            this.sync = sync;
        }

        public <A> Map<Class<?>, A> createMap() {
            if (this.weak) {
                if (this.sync) {
                    return Collections.synchronizedMap(new WeakHashMap());
                }
                return new WeakHashMap();
            }
            if (this.sync) {
                return new ConcurrentHashMap();
            }
            return new HashMap();
        }
    }
}

