/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.ddd.types;

import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Identifiable;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.SimpleAssociation;

public interface Association<T extends AggregateRoot<T, ID>, ID extends Identifier>
extends Identifiable<ID> {
    public static <T extends AggregateRoot<T, ID>, ID extends Identifier> Association<T, ID> forAggregate(T aggregate) {
        if (aggregate == null) {
            throw new IllegalArgumentException("Aggregate must not be null!");
        }
        return new SimpleAssociation(() -> (Identifier)aggregate.getId());
    }

    public static <T extends AggregateRoot<T, ID>, ID extends Identifier> Association<T, ID> forId(ID identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier must not be null!");
        }
        return new SimpleAssociation(() -> identifier);
    }

    default public boolean pointsToSameAggregateAs(Association<?, ID> other) {
        if (other == null) {
            throw new IllegalArgumentException("Other association must not be null!");
        }
        return ((Identifier)this.getId()).equals(other.getId());
    }

    default public boolean pointsTo(ID identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier must not be null!");
        }
        return ((Identifier)this.getId()).equals(identifier);
    }

    default public boolean pointsTo(T aggregate) {
        if (aggregate == null) {
            throw new IllegalArgumentException("Aggregate must not be null!");
        }
        return this.pointsTo((T)((Identifier)aggregate.getId()));
    }
}

