/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.ext.CSVFormat;
import org.jgrapht.ext.ComponentNameProvider;
import org.jgrapht.ext.DSVUtils;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.IntegerComponentNameProvider;

@Deprecated
public class CSVExporter<V, E>
implements GraphExporter<V, E> {
    private static final char DEFAULT_DELIMITER = ',';
    private final ComponentNameProvider<V> vertexIDProvider;
    private final Set<CSVFormat.Parameter> parameters;
    private CSVFormat format;
    private char delimiter;

    public CSVExporter() {
        this(new IntegerComponentNameProvider(), CSVFormat.ADJACENCY_LIST, ',');
    }

    public CSVExporter(CSVFormat format) {
        this(new IntegerComponentNameProvider(), format, ',');
    }

    public CSVExporter(CSVFormat format, char delimiter) {
        this(new IntegerComponentNameProvider(), format, delimiter);
    }

    public CSVExporter(ComponentNameProvider<V> vertexIDProvider, CSVFormat format, char delimiter) {
        if (vertexIDProvider == null) {
            throw new IllegalArgumentException("Vertex id provider cannot be null");
        }
        this.vertexIDProvider = vertexIDProvider;
        this.format = format;
        if (!DSVUtils.isValidDelimiter(delimiter)) {
            throw new IllegalArgumentException("Character cannot be used as a delimiter");
        }
        this.delimiter = delimiter;
        this.parameters = new HashSet<CSVFormat.Parameter>();
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        switch (this.format) {
            case EDGE_LIST: {
                this.exportAsEdgeList(g, out);
                break;
            }
            case ADJACENCY_LIST: {
                this.exportAsAdjacencyList(g, out);
                break;
            }
            case MATRIX: {
                this.exportAsMatrix(g, out);
            }
        }
        out.flush();
    }

    public boolean isParameter(CSVFormat.Parameter p) {
        return this.parameters.contains((Object)p);
    }

    public void setParameter(CSVFormat.Parameter p, boolean value) {
        if (value) {
            this.parameters.add(p);
        } else {
            this.parameters.remove((Object)p);
        }
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public void setFormat(CSVFormat format) {
        this.format = format;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        if (!DSVUtils.isValidDelimiter(delimiter)) {
            throw new IllegalArgumentException("Character cannot be used as a delimiter");
        }
        this.delimiter = delimiter;
    }

    private void exportAsEdgeList(Graph<V, E> g, PrintWriter out) {
        for (Object e : g.edgeSet()) {
            this.exportEscapedField(out, this.vertexIDProvider.getName(g.getEdgeSource(e)));
            out.print(this.delimiter);
            this.exportEscapedField(out, this.vertexIDProvider.getName(g.getEdgeTarget(e)));
            out.println();
        }
    }

    private void exportAsAdjacencyList(Graph<V, E> g, PrintWriter out) {
        if (g instanceof DirectedGraph) {
            for (Object v : g.vertexSet()) {
                this.exportEscapedField(out, this.vertexIDProvider.getName(v));
                for (Object e : ((DirectedGraph)g).outgoingEdgesOf(v)) {
                    Object w = Graphs.getOppositeVertex(g, e, v);
                    out.print(this.delimiter);
                    this.exportEscapedField(out, this.vertexIDProvider.getName(w));
                }
                out.println();
            }
        } else {
            for (Object v : g.vertexSet()) {
                this.exportEscapedField(out, this.vertexIDProvider.getName(v));
                for (Object e : g.edgesOf(v)) {
                    Object w = Graphs.getOppositeVertex(g, e, v);
                    out.print(this.delimiter);
                    this.exportEscapedField(out, this.vertexIDProvider.getName(w));
                }
                out.println();
            }
        }
    }

    private void exportAsMatrix(Graph<V, E> g, PrintWriter out) {
        boolean exportNodeId = this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_NODEID);
        boolean exportEdgeWeights = this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_EDGE_WEIGHTS);
        boolean zeroWhenNoEdge = this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_ZERO_WHEN_NO_EDGE);
        if (exportNodeId) {
            for (Object v : g.vertexSet()) {
                out.print(this.delimiter);
                this.exportEscapedField(out, this.vertexIDProvider.getName(v));
            }
            out.println();
        }
        int n = g.vertexSet().size();
        for (Object v : g.vertexSet()) {
            if (exportNodeId) {
                this.exportEscapedField(out, this.vertexIDProvider.getName(v));
                out.print(this.delimiter);
            }
            int i = 0;
            for (Object u : g.vertexSet()) {
                Object e = g.getEdge(v, u);
                if (e == null) {
                    if (zeroWhenNoEdge) {
                        this.exportEscapedField(out, "0");
                    }
                } else if (exportEdgeWeights) {
                    this.exportEscapedField(out, String.valueOf(g.getEdgeWeight(e)));
                } else {
                    this.exportEscapedField(out, "1");
                }
                if (i++ >= n - 1) continue;
                out.print(this.delimiter);
            }
            out.println();
        }
    }

    private void exportEscapedField(PrintWriter out, String field) {
        out.print(DSVUtils.escapeDSV(field, this.delimiter));
    }
}

