/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImmutableNode
extends NodeBase {
    @NotNull
    private final RandomAccessLoggable loggable;
    @NotNull
    private final ByteIterableWithAddress data;
    private final int dataOffset;
    private final short childrenCount;
    private final byte childAddressLength;

    ImmutableNode(@NotNull RandomAccessLoggable loggable, @NotNull ByteIterableWithAddress data) {
        this(loggable.getType(), loggable, data, data.iterator());
    }

    private ImmutableNode(byte type, @NotNull RandomAccessLoggable loggable, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        super(type, data, it);
        this.loggable = loggable;
        this.data = data;
        if (PatriciaTreeBase.nodeHasChildren(type)) {
            int i2 = CompressedUnsignedLongByteIterable.getInt(it);
            this.childrenCount = (short)(i2 >> 3);
            this.childAddressLength = (byte)((i2 & 7) + 1);
            ImmutableNode.checkAddressLength(this.childAddressLength);
        } else {
            this.childrenCount = 0;
            this.childAddressLength = 0;
        }
        this.dataOffset = (int)(it.getAddress() - data.getDataAddress());
    }

    ImmutableNode() {
        super(ByteIterable.EMPTY, null);
        this.loggable = NullLoggable.create();
        this.data = ByteIterableWithAddress.EMPTY;
        this.dataOffset = 0;
        this.childrenCount = 0;
        this.childAddressLength = 0;
    }

    @NotNull
    public RandomAccessLoggable getLoggable() {
        return this.loggable;
    }

    @Override
    long getAddress() {
        return this.loggable.getAddress();
    }

    @Override
    boolean isMutable() {
        return false;
    }

    @Override
    MutableNode getMutableCopy(@NotNull PatriciaTreeMutable mutableTree) {
        return mutableTree.mutateNode(this);
    }

    @Override
    @Nullable
    NodeBase getChild(@NotNull PatriciaTreeBase tree, byte b) {
        int key = b & 0xFF;
        int low = 0;
        int high = this.childrenCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int offset = this.dataOffset + mid * (this.childAddressLength + 1);
            int cmp = (this.data.byteAt(offset) & 0xFF) - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return tree.loadNode(this.data.nextLong(offset + 1, this.childAddressLength));
        }
        return null;
    }

    @Override
    @NotNull
    NodeChildren getChildren() {
        return new NodeChildren(){

            @Override
            @NotNull
            public NodeChildrenIterator iterator() {
                return ImmutableNode.this.childrenCount == 0 ? new NodeBase.EmptyNodeChildrenIterator(ImmutableNode.this) : new ImmutableNodeChildrenIterator(ImmutableNode.this.getDataIterator(0), -1, null);
            }
        };
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildren(byte b) {
        int key = b & 0xFF;
        int low = 0;
        int high = this.childrenCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int offset = this.dataOffset + mid * (this.childAddressLength + 1);
            int cmp = (this.data.byteAt(offset) & 0xFF) - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            long suffixAddress = this.data.nextLong(offset + 1, this.childAddressLength);
            return new ImmutableNodeChildrenIterator(this.data.iterator(offset + this.childAddressLength + 1), mid, new ChildReference(b, suffixAddress));
        }
        return new NodeBase.EmptyNodeChildrenIterator(this);
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenRange(byte b) {
        int key = b & 0xFF;
        int low = -1;
        int high = this.childrenCount;
        int resultOffset = -1;
        byte resultByte = 0;
        while (high - low > 1) {
            int mid = low + high + 1 >>> 1;
            int offset = this.dataOffset + mid * (this.childAddressLength + 1);
            byte actual = this.data.byteAt(offset);
            if ((actual & 0xFF) > key) {
                resultOffset = offset;
                resultByte = actual;
                high = mid;
                continue;
            }
            low = mid;
        }
        if (resultOffset >= 0) {
            ByteIteratorWithAddress it = this.data.iterator(resultOffset + 1);
            long suffixAddress = it.nextLong(this.childAddressLength);
            return new ImmutableNodeChildrenIterator(it, high, new ChildReference(resultByte, suffixAddress));
        }
        return new NodeBase.EmptyNodeChildrenIterator(this);
    }

    @Override
    int getChildrenCount() {
        return this.childrenCount;
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenLast() {
        return new ImmutableNodeChildrenIterator(null, this.childrenCount, null);
    }

    private ByteIterator getDataIterator(int offset) {
        return this.getAddress() == -1L ? ByteIterable.EMPTY_ITERATOR : this.data.iterator(this.dataOffset + offset);
    }

    private static void checkAddressLength(long addressLen) {
        if (addressLen < 0L || addressLen > 8L) {
            throw new ExodusException("Invalid length of address: " + addressLen);
        }
    }

    private final class ImmutableNodeChildrenIterator
    implements NodeChildrenIterator {
        private ByteIterator itr;
        private int index = 0;
        private ChildReference node;

        private ImmutableNodeChildrenIterator(ByteIterator itr, int index, ChildReference node) {
            this.itr = itr;
            this.index = index;
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.index < ImmutableNode.this.childrenCount - 1;
        }

        @Override
        public ChildReference next() {
            ++this.index;
            this.node = new ChildReference(this.itr.next(), this.itr.nextLong((int)ImmutableNode.this.childAddressLength));
            return this.node;
        }

        @Override
        public boolean hasPrev() {
            return this.index > 0;
        }

        @Override
        public ChildReference prev() {
            --this.index;
            this.itr = ImmutableNode.this.getDataIterator(this.index * (ImmutableNode.this.childAddressLength + 1));
            this.node = new ChildReference(this.itr.next(), this.itr.nextLong((int)ImmutableNode.this.childAddressLength));
            return this.node;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public void nextInPlace() {
            ++this.index;
            ChildReference node = this.node;
            node.firstByte = this.itr.next();
            node.suffixAddress = this.itr.nextLong((int)ImmutableNode.this.childAddressLength);
        }

        @Override
        public void prevInPlace() {
            --this.index;
            ChildReference node = this.node;
            this.itr = ImmutableNode.this.getDataIterator(this.index * (ImmutableNode.this.childAddressLength + 1));
            node.firstByte = this.itr.next();
            node.suffixAddress = this.itr.nextLong((int)ImmutableNode.this.childAddressLength);
        }

        @Override
        public ChildReference getNode() {
            return this.node;
        }

        @Override
        public void remove() {
            throw new ExodusException("Can't remove manually Patricia node child, use Store.delete() instead");
        }

        @Override
        public NodeBase getParentNode() {
            return ImmutableNode.this;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public ByteIterable getKey() {
            return ImmutableNode.this.keySequence;
        }
    }
}

