/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataReaderWriterProvider;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.FileDataWriter;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0014J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Ljetbrains/exodus/io/FileDataReaderWriterProvider;", "Ljetbrains/exodus/io/DataReaderWriterProvider;", "()V", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "getEnv", "()Ljetbrains/exodus/env/EnvironmentImpl;", "setEnv", "(Ljetbrains/exodus/env/EnvironmentImpl;)V", "newFileDataReader", "Ljetbrains/exodus/io/DataReader;", "location", "", "newFileDataWriter", "Ljetbrains/exodus/io/FileDataWriter;", "reader", "newReaderWriter", "Ljetbrains/exodus/core/dataStructures/Pair;", "Ljetbrains/exodus/io/DataWriter;", "onEnvironmentCreated", "", "environment", "Ljetbrains/exodus/env/Environment;", "Companion", "xodus-environment"})
public class FileDataReaderWriterProvider
extends DataReaderWriterProvider {
    @Nullable
    private EnvironmentImpl env;
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final EnvironmentImpl getEnv() {
        return this.env;
    }

    protected final void setEnv(@Nullable EnvironmentImpl environmentImpl) {
        this.env = environmentImpl;
    }

    @NotNull
    public Pair<DataReader, DataWriter> newReaderWriter(@NotNull String location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        DataReader reader = this.newFileDataReader(location);
        return new Pair((Object)reader, (Object)this.newFileDataWriter(location, reader));
    }

    public void onEnvironmentCreated(@NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        super.onEnvironmentCreated(environment);
        this.env = (EnvironmentImpl)environment;
    }

    @NotNull
    protected DataReader newFileDataReader(@NotNull String location) {
        FileDataReader fileDataReader;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        EnvironmentImpl environmentImpl = this.env;
        EnvironmentConfig ec = environmentImpl != null ? environmentImpl.getEnvironmentConfig() : null;
        FileDataReader $receiver = fileDataReader = new FileDataReader(Companion.checkDirectory(location));
        if (ec != null && ec.getLogCacheUseNio()) {
            $receiver.useNio$xodus_environment(ec.getLogCacheFreePhysicalMemoryThreshold());
        }
        return fileDataReader;
    }

    @NotNull
    protected FileDataWriter newFileDataWriter(@NotNull String location, @NotNull DataReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        EnvironmentImpl environmentImpl = this.env;
        return new FileDataWriter((FileDataReader)reader, environmentImpl != null && (environmentImpl = environmentImpl.getEnvironmentConfig()) != null ? environmentImpl.getLogLockId() : null);
    }

    @JvmStatic
    @NotNull
    protected static final File checkDirectory(@NotNull String location) {
        return Companion.checkDirectory(location);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0005\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/io/FileDataReaderWriterProvider$Companion;", "", "()V", "checkDirectory", "Ljava/io/File;", "location", "", "xodus-environment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        protected final File checkDirectory(@NotNull String location) {
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            File directory = new File(location);
            if (directory.isFile()) {
                throw (Throwable)new ExodusException("A directory is required: " + directory);
            }
            if (!directory.exists() && !directory.mkdirs()) {
                throw (Throwable)new ExodusException("Failed to create directory: " + directory);
            }
            return directory;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

