/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env.management;

import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.management.EnvironmentConfigMBean;
import jetbrains.exodus.management.MBeanBase;
import org.jetbrains.annotations.NotNull;

public class EnvironmentConfig
extends MBeanBase
implements EnvironmentConfigMBean {
    @NotNull
    final EnvironmentImpl env;
    @NotNull
    private final jetbrains.exodus.env.EnvironmentConfig config;

    public EnvironmentConfig(@NotNull EnvironmentImpl env) {
        super(EnvironmentConfig.getObjectName(env));
        this.env = env;
        this.config = env.getEnvironmentConfig();
    }

    @Override
    public long getMemoryUsage() {
        return this.config.getMemoryUsage();
    }

    @Override
    public int getMemoryUsagePercent() {
        return this.config.getMemoryUsagePercentage();
    }

    @Override
    public boolean getLogDurableWrite() {
        return this.config.getLogDurableWrite();
    }

    @Override
    public void setLogDurableWrite(boolean durableWrite) {
        this.config.setLogDurableWrite(durableWrite);
    }

    @Override
    public long getLogFileSize() {
        return this.config.getLogFileSize();
    }

    @Override
    public long getLogLockTimeout() {
        return this.config.getLogLockTimeout();
    }

    @Override
    public int getLogCachePageSize() {
        return this.config.getLogCachePageSize();
    }

    @Override
    public int getLogCacheOpenFilesCount() {
        return this.config.getLogCacheOpenFilesCount();
    }

    @Override
    public boolean getLogCacheUseNio() {
        return this.config.getLogCacheUseNio();
    }

    @Override
    public long getLogCacheFreePhysicalMemoryThreshold() {
        return this.config.getLogCacheFreePhysicalMemoryThreshold();
    }

    @Override
    public boolean isLogCacheShared() {
        return this.config.isLogCacheShared();
    }

    @Override
    public boolean isLogCacheNonBlocking() {
        return this.config.isLogCacheNonBlocking();
    }

    @Override
    public int getLogCacheGenerationCount() {
        return this.config.getLogCacheGenerationCount();
    }

    @Override
    public int getLogCacheReadAheadMultiple() {
        return this.config.getLogCacheReadAheadMultiple();
    }

    @Override
    public void setLogCacheReadAheadMultiple(int readAheadMultiple) {
        this.config.setLogCacheReadAheadMultiple(readAheadMultiple);
    }

    @Override
    public boolean isLogCleanDirectoryExpected() {
        return this.config.isLogCleanDirectoryExpected();
    }

    @Override
    public boolean isLogClearInvalid() {
        return this.config.isLogClearInvalid();
    }

    @Override
    public long getLogSyncPeriod() {
        return this.config.getLogSyncPeriod();
    }

    @Override
    public void setLogSyncPeriod(long millis) {
        this.config.setLogSyncPeriod(millis);
    }

    @Override
    public boolean isLogFullFileReadonly() {
        return this.config.isLogFullFileReadonly();
    }

    @Override
    public boolean getEnvIsReadonly() {
        return this.config.getEnvIsReadonly();
    }

    @Override
    public void setEnvIsReadonly(boolean isReadonly) {
        this.config.setEnvIsReadonly(isReadonly);
    }

    @Override
    public boolean getEnvFailFastInReadonly() {
        return this.config.getEnvFailFastInReadonly();
    }

    @Override
    public void setEnvFailFastInReadonly(boolean failFast) {
        this.config.setEnvFailFastInReadonly(failFast);
    }

    @Override
    public boolean getEnvReadonlyEmptyStores() {
        return this.config.getEnvReadonlyEmptyStores();
    }

    @Override
    public void setEnvReadonlyEmptyStores(boolean readonlyEmptyStores) {
        this.config.setEnvReadonlyEmptyStores(readonlyEmptyStores);
    }

    @Override
    public int getEnvStoreGetCacheSize() {
        return this.config.getEnvStoreGetCacheSize();
    }

    @Override
    public void setEnvStoreGetCacheSize(int storeGetCacheSize) {
        this.config.setEnvStoreGetCacheSize(storeGetCacheSize);
    }

    @Override
    public int getEnvStoreGetCacheMinTreeSize() {
        return this.config.getEnvStoreGetCacheMinTreeSize();
    }

    @Override
    public void setEnvStoreGetCacheMinTreeSize(int minTreeSize) {
        this.config.setEnvStoreGetCacheMinTreeSize(minTreeSize);
    }

    @Override
    public int getEnvStoreGetCacheMaxValueSize() {
        return this.config.getEnvStoreGetCacheMaxValueSize();
    }

    @Override
    public void setEnvStoreGetCacheMaxValueSize(int maxValueSize) {
        this.config.setEnvStoreGetCacheMaxValueSize(maxValueSize);
    }

    @Override
    public boolean getEnvCloseForcedly() {
        return this.config.getEnvCloseForcedly();
    }

    @Override
    public void setEnvCloseForcedly(boolean closeForcedly) {
        this.config.setEnvCloseForcedly(closeForcedly);
    }

    @Override
    public long getEnvTxnReplayTimeout() {
        return this.config.getEnvTxnReplayTimeout();
    }

    @Override
    public void setEnvTxnReplayTimeout(long txnReplayTimeout) {
        this.config.setEnvTxnReplayTimeout(txnReplayTimeout);
    }

    @Override
    public int getEnvTxnReplayMaxCount() {
        return this.config.getEnvTxnReplayMaxCount();
    }

    @Override
    public void setEnvTxnReplayMaxCount(int txnReplayMaxCount) {
        this.config.setEnvTxnReplayMaxCount(txnReplayMaxCount);
    }

    @Override
    public boolean getEnvTxnDowngradeAfterFlush() {
        return this.config.getEnvTxnDowngradeAfterFlush();
    }

    @Override
    public void setEnvTxnDowngradeAfterFlush(boolean downgrade) {
        this.config.setEnvTxnDowngradeAfterFlush(downgrade);
    }

    @Override
    public boolean getEnvTxnSingleThreadWrites() {
        return this.config.getEnvTxnSingleThreadWrites();
    }

    @Override
    public void setEnvTxnSingleThreadWrites(boolean singleThreadWrites) {
        this.config.setEnvTxnSingleThreadWrites(singleThreadWrites);
    }

    @Override
    public int getEnvMaxParallelTxns() {
        return this.config.getEnvMaxParallelTxns();
    }

    @Override
    public int getEnvMaxParallelReadonlyTxns() {
        return this.config.getEnvMaxParallelReadonlyTxns();
    }

    @Override
    public int getEnvMonitorTxnsTimeout() {
        return this.config.getEnvMonitorTxnsTimeout();
    }

    @Override
    public int getEnvMonitorTxnsCheckFreq() {
        return this.config.getEnvMonitorTxnsCheckFreq();
    }

    @Override
    public boolean getEnvGatherStatistics() {
        return this.config.getEnvGatherStatistics();
    }

    @Override
    public int getTreeMaxPageSize() {
        return this.config.getTreeMaxPageSize();
    }

    @Override
    public void setTreeMaxPageSize(int treeMaxPageSize) {
        this.config.setTreeMaxPageSize(treeMaxPageSize);
    }

    @Override
    public boolean isGcEnabled() {
        return this.config.isGcEnabled();
    }

    @Override
    public void setGcEnabled(boolean enabled) {
        this.config.setGcEnabled(enabled);
    }

    @Override
    public boolean isGcSuspended() {
        return this.env.getGC().isSuspended();
    }

    @Override
    public int getGcStartIn() {
        return this.config.getGcStartIn();
    }

    @Override
    public int getGcMinUtilization() {
        return this.config.getGcMinUtilization();
    }

    @Override
    public void setGcMinUtilization(int percent) {
        this.config.setGcMinUtilization(percent);
    }

    @Override
    public boolean getGcRenameFiles() {
        return this.config.getGcRenameFiles();
    }

    @Override
    public void setGcRenameFiles(boolean rename) {
        this.config.setGcRenameFiles(rename);
    }

    @Override
    public int getGcFileMinAge() {
        return this.config.getGcFileMinAge();
    }

    @Override
    public void setGcFileMinAge(int minAge) {
        this.config.setGcFileMinAge(minAge);
    }

    @Override
    public int getGcFilesInterval() {
        return this.config.getGcFilesInterval();
    }

    @Override
    public void setGcFilesInterval(int files) {
        this.config.setGcFilesInterval(files);
    }

    @Override
    public int getGcRunPeriod() {
        return this.config.getGcRunPeriod();
    }

    @Override
    public void setGcRunPeriod(int runPeriod) {
        this.config.setGcRunPeriod(runPeriod);
    }

    @Override
    public boolean getGcUtilizationFromScratch() {
        return this.config.getGcUtilizationFromScratch();
    }

    @Override
    public void setGcUtilizationFromScratch(boolean fromScratch) {
        this.config.setGcUtilizationFromScratch(fromScratch);
    }

    @Override
    public String getGcUtilizationFromFile() {
        return this.config.getGcUtilizationFromFile();
    }

    @Override
    public void setGcUtilizationFromFile(String file) {
        this.config.setGcUtilizationFromFile(file);
    }

    @Override
    public boolean getGcUseExclusiveTransaction() {
        return this.config.getGcUseExclusiveTransaction();
    }

    @Override
    public void setGcUseExclusiveTransaction(boolean useExclusiveTransaction) {
        this.config.setGcUseExclusiveTransaction(useExclusiveTransaction);
    }

    @Override
    public int getGcTransactionAcquireTimeout() {
        return this.config.getGcTransactionAcquireTimeout();
    }

    @Override
    public void setGcTransactionAcquireTimeout(int timeout) {
        this.config.setGcTransactionAcquireTimeout(timeout);
    }

    @Override
    public int getGcTransactionTimeout() {
        return this.config.getGcTransactionTimeout();
    }

    @Override
    public void setGcTransactionTimeout(int timeout) {
        this.config.setGcTransactionTimeout(timeout);
    }

    @Override
    public int getGcFilesDeletionDelay() {
        return this.config.getGcFilesDeletionDelay();
    }

    @Override
    public void setGcFilesDeletionDelay(int delay) {
        this.config.setGcFilesDeletionDelay(delay);
    }

    @Override
    public int getGcRunEvery() {
        return this.config.getGcRunEvery();
    }

    @Override
    public void setGcRunEvery(int seconds) {
        this.config.setGcRunEvery(seconds);
    }

    @Override
    public void gc() {
        this.env.gc();
    }

    public static String getObjectName(@NotNull Environment env) {
        return "jetbrains.exodus.env: type=EnvironmentConfig, location=" + EnvironmentConfig.escapeLocation((String)env.getLocation());
    }
}

