/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.exodus.ConfigSettingChangeListener;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.entitystore.MetaServer;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentBackupStrategyImpl;
import jetbrains.exodus.env.EnvironmentClosedException;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.MetaTree;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.ReadonlyTransaction;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.ReentrantTransactionDispatcher;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreGetCache;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.StuckTransactionMonitor;
import jetbrains.exodus.env.TemporaryEmptyStore;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionSet;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.env.management.EnvironmentConfig;
import jetbrains.exodus.env.management.EnvironmentConfigWithOperations;
import jetbrains.exodus.env.management.EnvironmentStatistics;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.io.DataReaderWriterProvider;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.tree.ExpiredLoggableCollection;
import jetbrains.exodus.tree.TreeMetaInfo;
import jetbrains.exodus.tree.btree.BTree;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.util.DeferredIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentImpl
implements Environment {
    public static final int META_TREE_ID = 1;
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentImpl.class);
    private static final String ENVIRONMENT_PROPERTIES_FILE = "exodus.properties";
    @NotNull
    private final Log log;
    @NotNull
    private final jetbrains.exodus.env.EnvironmentConfig ec;
    private BTreeBalancePolicy balancePolicy;
    private MetaTreeImpl metaTree;
    private final AtomicInteger structureId;
    @NotNull
    private final TransactionSet txns;
    private final LinkedList<RunnableWithTxnRoot> txnSafeTasks;
    @Nullable
    private StoreGetCache storeGetCache;
    private final EnvironmentSettingsListener envSettingsListener;
    private final GarbageCollector gc;
    final Object commitLock = new Object();
    private final ReentrantReadWriteLock.ReadLock metaReadLock;
    final ReentrantReadWriteLock.WriteLock metaWriteLock;
    private final ReentrantTransactionDispatcher txnDispatcher;
    private final ReentrantTransactionDispatcher roTxnDispatcher;
    @NotNull
    private final jetbrains.exodus.env.EnvironmentStatistics statistics;
    @Nullable
    private final EnvironmentConfig configMBean;
    @Nullable
    private final EnvironmentStatistics statisticsMBean;
    volatile Throwable throwableOnCommit;
    private Throwable throwableOnClose;
    @Nullable
    private final StuckTransactionMonitor stuckTxnMonitor;
    @Nullable
    private final StreamCipherProvider streamCipherProvider;
    @Nullable
    private final byte[] cipherKey;
    private final long cipherBasicIV;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnvironmentImpl(@NotNull Log log, @NotNull jetbrains.exodus.env.EnvironmentConfig ec) {
        Pair<MetaTreeImpl, Integer> meta;
        this.log = log;
        this.ec = ec;
        EnvironmentImpl.applyEnvironmentSettings(log.getLocation(), ec);
        DataReaderWriterProvider readerWriterProvider = log.getConfig().getReaderWriterProvider();
        readerWriterProvider.onEnvironmentCreated((Environment)this);
        Object object = this.commitLock;
        synchronized (object) {
            meta = MetaTreeImpl.create(this);
        }
        this.metaTree = (MetaTreeImpl)meta.getFirst();
        this.structureId = new AtomicInteger((Integer)meta.getSecond());
        this.txns = new TransactionSet();
        this.txnSafeTasks = new LinkedList();
        this.invalidateStoreGetCache();
        this.envSettingsListener = new EnvironmentSettingsListener();
        ec.addChangedSettingsListener((ConfigSettingChangeListener)this.envSettingsListener);
        this.gc = new GarbageCollector(this);
        ReentrantReadWriteLock metaLock = new ReentrantReadWriteLock();
        this.metaReadLock = metaLock.readLock();
        this.metaWriteLock = metaLock.writeLock();
        this.txnDispatcher = new ReentrantTransactionDispatcher(ec.getEnvMaxParallelTxns());
        this.roTxnDispatcher = new ReentrantTransactionDispatcher(ec.getEnvMaxParallelReadonlyTxns());
        this.statistics = new jetbrains.exodus.env.EnvironmentStatistics(this);
        if (ec.isManagementEnabled()) {
            this.configMBean = ec.getManagementOperationsRestricted() ? new EnvironmentConfig(this) : new EnvironmentConfigWithOperations(this);
            this.statisticsMBean = ec.getEnvGatherStatistics() ? new EnvironmentStatistics(this) : null;
        } else {
            this.configMBean = null;
            this.statisticsMBean = null;
        }
        this.throwableOnCommit = null;
        this.throwableOnClose = null;
        this.stuckTxnMonitor = this.transactionTimeout() > 0 || this.transactionExpirationTimeout() > 0 ? new StuckTransactionMonitor(this) : null;
        LogConfig logConfig = log.getConfig();
        this.streamCipherProvider = logConfig.getCipherProvider();
        this.cipherKey = logConfig.getCipherKey();
        this.cipherBasicIV = logConfig.getCipherBasicIV();
        EnvironmentImpl.loggerInfo("Exodus environment created: " + log.getLocation());
    }

    public long getCreated() {
        return this.log.getCreated();
    }

    @NotNull
    public String getLocation() {
        return this.log.getLocation();
    }

    @NotNull
    public jetbrains.exodus.env.EnvironmentConfig getEnvironmentConfig() {
        return this.ec;
    }

    @NotNull
    public jetbrains.exodus.env.EnvironmentStatistics getStatistics() {
        return this.statistics;
    }

    public GarbageCollector getGC() {
        return this.gc;
    }

    @NotNull
    public StoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, @NotNull Transaction transaction) {
        TransactionBase txn = (TransactionBase)transaction;
        return this.openStoreImpl(name, config, txn, txn.getTreeMetaInfo(name));
    }

    @Nullable
    public StoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, @NotNull Transaction transaction, boolean creationRequired) {
        TransactionBase txn = (TransactionBase)transaction;
        TreeMetaInfo metaInfo = txn.getTreeMetaInfo(name);
        if (metaInfo == null && !creationRequired) {
            return null;
        }
        return this.openStoreImpl(name, config, txn, metaInfo);
    }

    @NotNull
    public TransactionBase beginTransaction() {
        return this.beginTransaction(null, false, false);
    }

    @NotNull
    public TransactionBase beginTransaction(Runnable beginHook) {
        return this.beginTransaction(beginHook, false, false);
    }

    @NotNull
    public Transaction beginExclusiveTransaction() {
        return this.beginTransaction(null, true, false);
    }

    @NotNull
    public Transaction beginExclusiveTransaction(Runnable beginHook) {
        return this.beginTransaction(beginHook, true, false);
    }

    @NotNull
    public Transaction beginReadonlyTransaction() {
        return this.beginReadonlyTransaction(null);
    }

    @NotNull
    public TransactionBase beginReadonlyTransaction(Runnable beginHook) {
        this.checkIsOperative();
        return new ReadonlyTransaction(this, false, beginHook);
    }

    @NotNull
    public ReadWriteTransaction beginGCTransaction() {
        if (this.ec.getEnvIsReadonly()) {
            throw new ReadonlyTransactionException("Can't start GC transaction on read-only Environment");
        }
        return new ReadWriteTransaction(this, null, this.ec.getGcUseExclusiveTransaction(), true){

            @Override
            boolean isGCTransaction() {
                return true;
            }
        };
    }

    public void executeInTransaction(@NotNull TransactionalExecutable executable) {
        EnvironmentImpl.executeInTransaction(executable, this.beginTransaction());
    }

    public void executeInExclusiveTransaction(@NotNull TransactionalExecutable executable) {
        EnvironmentImpl.executeInTransaction(executable, this.beginExclusiveTransaction());
    }

    public void executeInReadonlyTransaction(@NotNull TransactionalExecutable executable) {
        Transaction txn = this.beginReadonlyTransaction();
        try {
            executable.execute(txn);
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    public <T> T computeInTransaction(@NotNull TransactionalComputable<T> computable) {
        return EnvironmentImpl.computeInTransaction(computable, this.beginTransaction());
    }

    public <T> T computeInExclusiveTransaction(@NotNull TransactionalComputable<T> computable) {
        return EnvironmentImpl.computeInTransaction(computable, this.beginExclusiveTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeInReadonlyTransaction(@NotNull TransactionalComputable<T> computable) {
        Transaction txn = this.beginReadonlyTransaction();
        try {
            Object object = computable.compute(txn);
            return (T)object;
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTransactionSafeTask(@NotNull Runnable task) {
        long newestTxnRoot = this.txns.getNewestTxnRootAddress();
        if (newestTxnRoot == Long.MIN_VALUE) {
            task.run();
        } else {
            LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
            synchronized (linkedList) {
                this.txnSafeTasks.addLast(new RunnableWithTxnRoot(task, newestTxnRoot));
            }
        }
    }

    public int getStuckTransactionCount() {
        return this.stuckTxnMonitor == null ? 0 : this.stuckTxnMonitor.getStuckTxnCount();
    }

    @Nullable
    public StreamCipherProvider getCipherProvider() {
        return this.streamCipherProvider;
    }

    @Nullable
    public byte[] getCipherKey() {
        return this.cipherKey;
    }

    public long getCipherBasicIV() {
        return this.cipherBasicIV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Thread currentThread = Thread.currentThread();
        if (this.txnDispatcher.getThreadPermits(currentThread) != 0 || this.roTxnDispatcher.getThreadPermits(currentThread) != 0) {
            throw new ExodusException("Environment.clear() can't proceed if there is a transaction in current thread");
        }
        this.runAllTransactionSafeTasks();
        LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
        synchronized (linkedList) {
            this.txnSafeTasks.clear();
        }
        this.suspendGC();
        try {
            int permits = this.txnDispatcher.acquireExclusiveTransaction(currentThread);
            try {
                int roPermits = this.roTxnDispatcher.acquireExclusiveTransaction(currentThread);
                try {
                    Object object = this.commitLock;
                    synchronized (object) {
                        this.metaWriteLock.lock();
                        try {
                            this.gc.clear();
                            this.log.clear();
                            this.invalidateStoreGetCache();
                            this.throwableOnCommit = null;
                            Pair<MetaTreeImpl, Integer> meta = MetaTreeImpl.create(this);
                            this.metaTree = (MetaTreeImpl)meta.getFirst();
                            this.structureId.set((Integer)meta.getSecond());
                        }
                        finally {
                            this.metaWriteLock.unlock();
                        }
                    }
                }
                finally {
                    this.roTxnDispatcher.releaseTransaction(currentThread, roPermits);
                }
            }
            finally {
                this.txnDispatcher.releaseTransaction(currentThread, permits);
            }
        }
        finally {
            this.resumeGC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        float storeGetCacheHitRate;
        float logCacheHitRate;
        Object object = this.commitLock;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
        }
        MetaServer metaServer = this.getEnvironmentConfig().getMetaServer();
        if (metaServer != null) {
            metaServer.stop((Environment)this);
        }
        if (this.configMBean != null) {
            this.configMBean.unregister();
        }
        if (this.statisticsMBean != null) {
            this.statisticsMBean.unregister();
        }
        this.runAllTransactionSafeTasks();
        this.gc.finish();
        Object object2 = this.commitLock;
        synchronized (object2) {
            if (this.throwableOnClose != null) {
                throw new EnvironmentClosedException(this.throwableOnClose);
            }
            boolean closeForcedly = this.ec.getEnvCloseForcedly();
            this.checkInactive(closeForcedly);
            try {
                if (!closeForcedly && !this.ec.getEnvIsReadonly() && this.ec.isGcEnabled()) {
                    this.executeInTransaction(new TransactionalExecutable(){

                        public void execute(@NotNull Transaction txn) {
                            EnvironmentImpl.this.gc.getUtilizationProfile().forceSave(txn);
                        }
                    });
                }
                this.ec.removeChangedSettingsListener((ConfigSettingChangeListener)this.envSettingsListener);
                logCacheHitRate = this.log.getCacheHitRate();
                this.log.close();
            }
            finally {
                this.log.release();
            }
            if (this.storeGetCache == null) {
                storeGetCacheHitRate = 0.0f;
            } else {
                storeGetCacheHitRate = this.storeGetCache.hitRate();
                this.storeGetCache.close();
            }
            this.throwableOnCommit = this.throwableOnClose = new EnvironmentClosedException();
        }
        EnvironmentImpl.loggerDebug("Store get cache hit rate: " + ObjectCacheBase.formatHitRate((float)storeGetCacheHitRate));
        EnvironmentImpl.loggerDebug("Exodus log cache hit rate: " + ObjectCacheBase.formatHitRate((float)logCacheHitRate));
    }

    public boolean isOpen() {
        return this.throwableOnClose == null;
    }

    @NotNull
    public BackupStrategy getBackupStrategy() {
        return new EnvironmentBackupStrategyImpl(this);
    }

    public void truncateStore(@NotNull String storeName, @NotNull Transaction txn) {
        ReadWriteTransaction t = EnvironmentImpl.throwIfReadonly(txn, "Can't truncate a store in read-only transaction");
        StoreImpl store = this.openStore(storeName, StoreConfig.USE_EXISTING, t, false);
        if (store == null) {
            throw new ExodusException("Attempt to truncate unknown store '" + storeName + '\'');
        }
        t.storeRemoved(store);
        TreeMetaInfo metaInfoCloned = store.getMetaInfo().clone(this.allocateStructureId());
        store = new StoreImpl(this, storeName, metaInfoCloned);
        t.storeCreated(store);
    }

    public void removeStore(@NotNull String storeName, @NotNull Transaction txn) {
        ReadWriteTransaction t = EnvironmentImpl.throwIfReadonly(txn, "Can't remove a store in read-only transaction");
        StoreImpl store = this.openStore(storeName, StoreConfig.USE_EXISTING, t, false);
        if (store == null) {
            throw new ExodusException("Attempt to remove unknown store '" + storeName + '\'');
        }
        t.storeRemoved(store);
    }

    public long getAllStoreCount() {
        this.metaReadLock.lock();
        try {
            long l = this.metaTree.getAllStoreCount();
            return l;
        }
        finally {
            this.metaReadLock.unlock();
        }
    }

    @NotNull
    public List<String> getAllStoreNames(@NotNull Transaction txn) {
        this.checkIfTransactionCreatedAgainstThis(txn);
        return ((TransactionBase)txn).getAllStoreNames();
    }

    public boolean storeExists(@NotNull String storeName, @NotNull Transaction txn) {
        return ((TransactionBase)txn).getTreeMetaInfo(storeName) != null;
    }

    @NotNull
    public Log getLog() {
        return this.log;
    }

    public void gc() {
        this.gc.wake(true);
    }

    public void suspendGC() {
        this.gc.suspend();
    }

    public void resumeGC() {
        this.gc.resume();
    }

    public BTreeBalancePolicy getBTreeBalancePolicy() {
        if (this.balancePolicy == null) {
            this.balancePolicy = new BTreeBalancePolicy(this.ec.getTreeMaxPageSize(), this.ec.getTreeDupMaxPageSize());
        }
        return this.balancePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndSync() {
        Object object = this.commitLock;
        synchronized (object) {
            if (this.isOpen()) {
                this.getLog().sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFiles(long[] files, @NotNull RemoveBlockType rbt) {
        Object object = this.commitLock;
        synchronized (object) {
            this.log.beginWrite();
            try {
                this.log.forgetFiles(files);
                this.log.endWrite();
            }
            catch (Throwable t) {
                this.log.abortWrite();
                throw ExodusException.toExodusException((Throwable)t, (String)"Failed to forget files in log");
            }
        }
        for (Object file : (Object)files) {
            this.log.removeFile((long)file, rbt);
        }
    }

    public float getStoreGetCacheHitRate() {
        return this.storeGetCache == null ? 0.0f : this.storeGetCache.hitRate();
    }

    protected StoreImpl createStore(@NotNull String name, @NotNull TreeMetaInfo metaInfo) {
        return new StoreImpl(this, name, metaInfo);
    }

    protected void finishTransaction(@NotNull TransactionBase txn) {
        this.releaseTransaction(txn);
        this.txns.remove(txn);
        txn.setIsFinished();
        this.runTransactionSafeTasks();
    }

    @NotNull
    protected TransactionBase beginTransaction(Runnable beginHook, boolean exclusive, boolean cloneMeta) {
        this.checkIsOperative();
        return this.ec.getEnvIsReadonly() && this.ec.getEnvFailFastInReadonly() ? new ReadonlyTransaction(this, exclusive, beginHook) : new ReadWriteTransaction(this, beginHook, exclusive, cloneMeta);
    }

    @Nullable
    StoreGetCache getStoreGetCache() {
        return this.storeGetCache;
    }

    long getDiskUsage() {
        return this.log.getDiskUsage();
    }

    void acquireTransaction(@NotNull TransactionBase txn) {
        this.checkIfTransactionCreatedAgainstThis(txn);
        (txn.isReadonly() ? this.roTxnDispatcher : this.txnDispatcher).acquireTransaction(txn, this);
    }

    void releaseTransaction(@NotNull TransactionBase txn) {
        this.checkIfTransactionCreatedAgainstThis(txn);
        (txn.isReadonly() ? this.roTxnDispatcher : this.txnDispatcher).releaseTransaction(txn);
    }

    void downgradeTransaction(@NotNull TransactionBase txn) {
        (txn.isReadonly() ? this.roTxnDispatcher : this.txnDispatcher).downgradeTransaction(txn);
    }

    boolean shouldTransactionBeExclusive(@NotNull ReadWriteTransaction txn) {
        int replayCount = txn.getReplayCount();
        return replayCount >= this.ec.getEnvTxnReplayMaxCount() || System.currentTimeMillis() - txn.getCreated() >= this.ec.getEnvTxnReplayTimeout();
    }

    int transactionTimeout() {
        return this.ec.getEnvMonitorTxnsTimeout();
    }

    int transactionExpirationTimeout() {
        return this.ec.getEnvMonitorTxnsExpirationTimeout();
    }

    @Nullable
    BTree loadMetaTree(long rootAddress, LogTip logTip) {
        if (rootAddress < 0L || rootAddress >= logTip.highAddress) {
            return null;
        }
        return new BTree(this.log, this.getBTreeBalancePolicy(), rootAddress, false, 1){

            @Override
            @NotNull
            public DataIterator getDataIterator(long address) {
                return new DataIterator(this.log, address);
            }
        };
    }

    boolean commitTransaction(@NotNull ReadWriteTransaction txn, boolean forceCommit) {
        if (this.flushTransaction(txn, forceCommit)) {
            this.finishTransaction(txn);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flushTransaction(@NotNull ReadWriteTransaction txn, boolean forceCommit) {
        long resultingHighAddress;
        ExpiredLoggableCollection expiredLoggables;
        long initialHighAddress;
        this.checkIfTransactionCreatedAgainstThis(txn);
        if (!forceCommit && txn.isIdempotent()) {
            return true;
        }
        boolean isGcTransaction = txn.isGCTransaction();
        boolean wasUpSaved = false;
        UtilizationProfile up = this.gc.getUtilizationProfile();
        if (!isGcTransaction && up.isDirty()) {
            up.save(txn);
            wasUpSaved = true;
        }
        Object object = this.commitLock;
        synchronized (object) {
            if (this.ec.getEnvIsReadonly()) {
                throw new ReadonlyTransactionException();
            }
            this.checkIsOperative();
            if (!txn.checkVersion(this.metaTree.root)) {
                return false;
            }
            if (wasUpSaved) {
                up.setDirty(false);
            }
            LogTip logTip = this.log.beginWrite();
            initialHighAddress = logTip.highAddress;
            boolean writeConfirmed = false;
            try {
                MetaTreeImpl.Proto[] tree = new MetaTreeImpl.Proto[1];
                expiredLoggables = txn.doCommit(tree);
                this.log.flush();
                MetaTreeImpl.Proto proto = tree[0];
                this.metaWriteLock.lock();
                try {
                    LogTip updatedTip = this.log.endWrite();
                    writeConfirmed = true;
                    resultingHighAddress = updatedTip.approvedHighAddress;
                    this.metaTree = MetaTreeImpl.create(this, updatedTip, proto);
                    txn.setMetaTree(this.metaTree);
                    txn.executeCommitHook();
                }
                finally {
                    this.metaWriteLock.unlock();
                }
            }
            catch (Throwable t) {
                EnvironmentImpl.loggerError("Failed to flush transaction", t);
                if (writeConfirmed) {
                    this.throwableOnCommit = t;
                    throw ExodusException.toExodusException((Throwable)t, (String)"Failed to read meta tree");
                }
                try {
                    this.log.revertWrite(logTip);
                }
                catch (Throwable th) {
                    this.throwableOnCommit = t;
                    EnvironmentImpl.loggerError("Failed to rollback high address", th);
                    throw ExodusException.toExodusException((Throwable)th, (String)"Failed to rollback high address");
                }
                throw ExodusException.toExodusException((Throwable)t, (String)"Failed to flush transaction");
            }
        }
        this.gc.fetchExpiredLoggables(expiredLoggables);
        this.statistics.getStatisticsItem(EnvironmentStatistics.Type.BYTES_WRITTEN).setTotal(resultingHighAddress);
        if (isGcTransaction) {
            this.statistics.getStatisticsItem(EnvironmentStatistics.Type.BYTES_MOVED_BY_GC).addTotal(resultingHighAddress - initialHighAddress);
        }
        this.statistics.getStatisticsItem(EnvironmentStatistics.Type.FLUSHED_TRANSACTIONS).incTotal();
        return true;
    }

    MetaTreeImpl holdNewestSnapshotBy(@NotNull TransactionBase txn) {
        return this.holdNewestSnapshotBy(txn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetaTreeImpl holdNewestSnapshotBy(@NotNull TransactionBase txn, boolean acquireTxn) {
        if (acquireTxn) {
            this.acquireTransaction(txn);
        }
        Runnable beginHook = txn.getBeginHook();
        this.metaReadLock.lock();
        try {
            if (beginHook != null) {
                beginHook.run();
            }
            MetaTreeImpl metaTreeImpl = this.metaTree;
            return metaTreeImpl;
        }
        finally {
            this.metaReadLock.unlock();
        }
    }

    public MetaTree getMetaTree() {
        this.metaReadLock.lock();
        try {
            MetaTreeImpl metaTreeImpl = this.metaTree;
            return metaTreeImpl;
        }
        finally {
            this.metaReadLock.unlock();
        }
    }

    MetaTreeImpl getMetaTreeInternal() {
        return this.metaTree;
    }

    void setMetaTreeInternal(MetaTreeImpl metaTree) {
        this.metaTree = metaTree;
    }

    @NotNull
    StoreImpl openStoreImpl(@NotNull String name, @NotNull StoreConfig config, @NotNull TransactionBase txn, @Nullable TreeMetaInfo metaInfo) {
        StoreImpl result;
        this.checkIfTransactionCreatedAgainstThis(txn);
        if (config.useExisting) {
            if (metaInfo == null) {
                throw new ExodusException("Can't restore meta information for store " + name);
            }
            config = TreeMetaInfo.toConfig(metaInfo);
        }
        if (metaInfo == null) {
            if (txn.isReadonly() && this.ec.getEnvReadonlyEmptyStores()) {
                return this.createTemporaryEmptyStore(name);
            }
            int structureId = this.allocateStructureId();
            metaInfo = TreeMetaInfo.load(this, config.duplicates, config.prefixing, structureId);
            result = this.createStore(name, metaInfo);
            ReadWriteTransaction tx = EnvironmentImpl.throwIfReadonly(txn, "Can't create a store in read-only transaction");
            tx.getMutableTree(result);
            tx.storeCreated(result);
        } else {
            boolean hasDuplicates = metaInfo.hasDuplicates();
            if (hasDuplicates != config.duplicates) {
                throw new ExodusException("Attempt to open store '" + name + "' with duplicates = " + config.duplicates + " while it was created with duplicates =" + hasDuplicates);
            }
            if (metaInfo.isKeyPrefixing() != config.prefixing) {
                if (!config.prefixing) {
                    throw new ExodusException("Attempt to open store '" + name + "' with prefixing = false while it was created with prefixing = true");
                }
                metaInfo = TreeMetaInfo.load(this, hasDuplicates, false, metaInfo.getStructureId());
            }
            result = this.createStore(name, metaInfo);
            if (txn instanceof ReadWriteTransaction) {
                ((ReadWriteTransaction)txn).storeOpened(result);
            }
        }
        return result;
    }

    int getLastStructureId() {
        return this.structureId.get();
    }

    void registerTransaction(@NotNull TransactionBase txn) {
        this.checkIfTransactionCreatedAgainstThis(txn);
        this.txns.add(txn);
    }

    boolean isRegistered(@NotNull ReadWriteTransaction txn) {
        this.checkIfTransactionCreatedAgainstThis(txn);
        return this.txns.contains(txn);
    }

    int activeTransactions() {
        return this.txns.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTransactionSafeTasks() {
        if (this.throwableOnCommit == null) {
            ArrayList<Runnable> tasksToRun = null;
            long oldestTxnRoot = this.txns.getOldestTxnRootAddress();
            LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
            synchronized (linkedList) {
                RunnableWithTxnRoot r;
                while (!this.txnSafeTasks.isEmpty() && (r = this.txnSafeTasks.getFirst()).txnRoot < oldestTxnRoot) {
                    this.txnSafeTasks.removeFirst();
                    if (tasksToRun == null) {
                        tasksToRun = new ArrayList<Runnable>(4);
                    }
                    tasksToRun.add(r.runnable);
                }
            }
            if (tasksToRun != null) {
                for (Runnable task : tasksToRun) {
                    task.run();
                }
            }
        }
    }

    void forEachActiveTransaction(@NotNull TransactionalExecutable executable) {
        this.txns.forEach(executable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHighAddress(long highAddress) {
        Object object = this.commitLock;
        synchronized (object) {
            this.log.setHighAddress(this.log.getTip(), highAddress);
            Pair<MetaTreeImpl, Integer> meta = MetaTreeImpl.create(this);
            this.metaWriteLock.lock();
            try {
                this.metaTree = (MetaTreeImpl)meta.getFirst();
            }
            finally {
                this.metaWriteLock.unlock();
            }
        }
    }

    boolean awaitUpdate(long fromAddress, long timeout) {
        int delta = 20;
        try {
            while (timeout > 0L) {
                if (this.log.getHighAddress() > fromAddress) {
                    return true;
                }
                Thread.sleep(20L);
                timeout -= 20L;
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    protected StoreImpl createTemporaryEmptyStore(String name) {
        return new TemporaryEmptyStore(this, name);
    }

    static boolean isUtilizationProfile(@NotNull String storeName) {
        return GarbageCollector.isUtilizationProfile(storeName);
    }

    static ReadWriteTransaction throwIfReadonly(@NotNull Transaction txn, @NotNull String exceptionMessage) {
        if (txn.isReadonly()) {
            throw new ReadonlyTransactionException(exceptionMessage);
        }
        return (ReadWriteTransaction)txn;
    }

    static void loggerError(@NotNull String errorMessage) {
        EnvironmentImpl.loggerError(errorMessage, null);
    }

    static void loggerError(@NotNull String errorMessage, @Nullable Throwable t) {
        if (t == null) {
            logger.error(errorMessage);
        } else {
            logger.error(errorMessage, t);
        }
    }

    static void loggerInfo(@NotNull String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
    }

    static void loggerDebug(@NotNull String message) {
        EnvironmentImpl.loggerDebug(message, null);
    }

    static void loggerDebug(@NotNull String message, @Nullable Throwable t) {
        if (logger.isDebugEnabled()) {
            if (t == null) {
                logger.debug(message);
            } else {
                logger.debug(message, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAllTransactionSafeTasks() {
        if (this.throwableOnCommit == null) {
            LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
            synchronized (linkedList) {
                for (RunnableWithTxnRoot r : this.txnSafeTasks) {
                    r.runnable.run();
                }
            }
            DeferredIO.getJobProcessor().waitForJobs(100L);
        }
    }

    private void checkIfTransactionCreatedAgainstThis(@NotNull Transaction txn) {
        if (txn.getEnvironment() != this) {
            throw new ExodusException("Transaction is created against another Environment");
        }
    }

    private void checkInactive(boolean exceptionSafe) {
        int txnCount = this.txns.size();
        if (!exceptionSafe && txnCount > 0) {
            SharedTimer.ensureIdle();
            txnCount = this.txns.size();
        }
        if (txnCount > 0) {
            String errorString = "Environment[" + this.getLocation() + "] is active: " + txnCount + " transaction(s) not finished";
            if (!exceptionSafe) {
                EnvironmentImpl.loggerError(errorString);
            } else {
                EnvironmentImpl.loggerInfo(errorString);
            }
            if (!exceptionSafe) {
                this.reportAliveTransactions(false);
            } else if (logger.isDebugEnabled()) {
                this.reportAliveTransactions(true);
            }
        }
        if (!exceptionSafe && txnCount > 0) {
            throw new ExodusException("Finish all transactions before closing database environment");
        }
    }

    private void reportAliveTransactions(final boolean debug) {
        if (this.transactionTimeout() == 0) {
            String stacksUnavailable = "Transactions stack traces are not available, set 'exodus.env.monitorTxns.timeout > 0'";
            if (debug) {
                EnvironmentImpl.loggerDebug(stacksUnavailable);
            } else {
                EnvironmentImpl.loggerError(stacksUnavailable);
            }
        } else {
            this.forEachActiveTransaction(new TransactionalExecutable(){

                public void execute(@NotNull Transaction txn) {
                    Throwable trace = ((TransactionBase)txn).getTrace();
                    if (debug) {
                        EnvironmentImpl.loggerDebug("Alive transaction: ", trace);
                    } else {
                        EnvironmentImpl.loggerError("Alive transaction: ", trace);
                    }
                }
            });
        }
    }

    private void checkIsOperative() {
        Throwable t = this.throwableOnCommit;
        if (t != null) {
            if (t instanceof EnvironmentClosedException) {
                throw new ExodusException("Environment is inoperative", t);
            }
            throw ExodusException.toExodusException((Throwable)t, (String)"Environment is inoperative");
        }
    }

    private int allocateStructureId() {
        int result;
        while (((result = this.structureId.incrementAndGet()) & 0xFF) == 0) {
        }
        return result;
    }

    private void invalidateStoreGetCache() {
        int storeGetCacheSize = this.ec.getEnvStoreGetCacheSize();
        this.storeGetCache = storeGetCacheSize == 0 ? null : new StoreGetCache(storeGetCacheSize, this.ec.getEnvStoreGetCacheMinTreeSize(), this.ec.getEnvStoreGetCacheMaxValueSize());
    }

    private static void applyEnvironmentSettings(@NotNull String location, @NotNull jetbrains.exodus.env.EnvironmentConfig ec) {
        File propsFile = new File(location, ENVIRONMENT_PROPERTIES_FILE);
        if (propsFile.exists() && propsFile.isFile()) {
            try (FileInputStream propsStream = new FileInputStream(propsFile);){
                Properties envProps = new Properties();
                envProps.load(propsStream);
                for (Map.Entry<Object, Object> entry : envProps.entrySet()) {
                    ec.setSetting(entry.getKey().toString(), entry.getValue());
                }
            }
            catch (IOException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }
    }

    private static void executeInTransaction(@NotNull TransactionalExecutable executable, @NotNull Transaction txn) {
        try {
            while (true) {
                executable.execute(txn);
                if (txn.isReadonly() || txn.isFinished()) break;
                if (txn.flush()) {
                    break;
                }
                txn.revert();
            }
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    private static <T> T computeInTransaction(@NotNull TransactionalComputable<T> computable, @NotNull Transaction txn) {
        try {
            while (true) {
                Object result = computable.compute(txn);
                if (txn.isReadonly() || txn.isFinished() || txn.flush()) {
                    Object object = result;
                    return (T)object;
                }
                txn.revert();
            }
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    private static void abortIfNotFinished(@NotNull Transaction txn) {
        if (!txn.isFinished()) {
            txn.abort();
        }
    }

    private static class RunnableWithTxnRoot {
        private final Runnable runnable;
        private final long txnRoot;

        private RunnableWithTxnRoot(Runnable runnable, long txnRoot) {
            this.runnable = runnable;
            this.txnRoot = txnRoot;
        }
    }

    private class EnvironmentSettingsListener
    implements ConfigSettingChangeListener {
        private EnvironmentSettingsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeSettingChanged(@NotNull String key, @NotNull Object value, @NotNull Map<String, Object> context) {
            if (key.equals("exodus.env.isReadonly")) {
                if (EnvironmentImpl.this.log.getConfig().getReaderWriterProvider().isReadonly()) {
                    throw new InvalidSettingException("Can't modify read-only state in run time since DataReaderWriterProvider is read-only");
                }
                if (Boolean.TRUE.equals(value)) {
                    EnvironmentImpl.this.suspendGC();
                    TransactionBase txn = EnvironmentImpl.this.beginTransaction();
                    try {
                        if (!txn.isReadonly()) {
                            EnvironmentImpl.this.gc.getUtilizationProfile().forceSave(txn);
                            txn.setCommitHook(new Runnable(){

                                @Override
                                public void run() {
                                    jetbrains.exodus.env.EnvironmentConfig.suppressConfigChangeListenersForThread();
                                    EnvironmentImpl.this.ec.setEnvIsReadonly(true);
                                    jetbrains.exodus.env.EnvironmentConfig.resumeConfigChangeListenersForThread();
                                }
                            });
                            ((ReadWriteTransaction)txn).forceFlush();
                        }
                    }
                    finally {
                        txn.abort();
                    }
                }
            }
        }

        public void afterSettingChanged(@NotNull String key, @NotNull Object value, @NotNull Map<String, Object> context) {
            if (key.equals("exodus.env.storeGetCacheSize") || key.equals("exodus.env.storeGetCache.minTreeSize") || key.equals("exodus.env.storeGetCache.maxValueSize")) {
                EnvironmentImpl.this.invalidateStoreGetCache();
            } else if (key.equals("exodus.log.syncPeriod")) {
                EnvironmentImpl.this.log.getConfig().setSyncPeriod(EnvironmentImpl.this.ec.getLogSyncPeriod());
            } else if (key.equals("exodus.log.durableWrite")) {
                EnvironmentImpl.this.log.getConfig().setDurableWrite(EnvironmentImpl.this.ec.getLogDurableWrite());
            } else if (key.equals("exodus.env.isReadonly") && !EnvironmentImpl.this.ec.getEnvIsReadonly()) {
                EnvironmentImpl.this.resumeGC();
            } else if (key.equals("exodus.gc.utilization.fromScratch") && EnvironmentImpl.this.ec.getGcUtilizationFromScratch()) {
                EnvironmentImpl.this.gc.getUtilizationProfile().computeUtilizationFromScratch();
            } else if (key.equals("exodus.gc.utilization.fromFile")) {
                EnvironmentImpl.this.gc.getUtilizationProfile().loadUtilizationFromFile((String)value);
            } else if (key.equals("exodus.tree.maxPageSize")) {
                EnvironmentImpl.this.balancePolicy = null;
            } else if (key.equals("exodus.tree.dupMaxPageSize")) {
                EnvironmentImpl.this.balancePolicy = null;
            } else if (key.equals("exodus.log.cache.readAheadMultiple")) {
                EnvironmentImpl.this.log.getConfig().setCacheReadAheadMultiple(EnvironmentImpl.this.ec.getLogCacheReadAheadMultiple());
            }
        }
    }
}

