/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.HplMojo;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;

@Mojo(name="test-hpl", requiresDependencyResolution=ResolutionScope.TEST)
public class TestHplMojo
extends HplMojo {
    @Component
    protected PluginWorkspaceMap pluginWorkspaceMap;

    @Override
    protected File computeHplFile() throws MojoExecutionException {
        File testDir = new File(this.project.getBuild().getTestOutputDirectory());
        try {
            Files.createDirectories(testDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + testDir + "'", (Exception)e);
        }
        File theHpl = new File(testDir, "the.hpl");
        if (this.project.getArtifact().isSnapshot()) {
            try {
                this.pluginWorkspaceMap.write(this.project.getArtifact().getId(), theHpl);
            }
            catch (IOException x) {
                this.getLog().error((Throwable)x);
            }
        }
        return theHpl;
    }
}

