/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;

@Named
@Singleton
public class PluginWorkspaceMapImpl
implements PluginWorkspaceMap {
    private final File mapFile;

    public PluginWorkspaceMapImpl(File mapFile) {
        this.mapFile = mapFile;
    }

    public PluginWorkspaceMapImpl() {
        this.mapFile = new File(System.getProperty("user.home"), ".jenkins-hpl-map");
    }

    private Properties loadMap() throws IOException {
        Properties p = new Properties();
        if (this.mapFile.isFile()) {
            try (FileInputStream is = new FileInputStream(this.mapFile);){
                p.load(is);
            }
            catch (IllegalArgumentException x) {
                throw new IOException("Malformed " + this.mapFile + ": " + x, x);
            }
        }
        return p;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="TODO needs triage")
    public File read(String id) throws IOException {
        for (Map.Entry<Object, Object> entry : this.loadMap().entrySet()) {
            String path;
            File f;
            if (!entry.getValue().equals(id) || !(f = new File(path = (String)entry.getKey())).exists()) continue;
            return f;
        }
        return null;
    }

    @Override
    public void write(String id, File f) throws IOException {
        Properties p = this.loadMap();
        p.setProperty(f.getAbsolutePath(), id);
        try (FileOutputStream os = new FileOutputStream(this.mapFile);){
            p.store(os, " List of development files for Jenkins plugins that have been built.");
        }
    }
}

