/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

public class MavenArtifact
implements Comparable<MavenArtifact> {
    public final ArtifactFactory artifactFactory;
    public final ProjectBuilder builder;
    public final org.apache.maven.artifact.Artifact artifact;
    public final RepositorySystem repositorySystem;
    public final MavenSession session;
    public final MavenProject project;

    public MavenArtifact(org.apache.maven.artifact.Artifact artifact, RepositorySystem repositorySystem, ArtifactFactory artifactFactory, ProjectBuilder builder, MavenSession session, MavenProject project) {
        this.artifact = artifact;
        this.repositorySystem = repositorySystem;
        this.artifactFactory = artifactFactory;
        this.builder = builder;
        this.session = Objects.requireNonNull(session);
        this.project = Objects.requireNonNull(project);
    }

    public MavenProject resolvePom() throws ProjectBuildingException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProcessPlugins(false);
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        buildingRequest.setValidationLevel(0);
        return this.builder.build(this.artifact, (ProjectBuildingRequest)buildingRequest).getProject();
    }

    public boolean isPlugin() throws IOException {
        String type = this.getResolvedType();
        return type.equals("hpi") || type.equals("jpi");
    }

    public boolean isPluginBestEffort(Log log) {
        try {
            return this.isPlugin();
        }
        catch (IOException x) {
            if (log.isDebugEnabled()) {
                log.debug((Throwable)x);
            } else {
                log.warn((CharSequence)x.getCause().getMessage());
            }
            return false;
        }
    }

    public String getId() {
        return this.artifact.getId();
    }

    public String getDefaultFinalName() {
        StringBuilder path = new StringBuilder();
        path.append(this.artifact.getArtifactId());
        path.append('-');
        path.append(this.artifact.getVersion());
        if (this.artifact.getClassifier() != null && !this.artifact.getClassifier().isEmpty()) {
            path.append('-');
            path.append(this.artifact.getClassifier());
        }
        if (!this.artifact.getArtifactHandler().getExtension().isEmpty()) {
            path.append('.');
            path.append(this.artifact.getArtifactHandler().getExtension());
        }
        return path.toString();
    }

    public boolean isOptional() {
        return this.artifact.isOptional();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public File getFile() throws MojoExecutionException {
        if (this.artifact.getFile() == null) {
            return MavenArtifact.resolveArtifact(this.artifact, this.project, this.session, this.repositorySystem).getFile();
        }
        return this.artifact.getFile();
    }

    static org.apache.maven.artifact.Artifact resolveArtifact(org.apache.maven.artifact.Artifact artifact, MavenProject project, MavenSession session, RepositorySystem repositorySystem) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact resolved;
        ArtifactDescriptorResult descriptorResult;
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        List remoteRepositories = RepositoryUtils.toRepos((List)buildingRequest.getRemoteRepositories());
        RepositorySystemSession repositorySession = buildingRequest.getRepositorySession();
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact), remoteRepositories, null);
        try {
            descriptorResult = repositorySystem.readArtifactDescriptor(repositorySession, descriptorRequest);
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException("Failed to read artifact descriptor: " + artifact, (Exception)((Object)e));
        }
        ArtifactRequest request = new ArtifactRequest(descriptorResult.getArtifact(), remoteRepositories, null);
        try {
            resolved = RepositoryUtils.toArtifact((Artifact)repositorySystem.resolveArtifact(repositorySession, request).getArtifact());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve artifact: " + artifact, (Exception)((Object)e));
        }
        if (resolved.getFile().isDirectory() && buildingRequest.getRepositorySession() instanceof DefaultRepositorySystemSession) {
            DefaultRepositorySystemSession oldRepositorySession = (DefaultRepositorySystemSession)buildingRequest.getRepositorySession();
            DefaultRepositorySystemSession newRepositorySession = new DefaultRepositorySystemSession((RepositorySystemSession)oldRepositorySession);
            newRepositorySession.setWorkspaceReader(null);
            newRepositorySession.setReadOnly();
            try {
                resolved = RepositoryUtils.toArtifact((Artifact)repositorySystem.resolveArtifact((RepositorySystemSession)newRepositorySession, request).getArtifact());
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failed to resolve artifact: " + artifact, (Exception)((Object)e));
            }
        }
        return resolved;
    }

    public MavenArtifact getHpi() throws IOException {
        org.apache.maven.artifact.Artifact a = this.artifactFactory.createArtifact(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getVersion(), "compile", this.getResolvedType());
        return new MavenArtifact(a, this.repositorySystem, this.artifactFactory, this.builder, this.session, this.project);
    }

    public List<String> getDependencyTrail() {
        return this.artifact.getDependencyTrail();
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getScope() {
        return this.artifact.getScope();
    }

    public boolean hasScope(String ... scopes) {
        for (String s : scopes) {
            if (s == null && this.artifact.getScope() == null) {
                return true;
            }
            if (s == null || !s.equals(this.artifact.getScope())) continue;
            return true;
        }
        return false;
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        return this.artifact.getVersion();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public ArtifactHandler getArtifactHandler() {
        return this.artifact.getArtifactHandler();
    }

    public String getActualArtifactId() throws IOException, MojoExecutionException {
        File file = this.getFile();
        if (file != null && file.isFile()) {
            try (JarFile jf = new JarFile(file);){
                String string = jf.getManifest().getMainAttributes().getValue("Short-Name");
                return string;
            }
        }
        return this.getArtifactId();
    }

    public String getActualVersion() throws IOException, MojoExecutionException {
        File file = this.getFile();
        if (file != null && file.isFile()) {
            try (JarFile jf = new JarFile(file);){
                String string = jf.getManifest().getMainAttributes().getValue("Plugin-Version").replaceFirst(" [(].+[)]$", "");
                return string;
            }
        }
        return this.getVersion();
    }

    public ArtifactVersion getVersionNumber() throws OverConstrainedVersionException {
        return this.artifact.getSelectedVersion();
    }

    public boolean hasSameGAAs(MavenProject project) {
        return this.getGroupId().equals(project.getGroupId()) && this.getArtifactId().equals(project.getArtifactId());
    }

    public boolean isNewerThan(MavenArtifact rhs) {
        return new VersionNumber(this.getVersion()).compareTo(new VersionNumber(rhs.getVersion())) > 0;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int compareTo(MavenArtifact o) {
        return this.getId().compareTo(o.getId());
    }

    private String getResolvedType() throws IOException {
        try {
            String type = this.artifact.getType();
            if (!type.equals("jar")) {
                return type;
            }
            if (this.artifact.getClassifier() != null && !this.artifact.getClassifier().isEmpty()) {
                return type;
            }
            return this.resolvePom().getPackaging();
        }
        catch (ProjectBuildingException e) {
            throw new IOException("Failed to open artifact " + this.artifact + " at " + this.artifact.getFile() + ": " + e, e);
        }
    }
}

