/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.groovy.control.io.NullWriter;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="list-plugin-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ListPluginDependenciesMojo
extends AbstractHpiMojo {
    @Parameter(property="outputFile")
    protected File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try (Object w = this.outputFile == null ? new NullWriter() : new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), StandardCharsets.UTF_8);){
            for (MavenArtifact a : this.getDirectDependencyArtfacts()) {
                if (!a.isPlugin()) continue;
                String line = String.format("%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.artifact.getBaseVersion());
                ((Writer)w).write(line);
                ((Writer)w).write(10);
                this.getLog().info((CharSequence)line);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to list plugin dependencies", (Exception)e);
        }
    }
}

