/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Result;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.ParameterType;
import org.jenkinsci.plugins.structs.describable.Setter;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.NoStaplerConstructorException;

public final class DescribableParameter {
    private final DescribableModel<?> parent;
    private ParameterType type;
    private final String name;
    private final Type rawType;
    final Setter setter;
    private static final Logger LOGGER = Logger.getLogger(DescribableParameter.class.getName());

    DescribableParameter(DescribableModel<?> parent, Type type, String name, Setter setter) {
        this.parent = parent;
        this.rawType = type;
        this.name = name;
        this.setter = setter;
    }

    public ParameterType getType() {
        if (this.type == null) {
            this.type = ParameterType.of(this.rawType);
        }
        return this.type;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public Class getErasedType() {
        return Types.erasure((Type)this.rawType);
    }

    public String getName() {
        return this.name;
    }

    public String getCapitalizedName() {
        return Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
    }

    public boolean isRequired() {
        return this.setter == null;
    }

    public boolean isDeprecated() {
        return this.setter != null && this.setter.isDeprecated();
    }

    @CheckForNull
    public String getHelp() throws IOException {
        return this.parent.getHelp("help-" + this.name + ".html");
    }

    void toString(StringBuilder b, Stack<Class<?>> modelTypes) {
        b.append(this.name);
        if (!this.isRequired()) {
            b.append('?');
        }
        if (this.isDeprecated()) {
            b.append("(deprecated)");
        }
        b.append(": ");
        this.getType().toString(b, modelTypes);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b, new Stack());
        return b.toString();
    }

    Object inspect(Object o) {
        return this.uncoerce(this.getValue(o), this.rawType);
    }

    private Object getValue(Object o) {
        Class<?> ownerClass = this.parent.getType();
        try {
            try {
                return ownerClass.getField(this.name).get(o);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    return ownerClass.getMethod("get" + this.getCapitalizedName(), new Class[0]).invoke(o, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return ownerClass.getMethod("is" + this.getCapitalizedName(), new Class[0]).invoke(o, new Object[0]);
                    }
                    catch (NoSuchMethodException x) {
                        throw new UnsupportedOperationException("no public field \u2018" + this.name + "\u2019 (or getter method) found in " + ownerClass);
                    }
                }
            }
        }
        catch (UnsupportedOperationException x) {
            throw x;
        }
        catch (Exception x) {
            throw new UnsupportedOperationException(x);
        }
    }

    private Object uncoerce(Object o, Type type) {
        if (type instanceof Class && ((Class)type).isEnum() && o instanceof Enum) {
            return ((Enum)o).name();
        }
        if (type == URL.class && o instanceof URL) {
            return o.toString();
        }
        if (type == Result.class && o instanceof Result) {
            return o.toString();
        }
        if ((type == Character.class || type == Character.TYPE) && o instanceof Character) {
            return o.toString();
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (Object elt : array) {
                list.add(this.uncoerce(elt, array.getClass().getComponentType()));
            }
            return list;
        }
        if (o instanceof Collection && Types.isSubClassOf((Type)type, Collection.class)) {
            ArrayList<Object> list = new ArrayList<Object>(((Collection)o).size());
            for (Object elt : (Collection)o) {
                list.add(this.uncoerce(elt, Types.getTypeArgument((Type)Types.getBaseClass((Type)type, Collection.class), (int)0, Object.class)));
            }
            return list;
        }
        if (o != null && !o.getClass().getName().startsWith("java.")) {
            try {
                UninstantiatedDescribable nested = DescribableModel.uninstantiate2_(o);
                if (type != o.getClass()) {
                    int simpleNameCount = 0;
                    for (Class<?> c : DescribableModel.findSubtypes(Types.erasure((Type)type))) {
                        if (!c.getSimpleName().equals(o.getClass().getSimpleName())) continue;
                        ++simpleNameCount;
                    }
                    if (simpleNameCount > 1) {
                        nested.setKlass(o.getClass().getName());
                    } else {
                        nested.setKlass(o.getClass().getSimpleName());
                    }
                }
                nested.setSymbol(DescribableModel.symbolOf(o));
                return nested;
            }
            catch (UnsupportedOperationException x) {
                if (!(x.getCause() instanceof NoStaplerConstructorException)) {
                    LOGGER.log(Level.WARNING, "failed to uncoerce " + o, x);
                }
            }
            catch (NoStaplerConstructorException noStaplerConstructorException) {
                // empty catch block
            }
        }
        return o;
    }
}

