/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.test.PipelineTestDetails;
import hudson.tasks.test.TestResultParser;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

@Extension
public class JUnitParser
extends TestResultParser {
    private static final Logger LOGGER = Logger.getLogger(JUnitParser.class.getName());
    private final StdioRetention stdioRetention;
    private final boolean keepProperties;
    private final boolean allowEmptyResults;
    private final boolean keepTestNames;
    private final boolean skipOldReports;

    @Deprecated
    public JUnitParser() {
        this(false, false, false, false);
    }

    @Deprecated
    public JUnitParser(boolean keepLongStdio) {
        this(keepLongStdio, false, false, false);
    }

    @Deprecated
    public JUnitParser(boolean keepLongStdio, boolean allowEmptyResults) {
        this(StdioRetention.fromKeepLongStdio(keepLongStdio), false, allowEmptyResults, false, false);
    }

    @Deprecated
    public JUnitParser(boolean keepLongStdio, boolean keepProperties, boolean allowEmptyResults, boolean skipOldReports) {
        this(StdioRetention.fromKeepLongStdio(keepLongStdio), keepProperties, allowEmptyResults, skipOldReports, false);
    }

    @Deprecated
    public JUnitParser(StdioRetention stdioRetention, boolean keepProperties, boolean allowEmptyResults, boolean skipOldReports) {
        this(stdioRetention, keepProperties, allowEmptyResults, skipOldReports, false);
    }

    public JUnitParser(StdioRetention stdioRetention, boolean keepProperties, boolean allowEmptyResults, boolean skipOldReports, boolean keepTestNames) {
        this.stdioRetention = stdioRetention;
        this.keepProperties = keepProperties;
        this.allowEmptyResults = allowEmptyResults;
        this.keepTestNames = keepTestNames;
        this.skipOldReports = skipOldReports;
    }

    @Override
    public String getDisplayName() {
        return Messages.JUnitParser_DisplayName();
    }

    @Override
    public String getTestResultLocationMessage() {
        return Messages.JUnitParser_TestResultLocationMessage();
    }

    @Override
    @Deprecated
    public TestResult parse(String testResultLocations, AbstractBuild build, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return (TestResult)super.parse(testResultLocations, build, launcher, listener);
    }

    @Override
    @Deprecated
    public TestResult parseResult(String testResultLocations, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return this.parseResult(testResultLocations, (Run)build, (PipelineTestDetails)null, workspace, launcher, listener);
    }

    @Override
    public TestResult parseResult(String testResultLocations, Run<?, ?> build, PipelineTestDetails pipelineTestDetails, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return (TestResult)workspace.act((FilePath.FileCallable)new DirectParseResultCallable(testResultLocations, build, this.stdioRetention, this.keepProperties, this.allowEmptyResults, this.keepTestNames, pipelineTestDetails, listener, this.skipOldReports));
    }

    public TestResultSummary summarizeResult(String testResultLocations, Run<?, ?> build, PipelineTestDetails pipelineTestDetails, FilePath workspace, Launcher launcher, TaskListener listener, JunitTestResultStorage storage) throws InterruptedException, IOException {
        return (TestResultSummary)workspace.act((FilePath.FileCallable)new StorageParseResultCallable(testResultLocations, build, this.stdioRetention, this.keepProperties, this.allowEmptyResults, this.keepTestNames, pipelineTestDetails, listener, storage.createRemotePublisher(build), this.skipOldReports));
    }

    private static final class DirectParseResultCallable
    extends ParseResultCallable<TestResult> {
        DirectParseResultCallable(String testResults, Run<?, ?> build, StdioRetention stdioRetention, boolean keepProperties, boolean allowEmptyResults, boolean keepTestNames, PipelineTestDetails pipelineTestDetails, TaskListener listener, boolean skipOldReports) {
            super(testResults, build, stdioRetention, keepProperties, allowEmptyResults, keepTestNames, pipelineTestDetails, listener, skipOldReports);
        }

        @Override
        protected TestResult handle(TestResult result) throws IOException {
            return result;
        }
    }

    private static final class StorageParseResultCallable
    extends ParseResultCallable<TestResultSummary> {
        private final JunitTestResultStorage.RemotePublisher publisher;

        StorageParseResultCallable(String testResults, Run<?, ?> build, StdioRetention stdioRetention, boolean keepProperties, boolean allowEmptyResults, boolean keepTestNames, PipelineTestDetails pipelineTestDetails, TaskListener listener, JunitTestResultStorage.RemotePublisher publisher, boolean skipOldReports) {
            super(testResults, build, stdioRetention, keepProperties, allowEmptyResults, keepTestNames, pipelineTestDetails, listener, skipOldReports);
            this.publisher = publisher;
        }

        @Override
        protected TestResultSummary handle(TestResult result) throws IOException {
            this.publisher.publish(result, this.listener);
            return new TestResultSummary(result);
        }
    }

    private static abstract class ParseResultCallable<T>
    extends MasterToSlaveFileCallable<T> {
        private static final Logger LOGGER = Logger.getLogger(ParseResultCallable.class.getName());
        private final long buildStartTimeInMillis;
        private final long buildTimeInMillis;
        private final String testResults;
        private final long nowMaster;
        private final StdioRetention stdioRetention;
        private final boolean keepProperties;
        private final boolean keepTestNames;
        private final boolean allowEmptyResults;
        private final PipelineTestDetails pipelineTestDetails;
        private final TaskListener listener;
        private boolean skipOldReports;

        private ParseResultCallable(String testResults, Run<?, ?> build, StdioRetention stdioRetention, boolean keepProperties, boolean allowEmptyResults, boolean keepTestNames, PipelineTestDetails pipelineTestDetails, TaskListener listener, boolean skipOldReports) {
            this.buildStartTimeInMillis = build.getStartTimeInMillis();
            this.buildTimeInMillis = build.getTimeInMillis();
            this.testResults = testResults;
            this.nowMaster = System.currentTimeMillis();
            this.stdioRetention = stdioRetention;
            this.keepProperties = keepProperties;
            this.keepTestNames = keepTestNames;
            this.allowEmptyResults = allowEmptyResults;
            this.pipelineTestDetails = pipelineTestDetails;
            this.listener = listener;
            this.skipOldReports = skipOldReports;
        }

        public T invoke(File ws, VirtualChannel channel) throws IOException {
            TestResult result;
            long nowSlave = System.currentTimeMillis();
            FileSet fs = Util.createFileSet((File)ws, (String)this.testResults);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length > 0) {
                long filesTimestamp = Math.min(this.buildStartTimeInMillis, this.buildTimeInMillis);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("buildStartTimeInMillis:" + this.buildStartTimeInMillis + ",buildTimeInMillis:" + this.buildTimeInMillis + ",filesTimestamp:" + filesTimestamp + ",nowSlave:" + nowSlave + ",nowMaster:" + this.nowMaster);
                }
                result = new TestResult(filesTimestamp, ds, this.stdioRetention, this.keepProperties, this.keepTestNames, this.pipelineTestDetails, this.skipOldReports);
                result.tally();
            } else if (this.allowEmptyResults) {
                this.listener.getLogger().println(Messages.JUnitResultArchiver_NoTestReportFound());
                result = new TestResult();
            } else {
                throw new AbortException(Messages.JUnitResultArchiver_NoTestReportFound());
            }
            return this.handle(result);
        }

        protected abstract T handle(TestResult var1) throws IOException;
    }
}

