/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import hudson.plugins.ec2.win.winrm.WinRM;
import hudson.plugins.ec2.win.winrm.WindowsProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WinConnection {
    private static final Logger LOGGER = Logger.getLogger(WinConnection.class.getName());
    private final String host;
    private final String username;
    private final String password;
    private final SMBClient smbclient;
    private final AuthenticationContext authentication;
    private Connection connection;
    private Session session;
    private boolean useHTTPS;
    private static final int TIMEOUT = 8000;
    private boolean allowSelfSignedCertificate;

    @Deprecated
    public WinConnection(String host, String username, String password) {
        this(host, username, password, true);
    }

    public WinConnection(String host, String username, String password, boolean allowSelfSignedCertificate) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.smbclient = new SMBClient();
        this.authentication = new AuthenticationContext(username, password.toCharArray(), null);
        this.allowSelfSignedCertificate = allowSelfSignedCertificate;
    }

    public WinRM winrm() {
        WinRM winrm = new WinRM(this.host, this.username, this.password, this.allowSelfSignedCertificate);
        winrm.setUseHTTPS(this.useHTTPS);
        return winrm;
    }

    public WinRM winrm(int timeout) {
        WinRM winrm = this.winrm();
        winrm.setTimeout(timeout);
        return winrm;
    }

    public WindowsProcess execute(String commandLine) {
        return this.execute(commandLine, 60);
    }

    public WindowsProcess execute(String commandLine, int timeout) {
        return this.winrm(timeout).execute(commandLine);
    }

    private DiskShare getSmbShare(String path) throws IOException {
        if (this.connection == null) {
            this.connection = this.smbclient.connect(this.host);
        }
        if (this.session == null) {
            this.session = this.connection.authenticate(this.authentication);
        }
        return (DiskShare)this.session.connectShare(WinConnection.toAdministrativeShare(path));
    }

    public OutputStream putFile(String path) throws IOException {
        return this.getSmbShare(path).openFile(WinConnection.toFilePath(path), EnumSet.of(AccessMask.GENERIC_READ, AccessMask.GENERIC_WRITE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null).getOutputStream();
    }

    public InputStream getFile(String path) throws IOException {
        return this.getSmbShare(path).openFile(WinConnection.toFilePath(path), EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, null, null).getInputStream();
    }

    public boolean exists(String path) throws IOException {
        return this.getSmbShare(path).fileExists(WinConnection.toFilePath(path));
    }

    private static String toAdministrativeShare(String path) {
        return path.substring(0, 1) + "$";
    }

    private static String toFilePath(String path) {
        return path.substring(3);
    }

    public boolean ping() {
        try {
            return this.pingFailingIfSSHHandShakeError();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean pingFailingIfSSHHandShakeError() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to close session", e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to close connection", e);
            }
        }
        if (this.smbclient != null) {
            try {
                this.smbclient.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to close smbclient", e);
            }
        }
    }

    public void setUseHTTPS(boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }

    private /* synthetic */ String lambda$pingFailingIfSSHHandShakeError$0() {
        return "checking SMB connection to " + this.host;
    }
}

