/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.WindowsData;
import hudson.plugins.ec2.win.Messages;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class SelfSignedCertificateAllowedMonitor
extends AdministrativeMonitor {
    private static final int MAX_TEMPLATES_FOUND = 5;
    List<String> insecureTemplates = new ArrayList<String>(5);

    public String getDisplayName() {
        return Messages.AdminMonitor_DisplayName();
    }

    public String getSelfSignedCertAllowedTemplates() {
        return String.join((CharSequence)", ", this.insecureTemplates);
    }

    public boolean isActivated() {
        boolean maxTemplatesReached = false;
        ListIterator cloudIterator = Jenkins.get().clouds.listIterator();
        this.insecureTemplates.clear();
        while (cloudIterator.hasNext() && !maxTemplatesReached) {
            Cloud cloud = (Cloud)cloudIterator.next();
            if (!(cloud instanceof EC2Cloud)) continue;
            maxTemplatesReached = this.gatherInsecureTemplate((EC2Cloud)cloud);
        }
        return !this.insecureTemplates.isEmpty();
    }

    private boolean gatherInsecureTemplate(EC2Cloud cloud) {
        List<SlaveTemplate> templates = cloud.getTemplates();
        for (SlaveTemplate template : templates) {
            if (!template.isWindowsSlave()) continue;
            AMITypeData amiTypeData = template.getAmiType();
            if (this.insecureTemplates.size() < 5 && amiTypeData.isWindows() && ((WindowsData)amiTypeData).isAllowSelfSignedCertificate()) {
                this.insecureTemplates.add(template.getDisplayName());
            }
            if (this.insecureTemplates.size() < 5) continue;
            return true;
        }
        return false;
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String dismiss) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (dismiss != null) {
            this.disable(true);
        }
        return HttpResponses.forwardToPreviousPage();
    }
}

