/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPair;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.plugins.ec2.EC2HostAddressProvider;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2Readiness;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.ssh.verifiers.HostKey;
import hudson.plugins.ec2.ssh.verifiers.HostKeyHelper;
import hudson.plugins.ec2.ssh.verifiers.Messages;
import hudson.remoting.Channel;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class EC2UnixLauncher
extends EC2ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2UnixLauncher.class.getName());
    private static final String BOOTSTRAP_AUTH_SLEEP_MS = "jenkins.ec2.bootstrapAuthSleepMs";
    private static final String BOOTSTRAP_AUTH_TRIES = "jenkins.ec2.bootstrapAuthTries";
    private static final String READINESS_SLEEP_MS = "jenkins.ec2.readinessSleepMs";
    private static final String READINESS_TRIES = "jenkins.ec2.readinessTries";
    private static int bootstrapAuthSleepMs = 30000;
    private static int bootstrapAuthTries = 30;
    private static int readinessSleepMs = 1000;
    private static int readinessTries = 120;

    protected void log(Level level, EC2Computer computer, TaskListener listener, String message) {
        EC2Cloud.log(LOGGER, level, listener, message);
    }

    protected void logException(EC2Computer computer, TaskListener listener, String message, Throwable exception) {
        EC2Cloud.log(LOGGER, Level.WARNING, listener, message, exception);
    }

    protected void logInfo(EC2Computer computer, TaskListener listener, String message) {
        this.log(Level.INFO, computer, listener, message);
    }

    protected void logWarning(EC2Computer computer, TaskListener listener, String message) {
        this.log(Level.WARNING, computer, listener, message);
    }

    protected String buildUpCommand(EC2Computer computer, String command) {
        String remoteAdmin = computer.getRemoteAdmin();
        if (remoteAdmin != null && !remoteAdmin.equals("root")) {
            command = computer.getRootCommandPrefix() + " " + (String)command;
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchScript(EC2Computer computer, TaskListener listener) throws IOException, AmazonClientException, InterruptedException {
        Connection cleanupConn = null;
        boolean successful = false;
        PrintStream logger = listener.getLogger();
        EC2AbstractSlave node = computer.getNode();
        SlaveTemplate template = computer.getSlaveTemplate();
        if (node == null) {
            throw new IllegalStateException();
        }
        if (template == null) {
            throw new IOException("Could not find corresponding agent template for " + computer.getDisplayName());
        }
        if (node instanceof EC2Readiness) {
            EC2Readiness readinessNode = (EC2Readiness)((Object)node);
            int tries = readinessTries;
            while (tries-- > 0 && !readinessNode.isReady()) {
                this.logInfo(computer, listener, "Node still not ready. Current status: " + readinessNode.getEc2ReadinessStatus());
                Thread.sleep(readinessSleepMs);
            }
            if (!readinessNode.isReady()) {
                throw new AmazonClientException("Node still not ready, timed out after " + readinessTries * readinessSleepMs / 1000 + "s with status " + readinessNode.getEc2ReadinessStatus());
            }
        }
        this.logInfo(computer, listener, "Launching instance: " + node.getInstanceId());
        try {
            boolean isBootstrapped = this.bootstrap(computer, listener, template);
            if (isBootstrapped) {
                int bootDelay = node.getBootDelay();
                if (bootDelay > 0) {
                    this.logInfo(computer, listener, "SSH service responded. Waiting " + bootDelay + "ms for service to stabilize");
                    Thread.sleep(bootDelay);
                    this.logInfo(computer, listener, "SSH service should have stabilized");
                }
                this.logInfo(computer, listener, "connect fresh as root");
                cleanupConn = this.connectToSsh(computer, listener, template);
                KeyPair key = computer.getCloud().getKeyPair();
                if (key == null || !cleanupConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), "")) {
                    this.logWarning(computer, listener, "Authentication failed");
                    return;
                }
            } else {
                this.logWarning(computer, listener, "bootstrapresult failed");
                return;
            }
            final Connection conn = cleanupConn;
            SCPClient scp = conn.createSCPClient();
            String initScript = node.initScript;
            String tmpDir = Util.fixEmptyAndTrim((String)node.tmpDir) != null ? node.tmpDir : "/tmp";
            this.logInfo(computer, listener, "Creating tmp directory (" + tmpDir + ") if it does not exist");
            conn.exec("mkdir -p " + tmpDir, (OutputStream)logger);
            if (initScript != null && initScript.trim().length() > 0 && conn.exec("test -e ~/.hudson-run-init", (OutputStream)logger) != 0) {
                this.logInfo(computer, listener, "Executing init script");
                scp.put(initScript.getBytes("UTF-8"), "init.sh", tmpDir, "0700");
                Session sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(this.buildUpCommand(computer, tmpDir + "/init.sh"));
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                int exitStatus = this.waitCompletion(sess);
                if (exitStatus != 0) {
                    this.logWarning(computer, listener, "init script failed: exit code=" + exitStatus);
                    return;
                }
                sess.close();
                this.logInfo(computer, listener, "Creating ~/.hudson-run-init");
                sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(this.buildUpCommand(computer, "touch ~/.hudson-run-init"));
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                exitStatus = this.waitCompletion(sess);
                if (exitStatus != 0) {
                    this.logWarning(computer, listener, "init script failed: exit code=" + exitStatus);
                    return;
                }
                sess.close();
            }
            String javaPath = node.javaPath;
            this.executeRemote(computer, conn, javaPath + " -fullversion", "sudo amazon-linux-extras install java-openjdk11 -y; sudo yum install -y fontconfig java-11-openjdk", logger, listener);
            this.executeRemote(computer, conn, "which scp", "sudo yum install -y openssh-clients", logger, listener);
            this.logInfo(computer, listener, "Copying remoting.jar to: " + tmpDir);
            scp.put(Jenkins.get().getJnlpJars("remoting.jar").readFully(), "remoting.jar", tmpDir);
            String jvmopts = node.jvmopts;
            String prefix = computer.getSlaveCommandPrefix();
            String suffix = computer.getSlaveCommandSuffix();
            String remoteFS = node.getRemoteFS();
            String workDir = Util.fixEmptyAndTrim((String)remoteFS) != null ? remoteFS : tmpDir;
            String launchString = prefix + " " + javaPath + " " + (jvmopts != null ? jvmopts : "") + " -jar " + tmpDir + "/remoting.jar -workDir " + workDir + suffix;
            if (template.isConnectBySSHProcess()) {
                File identityKeyFile = this.createIdentityKeyFile(computer);
                String ec2HostAddress = EC2UnixLauncher.getEC2HostAddress(computer, template);
                File hostKeyFile = this.createHostKeyFile(computer, ec2HostAddress, listener);
                String userKnownHostsFileFlag = "";
                if (hostKeyFile != null) {
                    userKnownHostsFileFlag = String.format(" -o \"UserKnownHostsFile=%s\"", hostKeyFile.getAbsolutePath());
                }
                try {
                    String sshClientLaunchString = String.format("ssh -o StrictHostKeyChecking=%s%s%s -i %s %s@%s -p %d %s", template.getHostKeyVerificationStrategy().getSshCommandEquivalentFlag(), userKnownHostsFileFlag, EC2UnixLauncher.getEC2HostKeyAlgorithmFlag(computer), identityKeyFile.getAbsolutePath(), node.remoteAdmin, ec2HostAddress, node.getSshPort(), launchString);
                    this.logInfo(computer, listener, "Launching remoting agent (via SSH client process): " + sshClientLaunchString);
                    CommandLauncher commandLauncher = new CommandLauncher(sshClientLaunchString, null);
                    commandLauncher.launch((SlaveComputer)computer, listener);
                }
                finally {
                    if (!identityKeyFile.delete()) {
                        LOGGER.log(Level.WARNING, "Failed to delete identity key file");
                    }
                    if (hostKeyFile != null && !hostKeyFile.delete()) {
                        LOGGER.log(Level.WARNING, "Failed to delete host key file");
                    }
                }
            } else {
                this.logInfo(computer, listener, "Launching remoting agent (via Trilead SSH2 Connection): " + launchString);
                final Session sess = conn.openSession();
                sess.execCommand(launchString);
                computer.setChannel(sess.getStdout(), sess.getStdin(), logger, new Channel.Listener(){

                    public void onClosed(Channel channel, IOException cause) {
                        sess.close();
                        conn.close();
                    }
                });
            }
            successful = true;
        }
        finally {
            if (cleanupConn != null && (!successful || template.isConnectBySSHProcess())) {
                cleanupConn.close();
            }
        }
    }

    private boolean executeRemote(EC2Computer computer, Connection conn, String checkCommand, String command, PrintStream logger, TaskListener listener) throws IOException, InterruptedException {
        this.logInfo(computer, listener, "Verifying: " + checkCommand);
        if (conn.exec(checkCommand, (OutputStream)logger) != 0) {
            this.logInfo(computer, listener, "Installing: " + command);
            if (conn.exec(command, (OutputStream)logger) != 0) {
                this.logWarning(computer, listener, "Failed to install: " + command);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createIdentityKeyFile(EC2Computer computer) throws IOException {
        EC2PrivateKey ec2PrivateKey = computer.getCloud().resolvePrivateKey();
        String privateKey = "";
        if (ec2PrivateKey != null) {
            privateKey = ec2PrivateKey.getPrivateKey();
        }
        File tempFile = Files.createTempFile("ec2_", ".pem", new FileAttribute[0]).toFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
            try {
                writer.write(privateKey);
                writer.flush();
            }
            finally {
                writer.close();
                fileOutputStream.close();
            }
            FilePath filePath = new FilePath(tempFile);
            filePath.chmod(256);
            return tempFile;
        }
        catch (Exception e) {
            if (!tempFile.delete()) {
                LOGGER.log(Level.WARNING, "Failed to delete identity key file");
            }
            throw new IOException("Error creating temporary identity key file for connecting to EC2 agent.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private File createHostKeyFile(EC2Computer computer, String ec2HostAddress, TaskListener listener) throws IOException {
        HostKey ec2HostKey = HostKeyHelper.getInstance().getHostKey((Computer)computer);
        if (ec2HostKey == null) {
            return null;
        }
        File tempFile = Files.createTempFile("ec2_", "_known_hosts", new FileAttribute[0]).toFile();
        String knownHost = "";
        knownHost = String.format("%s %s %s", ec2HostAddress, ec2HostKey.getAlgorithm(), Base64.getEncoder().encodeToString(ec2HostKey.getKey()));
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            File file;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                writer.write(knownHost);
                writer.flush();
                FilePath filePath = new FilePath(tempFile);
                filePath.chmod(256);
                file = tempFile;
            }
            return file;
        }
        catch (Exception e) {
            if (!tempFile.delete()) {
                LOGGER.log(Level.WARNING, "Failed to delete known hosts key file");
            }
            throw new IOException("Error creating temporary known hosts file for connecting to EC2 agent.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bootstrap(EC2Computer computer, TaskListener listener, SlaveTemplate template) throws IOException, InterruptedException, AmazonClientException {
        this.logInfo(computer, listener, "bootstrap()");
        try (Connection bootstrapConn = null;){
            int tries = bootstrapAuthTries;
            boolean isAuthenticated = false;
            this.logInfo(computer, listener, "Getting keypair...");
            KeyPair key = computer.getCloud().getKeyPair();
            if (key == null) {
                this.logWarning(computer, listener, "Could not retrieve a valid key pair.");
                boolean bl = false;
                return bl;
            }
            this.logInfo(computer, listener, String.format("Using private key %s (SHA-1 fingerprint %s)", key.getKeyName(), key.getKeyFingerprint()));
            while (tries-- > 0) {
                this.logInfo(computer, listener, "Authenticating as " + computer.getRemoteAdmin());
                try {
                    bootstrapConn = this.connectToSsh(computer, listener, template);
                    isAuthenticated = bootstrapConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), "");
                }
                catch (IOException e) {
                    this.logException(computer, listener, "Exception trying to authenticate", e);
                    bootstrapConn.close();
                }
                if (isAuthenticated) break;
                this.logWarning(computer, listener, "Authentication failed. Trying again...");
                Thread.sleep(bootstrapAuthSleepMs);
            }
            if (!isAuthenticated) {
                this.logWarning(computer, listener, "Authentication failed");
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private Connection connectToSsh(EC2Computer computer, TaskListener listener, SlaveTemplate template) throws AmazonClientException, InterruptedException {
        EC2AbstractSlave node = computer.getNode();
        long timeout = node == null ? 0L : node.getLaunchTimeoutInMillis();
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                Proxy proxy;
                long waitTime = System.currentTimeMillis() - startTime;
                if (timeout > 0L && waitTime > timeout) {
                    throw new AmazonClientException("Timed out after " + waitTime / 1000L + " seconds of waiting for ssh to become available. (maximum timeout configured is " + timeout / 1000L + ")");
                }
                String host = EC2UnixLauncher.getEC2HostAddress(computer, template);
                if (node instanceof EC2SpotSlave && computer.getInstanceId() == null) {
                    this.logInfo(computer, listener, "empty instanceId for Spot Slave.");
                    throw new IOException("goto sleep");
                }
                if (StringUtils.isBlank((String)host)) {
                    this.logWarning(computer, listener, "Empty host, your host is most likely waiting for an ip address.");
                    throw new IOException("goto sleep");
                }
                if ("0.0.0.0".equals(host)) {
                    this.logWarning(computer, listener, "Invalid host 0.0.0.0, your host is most likely waiting for an ip address.");
                    throw new IOException("goto sleep");
                }
                int port = computer.getSshPort();
                Integer slaveConnectTimeout = Integer.getInteger("jenkins.ec2.slaveConnectTimeout", 10000);
                this.logInfo(computer, listener, "Connecting to " + host + " on port " + port + ", with timeout " + slaveConnectTimeout + ".");
                Connection conn = new Connection(host, port);
                ProxyConfiguration proxyConfig = Jenkins.get().proxy;
                Proxy proxy2 = proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(host);
                if (!proxy.equals(Proxy.NO_PROXY) && proxy.address() instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    HTTPProxyData proxyData = null;
                    proxyData = null != proxyConfig.getUserName() ? new HTTPProxyData(address.getHostName(), address.getPort(), proxyConfig.getUserName(), proxyConfig.getPassword()) : new HTTPProxyData(address.getHostName(), address.getPort());
                    conn.setProxyData((ProxyData)proxyData);
                    this.logInfo(computer, listener, "Using HTTP Proxy Configuration");
                }
                conn.connect((ServerHostKeyVerifier)new ServerHostKeyVerifierImpl(computer, listener), slaveConnectTimeout.intValue(), slaveConnectTimeout.intValue());
                this.logInfo(computer, listener, "Connected via SSH.");
                return conn;
            }
            catch (IOException e) {
                this.logInfo(computer, listener, "Failed to connect via ssh: " + e.getMessage());
                if (computer.isOffline() && StringUtils.isNotBlank((String)computer.getOfflineCauseReason()) && computer.getOfflineCauseReason().equals(Messages.OfflineCause_SSHKeyCheckFailed())) {
                    throw new AmazonClientException("The connection couldn't be established and the computer is now offline", (Throwable)e);
                }
                this.logInfo(computer, listener, "Waiting for SSH to come up. Sleeping 5.");
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
    }

    private static String getEC2HostAddress(EC2Computer computer, SlaveTemplate template) throws InterruptedException {
        Instance instance = computer.updateInstanceDescription();
        ConnectionStrategy strategy = template.connectionStrategy;
        return EC2HostAddressProvider.unix(instance, strategy);
    }

    private static String getEC2HostKeyAlgorithmFlag(EC2Computer computer) throws IOException {
        HostKey ec2HostKey = HostKeyHelper.getInstance().getHostKey((Computer)computer);
        if (ec2HostKey != null) {
            return String.format(" -o \"HostKeyAlgorithms=%s\"", ec2HostKey.getAlgorithm());
        }
        return "";
    }

    private int waitCompletion(Session session) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(100L);
        }
        return -1;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    static {
        String prop = System.getProperty(BOOTSTRAP_AUTH_SLEEP_MS);
        if (prop != null) {
            bootstrapAuthSleepMs = Integer.parseInt(prop);
        }
        if ((prop = System.getProperty(BOOTSTRAP_AUTH_TRIES)) != null) {
            bootstrapAuthTries = Integer.parseInt(prop);
        }
        if ((prop = System.getProperty(READINESS_TRIES)) != null) {
            readinessTries = Integer.parseInt(prop);
        }
        if ((prop = System.getProperty(READINESS_SLEEP_MS)) != null) {
            readinessSleepMs = Integer.parseInt(prop);
        }
    }

    private static class ServerHostKeyVerifierImpl
    implements ServerHostKeyVerifier {
        private final EC2Computer computer;
        private final TaskListener listener;

        public ServerHostKeyVerifierImpl(EC2Computer computer, TaskListener listener) {
            this.computer = computer;
            this.listener = listener;
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            SlaveTemplate template = this.computer.getSlaveTemplate();
            return template != null && template.getHostKeyVerificationStrategy().getStrategy().verify(this.computer, new HostKey(serverHostKeyAlgorithm, serverHostKey), this.listener);
        }
    }
}

