/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.services.ec2.model.Filter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kohsuke.stapler.DataBoundConstructor;

public class EC2Filter
extends AbstractDescribableImpl<EC2Filter> {
    @NonNull
    private final String name;
    @NonNull
    private final String values;

    @DataBoundConstructor
    public EC2Filter(@NonNull String name, @NonNull String values) {
        this.name = Objects.requireNonNull(name);
        this.values = Objects.requireNonNull(values);
    }

    public String toString() {
        return "EC2Filter{name=\"" + this.name + "\", values=\"" + this.values + "\"}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EC2Filter other = (EC2Filter)((Object)o);
        return this.name.equals(other.name) && this.getValuesList().equals(other.getValuesList());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getValues() {
        return this.values;
    }

    @NonNull
    private List<String> getValuesList() {
        return Stream.of(Util.tokenize((String)this.values)).collect(Collectors.toList());
    }

    @NonNull
    public Filter toFilter() {
        return new Filter(this.name, this.getValuesList());
    }

    @NonNull
    public static List<Filter> toFilterList(@CheckForNull List<EC2Filter> filters) {
        return Util.fixNull(filters).stream().map(EC2Filter::toFilter).collect(Collectors.toList());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<EC2Filter> {
        public String getDisplayName() {
            return "";
        }
    }
}

