/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.MacData;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.Tenancy;
import hudson.plugins.ec2.UnixData;
import hudson.plugins.ec2.WindowsData;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.plugins.ec2.util.ResettableCountDownLatch;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public abstract class EC2AbstractSlave
extends Slave {
    public static final Boolean DEFAULT_METADATA_SUPPORTED = Boolean.TRUE;
    public static final Boolean DEFAULT_METADATA_ENDPOINT_ENABLED = Boolean.TRUE;
    public static final Boolean DEFAULT_METADATA_TOKENS_REQUIRED = Boolean.TRUE;
    public static final Integer DEFAULT_METADATA_HOPS_LIMIT = 1;
    public static final String DEFAULT_JAVA_PATH = "java";
    private static final Logger LOGGER = Logger.getLogger(EC2AbstractSlave.class.getName());
    protected String instanceId;
    public final String initScript;
    public final String tmpDir;
    public final String remoteAdmin;
    public final String templateDescription;
    public final String javaPath;
    public final String jvmopts;
    public final boolean stopOnTerminate;
    public final String idleTerminationMinutes;
    @Deprecated
    public transient boolean useDedicatedTenancy;
    public boolean isConnected = false;
    public List<EC2Tag> tags;
    public final String cloudName;
    public AMITypeData amiType;
    public int maxTotalUses;
    public final Tenancy tenancy;
    private String instanceType;
    private Boolean metadataSupported;
    private Boolean metadataEndpointEnabled;
    private Boolean metadataTokensRequired;
    private Integer metadataHopsLimit;
    public transient String publicDNS;
    public transient String privateDNS;
    protected transient Instance lastFetchInstance = null;
    protected transient long lastFetchTime;
    protected transient ResettableCountDownLatch terminateScheduled = new ResettableCountDownLatch(1, false);
    protected static final long MIN_FETCH_TIME = Long.getLong("hudson.plugins.ec2.EC2AbstractSlave.MIN_FETCH_TIME", TimeUnit.SECONDS.toMillis(20L));
    protected final int launchTimeout;
    @Deprecated
    protected transient int sshPort;
    @Deprecated
    public transient String rootCommandPrefix;
    @Deprecated
    public transient boolean usePrivateDnsName;
    public transient String slaveCommandPrefix;
    public transient String slaveCommandSuffix;
    private transient long createdTime;
    public static final String TEST_ZONE = "testZone";

    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String javaPath, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit, Boolean metadataSupported) throws Descriptor.FormException, IOException {
        super(name, remoteFS, launcher);
        this.setNumExecutors(numExecutors);
        this.setMode(mode);
        this.setLabelString(labelString);
        this.setRetentionStrategy(retentionStrategy);
        this.setNodeProperties(nodeProperties);
        this.instanceId = instanceId;
        this.templateDescription = templateDescription;
        this.initScript = initScript;
        this.tmpDir = tmpDir;
        this.remoteAdmin = remoteAdmin;
        this.javaPath = javaPath;
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.tags = tags;
        this.usePrivateDnsName = connectionStrategy == ConnectionStrategy.PRIVATE_DNS;
        this.useDedicatedTenancy = tenancy == Tenancy.Dedicated;
        this.cloudName = cloudName;
        this.launchTimeout = launchTimeout;
        this.amiType = amiType;
        this.maxTotalUses = maxTotalUses;
        this.tenancy = tenancy != null ? tenancy : Tenancy.Default;
        this.metadataEndpointEnabled = metadataEndpointEnabled;
        this.metadataTokensRequired = metadataTokensRequired;
        this.metadataHopsLimit = metadataHopsLimit;
        this.metadataSupported = metadataSupported;
        this.readResolve();
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String javaPath, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, DEFAULT_JAVA_PATH, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, tenancy, metadataEndpointEnabled, metadataTokensRequired, metadataHopsLimit, DEFAULT_METADATA_SUPPORTED);
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, DEFAULT_JAVA_PATH, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, tenancy, DEFAULT_METADATA_ENDPOINT_ENABLED, DEFAULT_METADATA_TOKENS_REQUIRED, DEFAULT_METADATA_HOPS_LIMIT);
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean useDedicatedTenancy, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, Tenancy.backwardsCompatible(useDedicatedTenancy));
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean usePrivateDnsName, boolean useDedicatedTenancy, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, useDedicatedTenancy, launchTimeout, amiType, ConnectionStrategy.backwardsCompatible(usePrivateDnsName, false, false), -1);
    }

    protected Object readResolve() {
        SlaveTemplate template;
        EC2Cloud cloud;
        EC2AbstractSlave o = (EC2AbstractSlave)((Object)super.readResolve());
        if (o.instanceId == null) {
            o.instanceId = this.getNodeName();
        }
        if (o.amiType == null) {
            o.amiType = new UnixData(o.rootCommandPrefix, o.slaveCommandPrefix, o.slaveCommandSuffix, Integer.toString(o.sshPort), null);
        }
        if (o.maxTotalUses == 0 && (cloud = this.getCloud()) != null && (template = cloud.getTemplate(o.templateDescription)) != null && template.getMaxTotalUses() == -1) {
            o.maxTotalUses = -1;
        }
        if (o.terminateScheduled == null) {
            o.terminateScheduled = new ResettableCountDownLatch(1, false);
        }
        return o;
    }

    public EC2Cloud getCloud() {
        return (EC2Cloud)Jenkins.get().getCloud(this.cloudName);
    }

    static int toNumExecutors(InstanceType it) {
        switch (it) {
            case T1Micro: {
                return 1;
            }
            case M1Small: {
                return 1;
            }
            case M1Medium: {
                return 2;
            }
            case M3Medium: {
                return 2;
            }
            case T3Nano: {
                return 2;
            }
            case T3aNano: {
                return 2;
            }
            case T3Micro: {
                return 2;
            }
            case T3aMicro: {
                return 2;
            }
            case T3Small: {
                return 2;
            }
            case T3aSmall: {
                return 2;
            }
            case T3Medium: {
                return 2;
            }
            case T3aMedium: {
                return 2;
            }
            case A1Large: {
                return 2;
            }
            case T3Large: {
                return 3;
            }
            case T3aLarge: {
                return 3;
            }
            case M1Large: {
                return 4;
            }
            case M3Large: {
                return 4;
            }
            case M4Large: {
                return 4;
            }
            case M5Large: {
                return 4;
            }
            case M5aLarge: {
                return 4;
            }
            case T3Xlarge: {
                return 5;
            }
            case T3aXlarge: {
                return 5;
            }
            case A1Xlarge: {
                return 5;
            }
            case C1Medium: {
                return 5;
            }
            case M2Xlarge: {
                return 6;
            }
            case C3Large: {
                return 7;
            }
            case C4Large: {
                return 7;
            }
            case C5Large: {
                return 7;
            }
            case C5dLarge: {
                return 7;
            }
            case M1Xlarge: {
                return 8;
            }
            case T32xlarge: {
                return 10;
            }
            case T3a2xlarge: {
                return 10;
            }
            case A12xlarge: {
                return 10;
            }
            case M22xlarge: {
                return 13;
            }
            case M3Xlarge: {
                return 13;
            }
            case M4Xlarge: {
                return 13;
            }
            case M5Xlarge: {
                return 13;
            }
            case M5aXlarge: {
                return 13;
            }
            case A14xlarge: {
                return 14;
            }
            case C3Xlarge: {
                return 14;
            }
            case C4Xlarge: {
                return 14;
            }
            case C5Xlarge: {
                return 14;
            }
            case C5dXlarge: {
                return 14;
            }
            case C1Xlarge: {
                return 20;
            }
            case M24xlarge: {
                return 26;
            }
            case M32xlarge: {
                return 26;
            }
            case M42xlarge: {
                return 26;
            }
            case M52xlarge: {
                return 26;
            }
            case M5a2xlarge: {
                return 26;
            }
            case G22xlarge: {
                return 26;
            }
            case C32xlarge: {
                return 28;
            }
            case C42xlarge: {
                return 28;
            }
            case C52xlarge: {
                return 28;
            }
            case C5d2xlarge: {
                return 28;
            }
            case Cc14xlarge: {
                return 33;
            }
            case Cg14xlarge: {
                return 33;
            }
            case Hi14xlarge: {
                return 35;
            }
            case Hs18xlarge: {
                return 35;
            }
            case C34xlarge: {
                return 55;
            }
            case C44xlarge: {
                return 55;
            }
            case C54xlarge: {
                return 55;
            }
            case C5d4xlarge: {
                return 55;
            }
            case M44xlarge: {
                return 55;
            }
            case M54xlarge: {
                return 55;
            }
            case M5a4xlarge: {
                return 55;
            }
            case Cc28xlarge: {
                return 88;
            }
            case Cr18xlarge: {
                return 88;
            }
            case C38xlarge: {
                return 108;
            }
            case C48xlarge: {
                return 108;
            }
            case C59xlarge: {
                return 108;
            }
            case C5d9xlarge: {
                return 108;
            }
            case M410xlarge: {
                return 120;
            }
            case M512xlarge: {
                return 120;
            }
            case M5a12xlarge: {
                return 120;
            }
            case M416xlarge: {
                return 160;
            }
            case C518xlarge: {
                return 216;
            }
            case C5d18xlarge: {
                return 216;
            }
            case M524xlarge: {
                return 240;
            }
            case M5a24xlarge: {
                return 240;
            }
            case Dl124xlarge: {
                return 250;
            }
            case Mac1Metal: {
                return 1;
            }
        }
        return 1;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Computer createComputer() {
        return new EC2Computer(this);
    }

    public static Instance getInstance(String instanceId, EC2Cloud cloud) {
        Instance i = null;
        try {
            i = CloudHelper.getInstanceWithRetry(instanceId, cloud);
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + instanceId + " Exception: " + e);
        }
        return i;
    }

    public abstract void terminate();

    void stop() {
        try {
            AmazonEC2 ec2 = this.getCloud().connect();
            StopInstancesRequest request = new StopInstancesRequest(Collections.singletonList(this.getInstanceId()));
            LOGGER.fine("Sending stop request for " + this.getInstanceId());
            ec2.stopInstances(request);
            LOGGER.info("EC2 instance stop request sent for " + this.getInstanceId());
            Computer computer = this.toComputer();
            if (computer != null) {
                computer.disconnect(null);
            }
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to stop EC2 instance: " + this.getInstanceId(), e);
        }
    }

    boolean terminateInstance() {
        try {
            AmazonEC2 ec2 = this.getCloud().connect();
            TerminateInstancesRequest request = new TerminateInstancesRequest(Collections.singletonList(this.getInstanceId()));
            LOGGER.fine("Sending terminate request for " + this.getInstanceId());
            ec2.terminateInstances(request);
            LOGGER.info("EC2 instance terminate request sent for " + this.getInstanceId());
            return true;
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
            return false;
        }
    }

    public Node reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        EC2AbstractSlave result = (EC2AbstractSlave)super.reconfigure(req, form);
        if (result != null) {
            this.clearLiveInstancedata();
            result.pushLiveInstancedata();
            return result;
        }
        return null;
    }

    public boolean isAcceptingTasks() {
        return this.terminateScheduled.getCount() == 0L;
    }

    void idleTimeout() {
        LOGGER.info("EC2 instance idle time expired: " + this.getInstanceId());
        if (!this.stopOnTerminate) {
            this.terminate();
        } else {
            this.stop();
        }
    }

    void launchTimeout() {
        LOGGER.info("EC2 instance failed to launch: " + this.getInstanceId());
        this.terminate();
    }

    public long getLaunchTimeoutInMillis() {
        return (long)this.launchTimeout * 1000L;
    }

    public String getRemoteAdmin() {
        if (this.remoteAdmin == null || this.remoteAdmin.length() == 0) {
            return this.amiType.isWindows() ? "Administrator" : "root";
        }
        return this.remoteAdmin;
    }

    String getRootCommandPrefix() {
        String commandPrefix;
        String string = this.amiType.isUnix() ? ((UnixData)this.amiType).getRootCommandPrefix() : (commandPrefix = this.amiType.isMac() ? ((MacData)this.amiType).getRootCommandPrefix() : "");
        if (commandPrefix == null || commandPrefix.length() == 0) {
            return "";
        }
        return commandPrefix + " ";
    }

    String getSlaveCommandPrefix() {
        String commandPrefix;
        String string = this.amiType.isUnix() ? ((UnixData)this.amiType).getSlaveCommandPrefix() : (commandPrefix = this.amiType.isMac() ? ((MacData)this.amiType).getSlaveCommandPrefix() : "");
        if (commandPrefix == null || commandPrefix.length() == 0) {
            return "";
        }
        return commandPrefix + " ";
    }

    String getSlaveCommandSuffix() {
        String commandSuffix;
        String string = this.amiType.isUnix() ? ((UnixData)this.amiType).getSlaveCommandSuffix() : (commandSuffix = this.amiType.isMac() ? ((MacData)this.amiType).getSlaveCommandSuffix() : "");
        if (commandSuffix == null || commandSuffix.length() == 0) {
            return "";
        }
        return " " + commandSuffix;
    }

    String getJavaPath() {
        return Util.fixNull((String)this.javaPath);
    }

    String getJvmopts() {
        return Util.fixNull((String)this.jvmopts);
    }

    public int getSshPort() {
        String sshPort;
        String string = this.amiType.isUnix() ? ((UnixData)this.amiType).getSshPort() : (sshPort = this.amiType.isMac() ? ((MacData)this.amiType).getSshPort() : "22");
        if (sshPort == null || sshPort.length() == 0) {
            return 22;
        }
        int port = 0;
        try {
            port = Integer.parseInt(sshPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port != 0 ? port : 22;
    }

    public boolean getStopOnTerminate() {
        return this.stopOnTerminate;
    }

    public void onConnected() {
        this.isConnected = true;
    }

    protected boolean isAlive(boolean force) {
        this.fetchLiveInstanceData(force);
        if (this.lastFetchInstance == null) {
            return false;
        }
        return !this.lastFetchInstance.getState().getName().equals(InstanceStateName.Terminated.toString());
    }

    private void fetchLiveInstanceData(boolean force) throws AmazonClientException {
        long now = System.currentTimeMillis();
        if (this.lastFetchTime > 0L && now - this.lastFetchTime < MIN_FETCH_TIME && !force) {
            return;
        }
        if (this.getInstanceId() == null || this.getInstanceId().isEmpty()) {
            return;
        }
        Instance i = null;
        try {
            i = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + this.getInstanceId() + " Exception: " + e);
            return;
        }
        this.lastFetchTime = now;
        this.lastFetchInstance = i;
        if (i == null) {
            return;
        }
        this.publicDNS = i.getPublicDnsName();
        this.privateDNS = i.getPrivateIpAddress();
        this.createdTime = i.getLaunchTime().getTime();
        this.instanceType = i.getInstanceType();
        if (!i.getTags().isEmpty()) {
            this.tags = new LinkedList<EC2Tag>();
            for (Tag t : i.getTags()) {
                this.tags.add(new EC2Tag(t.getKey(), t.getValue()));
            }
        }
    }

    protected void clearLiveInstancedata() throws AmazonClientException {
        Instance inst = null;
        try {
            inst = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + this.getInstanceId() + " Exception: " + e);
            return;
        }
        if (!this.tags.isEmpty()) {
            HashSet<Tag> instTags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                instTags.add(new Tag(t.getName(), t.getValue()));
            }
            List<String> resources = this.getResourcesToTag(inst);
            DeleteTagsRequest tagRequest = new DeleteTagsRequest();
            tagRequest.withResources(resources).setTags(instTags);
            this.getCloud().connect().deleteTags(tagRequest);
        }
    }

    protected void pushLiveInstancedata() throws AmazonClientException {
        Instance inst = null;
        try {
            inst = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + this.getInstanceId() + " Exception: " + e);
        }
        if (inst != null && this.tags != null && !this.tags.isEmpty()) {
            HashSet<Tag> instTags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                instTags.add(new Tag(t.getName(), t.getValue()));
            }
            List<String> resources = this.getResourcesToTag(inst);
            CreateTagsRequest tagRequest = new CreateTagsRequest();
            tagRequest.withResources(resources).setTags(instTags);
            this.getCloud().connect().createTags(tagRequest);
        }
    }

    private List<String> getResourcesToTag(Instance inst) {
        ArrayList<String> resources = new ArrayList<String>();
        resources.add(inst.getInstanceId());
        for (InstanceBlockDeviceMapping blockDeviceMapping : inst.getBlockDeviceMappings()) {
            resources.add(blockDeviceMapping.getEbs().getVolumeId());
        }
        return resources;
    }

    public String getPublicDNS() {
        this.fetchLiveInstanceData(false);
        return this.publicDNS;
    }

    public String getPrivateDNS() {
        this.fetchLiveInstanceData(false);
        return this.privateDNS;
    }

    public String getInstanceType() {
        this.fetchLiveInstanceData(false);
        return this.instanceType;
    }

    public List<EC2Tag> getTags() {
        this.fetchLiveInstanceData(false);
        return Collections.unmodifiableList(this.tags);
    }

    public long getCreatedTime() {
        this.fetchLiveInstanceData(false);
        return this.createdTime;
    }

    @Deprecated
    public boolean getUsePrivateDnsName() {
        return this.usePrivateDnsName;
    }

    public Secret getAdminPassword() {
        return this.amiType.isWindows() ? ((WindowsData)this.amiType).getPassword() : Secret.fromString((String)"");
    }

    public boolean isUseHTTPS() {
        return this.amiType.isWindows() && ((WindowsData)this.amiType).isUseHTTPS();
    }

    public int getBootDelay() {
        return this.amiType.getBootDelayInMillis();
    }

    public Boolean getMetadataSupported() {
        return this.metadataSupported;
    }

    public Boolean getMetadataEndpointEnabled() {
        return this.metadataEndpointEnabled;
    }

    public Boolean getMetadataTokensRequired() {
        return this.metadataTokensRequired;
    }

    public Integer getMetadataHopsLimit() {
        return this.metadataHopsLimit;
    }

    public boolean isSpecifyPassword() {
        return this.amiType.isWindows() && ((WindowsData)this.amiType).isSpecifyPassword();
    }

    public boolean isAllowSelfSignedCertificate() {
        return this.amiType.isWindows() && ((WindowsData)this.amiType).isAllowSelfSignedCertificate();
    }

    public static ListBoxModel fillZoneItems(AWSCredentialsProvider credentialsProvider, String region) {
        ListBoxModel model = new ListBoxModel();
        if (!StringUtils.isEmpty((String)region)) {
            AmazonEC2 client = AmazonEC2Factory.getInstance().connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region));
            DescribeAvailabilityZonesResult zones = client.describeAvailabilityZones();
            List zoneList = zones.getAvailabilityZones();
            model.add("<not specified>", "");
            for (AvailabilityZone z : zoneList) {
                model.add(z.getZoneName(), z.getZoneName());
            }
        }
        return model;
    }

    public abstract String getEc2Type();

    public static abstract class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public abstract String getDisplayName();

        public boolean isInstantiable() {
            return false;
        }

        @POST
        public ListBoxModel doFillZoneItems(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String roleArn, @QueryParameter String roleSessionName) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            return EC2AbstractSlave.fillZoneItems(credentialsProvider, region);
        }

        public List<Descriptor<AMITypeData>> getAMITypeDescriptors() {
            return Jenkins.get().getDescriptorList(AMITypeData.class);
        }
    }
}

